/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.predicates.zeno;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.combinators.ZenoStateBuilder;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.Substitution;
import bindead.domains.predicates.zeno.PredicatesState;
import javalx.data.Option;
import javalx.numeric.BigInt;
import javalx.persistentcollections.AVLSet;

class PredicatesStateBuilder
extends ZenoStateBuilder {
    private final PredicatesState.MutableState state;
    private final QueryChannel childState;

    public PredicatesStateBuilder(PredicatesState state, QueryChannel childState) {
        this.state = state.toMutable();
        this.childState = childState;
    }

    public PredicatesState build() {
        return this.state.toImmutable();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Childops: ");
        builder.append(this.getChildOps());
        builder.append('\n');
        builder.append(this.state);
        return builder.toString();
    }

    public boolean contains(NumVar variable) {
        return this.state.contains(variable);
    }

    public Iterable<Zeno.Test> getAllLhs() {
        return this.state.getAllLhs();
    }

    public Iterable<Zeno.Test> getAllLhsContaining(VarSet vars) {
        return this.state.getAllLhsContaining(vars);
    }

    public Iterable<Zeno.Test> getAllRhs() {
        return this.state.getAllRhs();
    }

    public Iterable<Zeno.Test> getAllRhsContaining(VarSet vars) {
        return this.state.getAllRhsContaining(vars);
    }

    public AVLSet<Zeno.Test> getConsequences(Zeno.Test predicate) {
        AVLSet<Zeno.Test> consequences = this.state.getConsequences(predicate);
        assert (!consequences.isEmpty());
        return consequences;
    }

    public AVLSet<Zeno.Test> getPremises(Zeno.Test predicate) {
        AVLSet<Zeno.Test> premises = this.state.getPremises(predicate);
        assert (!premises.isEmpty());
        return premises;
    }

    protected void addImplication(Zeno.Test premise, Zeno.Test consequence) {
        this.state.addImplication(premise, consequence);
    }

    protected void addImplications(Zeno.Test premise, AVLSet<Zeno.Test> consequences) {
        for (Zeno.Test consequence : consequences) {
            this.state.addImplication(premise, consequence);
        }
    }

    protected void project(NumVar variable) {
        if (!this.contains(variable)) {
            return;
        }
        Option<Substitution> substitution = this.getSubstitutionFor(variable);
        if (substitution.isSome()) {
            this.state.substituteInPredicates(substitution.get());
        }
        this.state.removePredicatesContaining(variable);
    }

    protected void substitute(NumVar x, NumVar y) {
        assert (!x.equalTo(y));
        if (!this.contains(x)) {
            return;
        }
        Substitution substitution = new Substitution(x, Linear.linear(y), BigInt.ONE);
        this.substitute(substitution);
    }

    protected void substitute(Substitution substitution) {
        this.state.substituteInPredicates(substitution);
    }

    private Option<Substitution> getSubstitutionFor(NumVar variable) {
        if (this.childState == null) {
            return Option.none();
        }
        SetOfEquations equalities = this.childState.queryEqualities(variable);
        if (equalities.isEmpty()) {
            return Option.none();
        }
        Substitution substitution = equalities.iterator().next().genSubstitution(variable);
        return Option.some(substitution);
    }

    protected void renameFold(FoldMap pairs) {
        for (VarPair pair : pairs) {
            this.substitute((NumVar)pair.getEphemeral(), (NumVar)pair.getPermanent());
        }
    }

    protected void renameExpand(FoldMap pairs) {
        for (VarPair pair : pairs) {
            this.substitute((NumVar)pair.getPermanent(), (NumVar)pair.getEphemeral());
        }
    }

    protected void copyAndPaste(VarSet vars, PredicatesStateBuilder other) {
        other.state.removePredicatesNotContaining(vars);
        this.union(other);
    }

    protected void union(PredicatesStateBuilder other) {
        this.state.union(other.state);
    }

    protected void intersect(PredicatesStateBuilder other) {
        this.state.intersect(other.state);
    }

    protected <D extends ZenoDomain<D>> boolean isSubset(PredicatesStateBuilder otherBuilder) {
        return PredicatesState.MutableState.isEntailed(otherBuilder.state, this.state, (ZenoDomain)this.childState);
    }

    protected <D extends ZenoDomain<D>> PredicatesStateBuilder join(PredicatesStateBuilder otherBuilder) {
        PredicatesState.MutableState entailedThisInOther = PredicatesState.MutableState.getEntailed(this.state, otherBuilder.state, (ZenoDomain)otherBuilder.childState);
        PredicatesState.MutableState entailedOtherInThis = PredicatesState.MutableState.getEntailed(otherBuilder.state, this.state, (ZenoDomain)this.childState);
        entailedThisInOther.union(entailedOtherInThis);
        return new PredicatesStateBuilder(entailedThisInOther.toImmutable(), this.childState);
    }
}

