/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.fields;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.fields.FieldStateBuilder;
import rreil.RReilGrammarException;
import rreil.lang.Rhs;
import rreil.lang.util.RhsVisitor;

class FieldVisitor<D extends FiniteDomain<D>>
implements RhsVisitor<Finite.Rhs, Void> {
    private static final FiniteFactory fin = FiniteFactory.getInstance();
    private final FieldStateBuilder<D> builder;

    protected FieldVisitor(FieldStateBuilder<D> builder) {
        this.builder = builder;
    }

    @Override
    public Finite.Rhs visit(Rhs.Bin expr, Void _) {
        Finite.Rhs l = expr.getLeft().accept(this, _);
        Finite.Rhs r = expr.getRight().accept(this, _);
        if (l instanceof Finite.Rlin && r instanceof Finite.Rlin) {
            return fin.binary((Finite.Rlin)l, expr.getOp(), (Finite.Rlin)r);
        }
        return null;
    }

    @Override
    public Finite.Rhs visit(Rhs.LinBin expr, Void _) {
        Finite.Rhs l = expr.getLeft().accept(this, _);
        Finite.Rhs r = expr.getRight().accept(this, _);
        if (l instanceof Finite.Rlin && r instanceof Finite.Rlin) {
            Finite.Rlin llin = (Finite.Rlin)l;
            Finite.Rlin rlin = (Finite.Rlin)r;
            switch (expr.getOp()) {
                case Add: {
                    return llin.add(rlin);
                }
                case Sub: {
                    return llin.sub(rlin);
                }
            }
            throw new RReilGrammarException();
        }
        return null;
    }

    @Override
    public Finite.Rhs visit(Rhs.LinScale expr, Void _) {
        Finite.Rhs opnd = expr.getOpnd().accept(this, _);
        if (opnd instanceof Finite.Rlin) {
            return ((Finite.Rlin)opnd).smul(expr.getConst());
        }
        return null;
    }

    @Override
    public Finite.Rhs visit(Rhs.LinRval expr, Void _) {
        Finite.Rhs opnd = expr.getRval().accept(this, _);
        return opnd;
    }

    @Override
    public Finite.Rhs visit(Rhs.Cmp expr, Void _) {
        Finite.Rhs l = expr.getLeft().accept(this, _);
        Finite.Rhs r = expr.getRight().accept(this, _);
        if (l instanceof Finite.Rlin && r instanceof Finite.Rlin) {
            return fin.comparison((Finite.Rlin)l, expr.getOp(), (Finite.Rlin)r);
        }
        return null;
    }

    @Override
    public Finite.Rhs visit(Rhs.SignExtend expr, Void _) {
        return fin.signExtend((Finite.Rlin)expr.getRhs().accept(this, _));
    }

    @Override
    public Finite.Rhs visit(Rhs.Convert expr, Void _) {
        return fin.convert((Finite.Rlin)expr.getRhs().accept(this, _));
    }

    @Override
    public Finite.Rlin visit(Rhs.Rvar variable, Void _) {
        return this.builder.resolve(variable);
    }

    @Override
    public Finite.Rlin visit(Rhs.Rlit literal, Void _) {
        return fin.literal(literal.getSize(), literal.getValue());
    }

    @Override
    public Finite.Rhs visit(Rhs.Address expr, Void _) {
        throw new RReilGrammarException("RReil jump target addresses should not appear on this level anymore.");
    }

    @Override
    public Finite.Rhs visit(Rhs.RangeRhs range, Void _) {
        return fin.range(range.getSize(), range.getRange());
    }
}

