/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.fields;

import bindead.domains.fields.VariableCtx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.digraph.Digraph;
import javalx.digraph.algorithms.dfs.Dfs;
import javalx.digraph.algorithms.dfs.DfsVertexVisitor;
import javalx.numeric.Bound;
import javalx.numeric.FiniteRange;
import javalx.persistentcollections.tree.OverlappingRanges;

public class FieldGraph
extends Digraph {
    private final Map<Bound, Digraph.Vertex> bounds = new HashMap<Bound, Digraph.Vertex>();
    private final Map<Digraph.Edge, P2<FiniteRange, VariableCtx>> weights = new HashMap<Digraph.Edge, P2<FiniteRange, VariableCtx>>();

    private FieldGraph() {
    }

    public static FieldGraph build(OverlappingRanges<VariableCtx> overlapping) {
        FieldGraph g = new FieldGraph();
        for (P2<FiniteRange, VariableCtx> p2 : overlapping) {
            g.bind(p2);
        }
        return g;
    }

    private void bind(P2<FiniteRange, VariableCtx> field) {
        FiniteRange key = field._1();
        Digraph.Vertex u = this.vertexOf(key.low());
        Digraph.Vertex v = this.vertexOf(key.high().add(Bound.ONE));
        Digraph.Edge e = this.createEdge(u, v);
        this.weights.put(e, field);
    }

    private Digraph.Vertex vertexOf(Bound bound) {
        Digraph.Vertex v = this.bounds.get(bound);
        if (v == null) {
            v = this.createVertex();
            this.bounds.put(bound, v);
        }
        return v;
    }

    public Partitioning findPartitioning(Bound root, Bound target) {
        Digraph.Vertex rootVertex = this.bounds.get(root);
        Digraph.Vertex targetVertex = this.bounds.get(target.add(Bound.ONE));
        if (rootVertex == null || targetVertex == null) {
            return new Partitioning();
        }
        return this.findPath(rootVertex, targetVertex);
    }

    private Partitioning findPath(Digraph.Vertex root, Digraph.Vertex target) {
        PathFinder path = new PathFinder();
        Dfs dfs = new Dfs(path);
        dfs.run(root);
        return this.resolvePath(path.resolvePath(target));
    }

    private Partitioning resolvePath(List<Digraph.Vertex> path) {
        Partitioning fields = new Partitioning();
        Iterator<Digraph.Vertex> i = path.iterator();
        Digraph.Vertex v = i.next();
        while (i.hasNext()) {
            Digraph.Vertex u = v;
            v = i.next();
            Digraph.Edge e = FieldGraph.resolveEdge(u, v);
            fields.add(this.weights.get(e));
        }
        return fields;
    }

    private static Digraph.Edge resolveEdge(Digraph.Vertex u, Digraph.Vertex v) {
        for (Digraph.Edge e : u.outgoing()) {
            if (!e.getTarget().equals(v)) continue;
            return e;
        }
        return null;
    }

    public static class Partitioning
    extends ArrayList<P2<FiniteRange, VariableCtx>> {
        private static final long serialVersionUID = 1L;

        public Option<FiniteRange> span() {
            if (this.isEmpty()) {
                return Option.none();
            }
            FiniteRange start = (FiniteRange)((P2)this.get(0))._1();
            FiniteRange end = (FiniteRange)((P2)this.get(this.size() - 1))._1();
            return Option.some(start.join(end));
        }

        @Override
        public String toString() {
            return "Partitioning{" + super.toString() + '}';
        }
    }

    private static class PathFinder
    implements DfsVertexVisitor {
        private final Map<Digraph.Vertex, Digraph.Vertex> parents = new HashMap<Digraph.Vertex, Digraph.Vertex>();
        private Digraph.Vertex current;

        private PathFinder() {
        }

        @Override
        public void visitOnDiscovery(Digraph.Vertex v) {
            this.parents.put(v, this.current);
            this.current = v;
        }

        @Override
        public void visitWhenFinished(Digraph.Vertex v) {
            this.current = this.parents.get(v);
        }

        public List<Digraph.Vertex> resolvePath(Digraph.Vertex target) {
            LinkedList<Digraph.Vertex> path = new LinkedList<Digraph.Vertex>();
            Digraph.Vertex v = target;
            while (this.parents.get(v) != null) {
                path.push(v);
                v = this.parents.get(v);
            }
            path.push(v);
            return path;
        }
    }
}

