/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.apron;

import apron.Abstract1;
import apron.ApronException;
import apron.Environment;
import apron.Lincons1;
import apron.Linexpr1;
import apron.Linterm1;
import apron.Manager;
import apron.Scalar;
import apron.Texpr1CstNode;
import apron.Texpr1Intern;
import bindead.abstractsyntax.zeno.Zeno;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.debug.DomainStringBuilder;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domainnetwork.interfaces.ZenoHeadDomain;
import bindead.domains.apron.Marshaller;
import bindead.domains.apron.PrettyPrinters;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.exceptions.UncheckedExceptionWrapper;
import javalx.fn.Predicate;
import javalx.mutablecollections.CollectionHelpers;
import javalx.numeric.BigInt;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import javalx.persistentcollections.BiMap;
import rreil.lang.util.Type;

public abstract class Apron
extends ZenoHeadDomain<Apron> {
    public static final String NAME = "APRON";
    protected final Abstract1 state;
    protected final BiMap<NumVar, String> variablesMapping;
    private final SynthChannel channel;

    public Apron() {
        super(NAME, AnalysisCtx.unknown());
        this.variablesMapping = BiMap.empty();
        this.channel = new SynthChannel();
        Environment env = new Environment();
        try {
            this.state = new Abstract1(this.getDomainManager(), env);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    protected Apron(Abstract1 state, BiMap<NumVar, String> variablesMapping, SynthChannel synth, AnalysisCtx ctx) {
        super(NAME, ctx);
        this.state = state;
        this.variablesMapping = variablesMapping;
        this.channel = synth != null ? synth : new SynthChannel();
    }

    protected abstract Manager getDomainManager();

    protected abstract Apron build(Abstract1 var1, BiMap<NumVar, String> var2, SynthChannel var3, AnalysisCtx var4);

    private Apron build(Abstract1 state) {
        return this.build(state, this.variablesMapping, null, this.getContext());
    }

    private Apron build(Abstract1 state, SynthChannel synth) {
        return this.build(state, this.variablesMapping, synth, this.getContext());
    }

    private Apron build(Abstract1 state, BiMap<NumVar, String> variablesMapping) {
        return this.build(state, variablesMapping, null, this.getContext());
    }

    @Override
    public Apron setContext(AnalysisCtx ctx) {
        return this.build(this.state, this.variablesMapping, null, ctx);
    }

    @Override
    public boolean subsetOrEqual(Apron other) {
        try {
            return this.state.isIncluded(this.state.getCreationManager(), other.state);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    @Override
    public Apron join(Apron other) {
        try {
            Abstract1 newState = this.state.joinCopy(this.state.getCreationManager(), other.state);
            return this.build(newState);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    @Override
    public Apron widen(Apron other) {
        try {
            Abstract1 newState = this.state.widening(this.state.getCreationManager(), other.state);
            return this.build(newState);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    public Apron meet(Apron other) {
        try {
            Abstract1 newState = this.state.meetCopy(this.state.getCreationManager(), other.state);
            return this.build(newState);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    @Override
    public Apron expand(FoldMap pairs) {
        Apron thisPrime = this.substitute(Apron.toTuplesList(pairs, false));
        thisPrime = thisPrime.introduceWithTop(pairs.getPermanent());
        Apron thisDoublePrime = this.introduceWithTop(pairs.getEphemeral());
        return thisPrime.meet(thisDoublePrime);
    }

    @Override
    public Apron fold(FoldMap pairs) {
        Apron thisPrime = this.project(pairs.getPermanent(), true);
        thisPrime = thisPrime.substitute(Apron.toTuplesList(pairs, true));
        Apron thisDoublePrime = this.project(pairs.getEphemeral(), true);
        return thisPrime.join(thisDoublePrime);
    }

    private static P2<Apron, Apron> makeCompatForMeet(Apron first, Apron second) {
        VarSet firstVars = first.getVars();
        VarSet secondVars = second.getVars();
        VarSet onlyInFirst = firstVars.difference(secondVars);
        VarSet onlyInSecond = secondVars.difference(firstVars);
        Apron newFirst = first.introduceWithTop(onlyInSecond);
        Apron newSecond = second.introduceWithTop(onlyInFirst);
        return P2.tuple2(newFirst, newSecond);
    }

    private static List<P2<NumVar, NumVar>> toTuplesList(FoldMap pairs, boolean reversed) {
        LinkedList<P2<NumVar, NumVar>> result = new LinkedList<P2<NumVar, NumVar>>();
        for (VarPair pair : pairs) {
            if (reversed) {
                result.add(P2.tuple2(pair.getEphemeral(), pair.getPermanent()));
                continue;
            }
            result.add(P2.tuple2(pair.getPermanent(), pair.getEphemeral()));
        }
        return result;
    }

    @Override
    public Apron copyAndPaste(VarSet vars, Apron from) {
        assert (!this.getVars().containsAll(vars));
        Apron varsOnlyState = from.project(from.getVars().difference(vars), false);
        Apron addedVarsState = this.introduceWithTop(vars);
        VarSet finalSupportSet = addedVarsState.getVars();
        P2<Apron, Apron> compatibleStates = Apron.makeCompatForMeet(varsOnlyState, addedVarsState);
        varsOnlyState = compatibleStates._1();
        addedVarsState = compatibleStates._2();
        Apron result = varsOnlyState.meet(addedVarsState);
        VarSet addedVars = result.getVars().difference(finalSupportSet);
        result = result.project(addedVars, true);
        return result;
    }

    private VarSet getVars() {
        VarSet result = VarSet.empty();
        for (NumVar var : this.variablesMapping.keys()) {
            result = result.add(var);
        }
        return result;
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        throw new DomainStateException.UnimplementedMethodException();
    }

    @Override
    public Range queryRange(Linear expr) {
        Linexpr1 apronLinear;
        try {
            apronLinear = Marshaller.toApronLinear(expr, this.state.getEnvironment(), this.variablesMapping);
        }
        catch (DomainStateException.VariableSupportSetException e) {
            return Range.from(Interval.TOP);
        }
        try {
            apron.Interval interval = this.state.getBound(this.state.getCreationManager(), apronLinear);
            return Range.from(Marshaller.fromApronInterval(interval));
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    @Override
    public SetOfEquations queryEqualities(NumVar variable) {
        Lincons1[] allConstraints;
        SetOfEquations equalities = SetOfEquations.empty();
        final String apronVariable = this.variablesMapping.get(variable).get();
        try {
            allConstraints = this.state.toLincons(this.state.getCreationManager());
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
        List<Lincons1> constraints = CollectionHelpers.filter(allConstraints, new Predicate<Lincons1>(){

            @Override
            public Boolean apply(Lincons1 constraint) {
                if (constraint.getKind() != 0) {
                    return false;
                }
                if (!constraint.isLinear()) {
                    return false;
                }
                if (constraint.getCoeff(apronVariable).isZero()) {
                    return false;
                }
                return true;
            }
        });
        for (Lincons1 constraint : constraints) {
            Linexpr1 apronLinear = new Linexpr1(this.state.getEnvironment(), constraint.getLinterms(), constraint.getCst());
            equalities = equalities.add(Marshaller.fromApronLinear(apronLinear, this.variablesMapping));
        }
        return equalities;
    }

    @Override
    public SynthChannel getSynthChannel() {
        return this.channel;
    }

    @Override
    public Apron eval(Zeno.Assign stmt) {
        NumVar lhs = stmt.getLhs().getId();
        if (!this.variablesMapping.contains(lhs)) {
            ZenoDomain updatedDomain = this.introduce(lhs, Type.Zeno, Option.none());
            return ((Apron)updatedDomain).eval(stmt);
        }
        String apronLhs = this.variablesMapping.get(lhs).get();
        Texpr1Intern assign = Marshaller.toApronExpr(stmt.getRhs(), this.state.getEnvironment(), this.variablesMapping, this);
        try {
            Abstract1 newState = this.state.assignCopy(this.state.getCreationManager(), apronLhs, assign, null);
            SynthChannel synth = this.extractNewConstantEqualities(this.state, newState, VarSet.of(stmt.getLhs().getId()));
            if (!synth.getEquations().isEmpty() && AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                System.out.println("Synth: " + synth);
            }
            return this.build(newState, synth);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    @Override
    public Apron eval(Zeno.Test test) throws Unreachable {
        Lincons1 constraints;
        if (test.getOperator().equals((Object)Zeno.ZenoTestOp.NotEqualToZero)) {
            if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                System.out.println("Apron splits test: " + test);
            }
            P2<Zeno.Test, Zeno.Test> tests = test.splitEquality();
            Apron firstState = null;
            Apron secondState = null;
            try {
                firstState = this.eval(tests._1());
            }
            catch (Unreachable unreachable) {
                // empty catch block
            }
            try {
                secondState = this.eval(tests._2());
            }
            catch (Unreachable unreachable) {
                // empty catch block
            }
            Apron result = Apron.joinNullables(firstState, secondState);
            if (result == null) {
                throw new Unreachable();
            }
            return result;
        }
        if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
            System.out.println("Numeric test: " + test);
        }
        Linexpr1 linear = Marshaller.toApronLinear(test.getExpr(), this.state.getEnvironment(), this.variablesMapping);
        switch (test.getOperator()) {
            case EqualToZero: {
                constraints = new Lincons1(0, linear);
                break;
            }
            case LessThanOrEqualToZero: {
                linear = Marshaller.toApronLinear(test.getExpr().negate(), this.state.getEnvironment(), this.variablesMapping);
                constraints = new Lincons1(1, linear);
                break;
            }
            default: {
                throw new DomainStateException.InvariantViolationException();
            }
        }
        try {
            Abstract1 newState = this.state.meetCopy(this.state.getCreationManager(), constraints);
            if (newState.isBottom(newState.getCreationManager())) {
                throw new Unreachable();
            }
            SynthChannel synth = this.extractNewConstantEqualities(this.state, newState, test.getVars());
            if (!synth.getEquations().isEmpty() && AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                System.out.println("Synth: " + synth);
            }
            return this.build(newState, synth);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    private SynthChannel extractNewConstantEqualities(Abstract1 oldState, Abstract1 newState, VarSet vars) throws ApronException {
        HashMap<NumVar, BigInt> newEqualities = new HashMap<NumVar, BigInt>();
        VarSet transitiveVars = this.getVarsWithTransitiveRelations(vars);
        for (NumVar variable : transitiveVars) {
            String apronVariable = this.variablesMapping.get(variable).get();
            apron.Interval oldValue = oldState.getBound(oldState.getCreationManager(), apronVariable);
            apron.Interval newValue = newState.getBound(newState.getCreationManager(), apronVariable);
            if (!newValue.isScalar() || newValue.equals(oldValue)) continue;
            newEqualities.put(variable, Marshaller.fromApronScalarNoRounding(newValue.inf()));
        }
        SynthChannel synth = new SynthChannel();
        for (Map.Entry pair : newEqualities.entrySet()) {
            synth.addEquation(Linear.linear(((BigInt)pair.getValue()).negate(), Linear.term((NumVar)pair.getKey())).toEquality());
        }
        return synth;
    }

    VarSet getVarsWithTransitiveRelations(VarSet vars) throws ApronException {
        Lincons1[] allConstraints = this.state.toLincons(this.state.getCreationManager());
        VarSet transitiveVars = VarSet.empty();
        for (NumVar variable : vars) {
            transitiveVars = transitiveVars.add(variable);
            String apronVariable = this.variablesMapping.get(variable).get();
            for (Lincons1 constraint : allConstraints) {
                if (constraint.getCoeff(apronVariable).isZero()) continue;
                for (Linterm1 term : constraint.getLinterms()) {
                    transitiveVars = transitiveVars.add(this.variablesMapping.getKey(term.getVariable()).get());
                }
            }
        }
        return transitiveVars;
    }

    @Override
    public Apron introduce(NumVar variable, Type type, Option<BigInt> value) {
        if (this.variablesMapping.contains(variable)) {
            System.out.println();
        }
        assert (!this.variablesMapping.contains(variable));
        String apronVar = variable.getName();
        BiMap<NumVar, String> newVariablesMapping = this.variablesMapping.bind(variable, apronVar);
        Environment newEnv = this.state.getEnvironment().add(new String[]{apronVar}, null);
        try {
            Abstract1 newState = this.state.changeEnvironmentCopy(this.state.getCreationManager(), newEnv, false);
            assert (newState.getEnvironment().hasVar(apronVar));
            if (value.isSome()) {
                Scalar apronValue = Marshaller.toApronScalar(value.get());
                Texpr1Intern assign = new Texpr1Intern(newEnv, new Texpr1CstNode(apronValue));
                newState.assign(newState.getCreationManager(), apronVar, assign, null);
                newState.assign(this.state.getCreationManager(), apronVar, assign, null);
            } else {
                switch (type) {
                    case Bool: {
                        Linexpr1 lowerLinear = Marshaller.toApronLinear(Linear.linear(variable), newState.getEnvironment(), newVariablesMapping);
                        Lincons1 lowerConstraints = new Lincons1(1, lowerLinear);
                        newState.meet(this.state.getCreationManager(), lowerConstraints);
                        Linear upperLinearRaw = Linear.linear(BigInt.MINUSONE, variable).add(BigInt.ONE);
                        Linexpr1 upperLinear = Marshaller.toApronLinear(upperLinearRaw, newState.getEnvironment(), newVariablesMapping);
                        Lincons1 upperConstraints = new Lincons1(1, upperLinear);
                        newState.meet(this.state.getCreationManager(), upperConstraints);
                        break;
                    }
                    case Address: {
                        Linexpr1 linear = Marshaller.toApronLinear(Linear.linear(variable), newState.getEnvironment(), newVariablesMapping);
                        Lincons1 constraints = new Lincons1(1, linear);
                        newState.meet(this.state.getCreationManager(), constraints);
                        break;
                    }
                }
            }
            return this.build(newState, newVariablesMapping);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    private Apron introduceWithTop(VarSet vars) {
        BiMap<NumVar, String> newVariablesMapping = this.variablesMapping;
        LinkedList<String> apronVars = new LinkedList<String>();
        for (NumVar var : vars) {
            assert (!this.variablesMapping.contains(var));
            String apronVar = var.getName();
            newVariablesMapping = newVariablesMapping.bind(var, apronVar);
            apronVars.add(apronVar);
        }
        Environment newEnv = this.state.getEnvironment().add(apronVars.toArray(new String[apronVars.size()]), null);
        try {
            Abstract1 newState = this.state.changeEnvironmentCopy(this.state.getCreationManager(), newEnv, false);
            return this.build(newState, newVariablesMapping);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    private Apron project(VarSet vars, boolean removeFromSupportSet) {
        LinkedList<String> apronVars = new LinkedList<String>();
        BiMap<NumVar, String> newVariablesMapping = this.variablesMapping;
        for (NumVar variable : vars) {
            if (!this.variablesMapping.contains(variable)) continue;
            String apronVar = this.variablesMapping.get(variable).get();
            if (removeFromSupportSet) {
                newVariablesMapping = newVariablesMapping.remove(variable);
            }
            assert (this.state.getEnvironment().hasVar(apronVar));
            apronVars.add(apronVar);
        }
        try {
            String[] apronVarsArray = apronVars.toArray(new String[apronVars.size()]);
            if (removeFromSupportSet) {
                Environment newEnv = this.state.getEnvironment().remove(apronVarsArray);
                Abstract1 newState = this.state.changeEnvironmentCopy(this.state.getCreationManager(), newEnv, false);
                return this.build(newState, newVariablesMapping);
            }
            Abstract1 newState = this.state.forgetCopy(this.state.getCreationManager(), apronVarsArray, false);
            return this.build(newState, newVariablesMapping);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    @Override
    public Apron project(VarSet vars) {
        return this.project(vars, true);
    }

    private Apron substitute(List<P2<NumVar, NumVar>> substitutions) {
        LinkedList<String> apronVarsFrom = new LinkedList<String>();
        LinkedList<String> apronVarsTo = new LinkedList<String>();
        BiMap<NumVar, String> newVariablesMapping = this.variablesMapping;
        for (P2<NumVar, NumVar> pair : substitutions) {
            NumVar x = pair._1();
            NumVar y = pair._2();
            assert (newVariablesMapping.contains(x));
            assert (!newVariablesMapping.contains(y));
            String apronVarX = newVariablesMapping.get(x).get();
            String apronVarY = y.getName();
            newVariablesMapping = newVariablesMapping.remove(x).bind(y, apronVarY);
            assert (this.state.getEnvironment().hasVar(apronVarX));
            assert (!this.state.getEnvironment().hasVar(apronVarY));
            apronVarsFrom.add(apronVarX);
            apronVarsTo.add(apronVarY);
        }
        try {
            int size = apronVarsFrom.size();
            Abstract1 newState = this.state.renameCopy(this.state.getCreationManager(), apronVarsFrom.toArray(new String[size]), apronVarsTo.toArray(new String[size]));
            return this.build(newState, newVariablesMapping);
        }
        catch (ApronException e) {
            throw new UncheckedExceptionWrapper(e);
        }
    }

    @Override
    public Apron substitute(NumVar x, NumVar y) {
        return this.substitute(Collections.singletonList(P2.tuple2(x, y)));
    }

    @Override
    public void toString(DomainStringBuilder builder) {
        builder.append(NAME, this.toString());
    }

    protected String printDomainValues() {
        return this.state.toString();
    }

    public String toString() {
        String domainValues = PrettyPrinters.asIntervals(this.state, this.variablesMapping, true) + "\n" + this.printDomainValues();
        return StringHelpers.indentMultiline("APRON: #" + this.variablesMapping.size() + " ", domainValues);
    }
}

