/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.affine;

import bindead.data.NumVar;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;

public class Equation
implements Comparable<Equation> {
    private static final int constVar = 0;
    protected final Term[] terms;

    public Term[] getTerms() {
        return this.terms;
    }

    public Equation(Term[] terms) {
        BigInt d = Equation.findTermsGCD(terms);
        if (terms.length > 0 && terms[0].id != 0 && terms[0].coeff.isNegative() || terms.length > 1 && terms[0].id == 0 && terms[1].coeff.isNegative()) {
            d = d == null ? Bound.MINUSONE : d.negate();
        }
        if (d != null) {
            for (int i = 0; i < terms.length; ++i) {
                terms[i] = new Term(terms[i].getCoeff().div(d), terms[i].getId());
            }
        }
        this.terms = terms;
        assert (this.isSorted());
    }

    private static BigInt findTermsGCD(Term[] ts) {
        BigInt d = null;
        for (Term t : ts) {
            BigInt coeff = t.coeff.abs();
            if (d == null) {
                d = coeff;
                continue;
            }
            if (d.isOne()) {
                return null;
            }
            d = d.gcd(coeff);
        }
        return d;
    }

    private boolean isSorted() {
        for (int i = 1; i < this.terms.length; ++i) {
            if (this.terms[i] == null || this.terms[i - 1] == null) {
                return false;
            }
            if (this.terms[i].id >= this.terms[i - 1].id) continue;
            return false;
        }
        return true;
    }

    public BigInt getCoeff(int id) {
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].getId() != id) continue;
            return this.terms[i].getCoeff();
        }
        return Bound.ZERO;
    }

    public int getKey() {
        if (this.terms.length == 0) {
            return -1;
        }
        if (this.terms[0].getId() != 0) {
            return this.terms[0].getId();
        }
        if (this.terms.length > 1) {
            return this.terms[1].getId();
        }
        return -1;
    }

    public NumVar getKey(HashMap<Integer, NumVar> intToVar) {
        return intToVar.get(this.getKey());
    }

    private int getConstIdx() {
        if (this.terms.length > 0 && this.terms[0].id == 0) {
            return 0;
        }
        return -1;
    }

    public BigInt getConstant() {
        int cIdx = this.getConstIdx();
        if (cIdx == -1) {
            return Bound.ZERO;
        }
        return this.terms[cIdx].coeff;
    }

    public int getLargestVar() {
        if (this.terms.length > 0) {
            return this.terms[this.terms.length - 1].getId();
        }
        return 0;
    }

    public int getLargerVar(int var) {
        int i;
        if (var == this.getLargestVar() || this.terms.length == 0) {
            return -1;
        }
        for (i = 0; i < this.terms.length && this.terms[i].getId() <= var; ++i) {
        }
        return this.terms[i].getId();
    }

    private static void sortTerms(Term[] termsArray) {
        if (termsArray.length > 0) {
            Arrays.sort(termsArray, Term.$Comparator);
        }
    }

    public static Equation mulAdd(BigInt thisFac, Equation thisLin, BigInt otherFac, Equation otherLin) {
        Term[] ts = Equation.weightedSum(thisFac, thisLin.terms, otherFac, otherLin.terms);
        return new Equation(ts);
    }

    private static Term[] weightedSum(BigInt f1, Term[] ts1, BigInt f2, Term[] ts2) {
        assert (!f1.isZero());
        assert (!f2.isZero());
        Term[] res = new Term[ts1.length + ts2.length];
        int i = 0;
        int i1 = 0;
        int i2 = 0;
        while (i1 < ts1.length && i2 < ts2.length) {
            BigInt coeff;
            int varDiff = ts1[i1].id - ts2[i2].id;
            if (varDiff < 0) {
                res[i++] = ts1[i1++].mul(f1);
                continue;
            }
            if (varDiff > 0) {
                res[i++] = ts2[i2++].mul(f2);
                continue;
            }
            int var = ts1[i1].id;
            if ((coeff = ts1[i1++].coeff.mul(f1).add(ts2[i2++].coeff.mul(f2))).isZero()) continue;
            res[i++] = new Term(coeff, var);
        }
        while (i1 < ts1.length) {
            res[i++] = ts1[i1++].mul(f1);
        }
        while (i2 < ts2.length) {
            res[i++] = ts2[i2++].mul(f2);
        }
        if (i < res.length) {
            res = Arrays.copyOf(res, i);
        }
        return res;
    }

    public Equation transformForAffineHullFirst(int lambda) {
        int shift = lambda + 1;
        Term[] result = Arrays.copyOf(this.terms, 2 * this.terms.length);
        int ctIdx = this.getConstIdx();
        int i = this.terms.length;
        if (ctIdx != -1) {
            result[ctIdx] = new Term(this.terms[ctIdx].coeff.negate(), 0);
            result[i++] = new Term(this.terms[ctIdx].coeff, lambda);
        }
        for (Term t : this.terms) {
            if (t.id == 0) continue;
            result[i++] = new Term(t.coeff.negate(), t.id + shift);
        }
        assert (i == 2 * this.terms.length);
        return new Equation(result);
    }

    public Equation transformForAffineHullSecond(int lambda) {
        int cIdx = this.getConstIdx();
        if (cIdx == -1) {
            return this;
        }
        Term[] result = new Term[this.terms.length];
        int i = 0;
        for (Term t : this.terms) {
            if (t.id == 0) continue;
            result[i++] = t;
        }
        result[this.terms.length - 1] = new Term(this.terms[cIdx].coeff, lambda);
        return new Equation(result);
    }

    public Equation transformForAffineHullBack(int lambda) {
        int shift = lambda + 1;
        int min = this.getKey();
        if (min <= lambda) {
            return null;
        }
        Term[] result = new Term[this.terms.length];
        int i = 0;
        for (Term t : this.terms) {
            result[i++] = t.id == 0 ? t : new Term(t.coeff, t.id - shift);
        }
        Equation.sortTerms(result);
        return new Equation(result);
    }

    @Override
    public int compareTo(Equation e) {
        return Integer.signum(this.getKey() - e.getKey());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Equation e = (Equation)obj;
        if (this.terms.length != e.terms.length) {
            return false;
        }
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].id == e.terms[i].id && this.terms[i].coeff.isEqualTo(e.terms[i].coeff)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String c = "";
        String res = "";
        for (Term t : this.terms) {
            String coeff = (t.coeff.isNegative() ? "" : "+") + t.coeff.toString();
            if (t.id == 0) {
                c = coeff;
                continue;
            }
            res = res + coeff + "x" + t.id;
        }
        return res + c;
    }

    public static final class Term
    implements Comparable<Term> {
        public static final Comparator<Term> $Comparator = new Comparator<Term>(){

            @Override
            public int compare(Term left, Term right) {
                return left.compareTo(right);
            }
        };
        private final int id;
        private final BigInt coeff;

        public Term(BigInt coeff, int id) {
            this.id = id;
            this.coeff = coeff;
        }

        public int getId() {
            return this.id;
        }

        public BigInt getCoeff() {
            return this.coeff;
        }

        public Term mul(BigInt scalar) {
            return new Term(this.coeff.mul(scalar), this.id);
        }

        public String toString() {
            if (this.coeff.isOne()) {
                return "x" + this.id;
            }
            if (this.coeff.isEqualTo(Bound.MINUSONE)) {
                return "-x" + this.id;
            }
            return this.coeff + "x" + this.id;
        }

        @Override
        public int compareTo(Term other) {
            int cmp;
            int n = this.id == other.id ? 0 : (cmp = this.id < other.id ? -1 : 1);
            if (cmp == 0) {
                return this.coeff.compareTo(other.coeff);
            }
            return cmp;
        }
    }
}

