/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.affine;

import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.combinators.ZenoStateBuilder;
import bindead.domains.affine.AffineState;
import bindead.domains.affine.Equation;
import bindead.domains.affine.Equations;
import bindead.domains.affine.Substitution;
import bindead.exceptions.Unreachable;
import java.util.HashMap;
import java.util.Vector;
import javalx.data.products.P2;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.ThreeWaySplit;

class AffineStateBuilder
extends ZenoStateBuilder {
    private AVLMap<NumVar, Linear> affine;
    private AVLMap<NumVar, VarSet> reverse;
    private VarSet newEqualities = VarSet.empty();

    AffineStateBuilder(AffineState dom) {
        this.affine = dom.affine;
        this.reverse = dom.reverse;
    }

    AffineState build() {
        return new AffineState(this.affine, this.reverse, this.newEqualities);
    }

    void affineTrans(Linear.Divisor d, NumVar var, Linear rhs) {
        if (!rhs.getCoeff(var).isZero()) {
            Substitution subst = Substitution.invertingSubstitution(rhs, d.get(), var);
            this.getChildOps().addSubstitution(subst, var);
            VarSet indices = this.reverse.get(var).getOrElse(VarSet.empty());
            NumVar rhsKey = rhs.getKey();
            VarSet simpleIndices = indices.getSmaller(rhsKey);
            this.applySubstInRows(simpleIndices, subst);
            int noOfEqs = indices.size() - simpleIndices.size();
            if (noOfEqs == 0) {
                return;
            }
            Linear[] equations = new Linear[noOfEqs];
            for (int idx = 0; idx < equations.length; ++idx) {
                equations[idx] = this.removeLhsVar(indices.get(idx + simpleIndices.size()));
            }
            for (Linear equation : equations) {
                NumVar rowVar = equation.getKey();
                Linear newEquation = equation.applySubstitution(subst);
                Substitution newSubst = this.inlineLinear(newEquation, rowVar);
                this.insertLinear(newEquation);
                subst = subst.applySubst(newSubst);
            }
        } else {
            Linear newEq = rhs.subTerm(d.get(), var);
            newEq = newEq.toEquality();
            this.removeVariable(var);
            if (!newEq.getKey().equalTo(var)) {
                this.inlineLinear(newEq, var);
            }
            this.insertLinear(newEq);
        }
    }

    void intersectWithLinear(Linear con) throws Unreachable {
        NumVar key = con.getKey();
        if (key == null) {
            if (con.getConstant().isZero()) {
                return;
            }
            throw new Unreachable();
        }
        this.newEqualities = this.newEqualities.add(key);
        this.inlineLinear(con, null);
        this.insertLinear(con);
    }

    void removeVariable(NumVar var) {
        Linear removed = this.removeLhsVar(var);
        if (removed == null) {
            this.removeRhsVar(var, true);
        }
    }

    void promoteVariable(NumVar numVar) {
        Linear removed = this.removeLhsVar(numVar);
        if (removed != null) {
            this.getChildOps().addEquality(removed);
        } else {
            this.removeRhsVar(numVar, false);
        }
    }

    private void applySubstInRows(VarSet vars, Substitution subst) {
        for (NumVar rowVar : vars) {
            Linear row = this.affine.getOrNull(rowVar);
            Linear newRow = row.applySubstitution(subst).toEquality();
            assert (newRow.getKey() == row.getKey());
            this.affine = this.affine.bind((Object)rowVar, (Object)newRow);
            Vector<P2<Boolean, NumVar>> diff = Linear.diffVars(newRow, row);
            for (P2<Boolean, NumVar> t : diff) {
                NumVar var = t._2();
                VarSet vs = this.reverse.get(var).getOrElse(VarSet.empty());
                if (t._1().booleanValue()) {
                    this.reverse = this.reverse.bind((Object)var, (Object)vs.remove(rowVar));
                    continue;
                }
                this.reverse = this.reverse.bind((Object)var, (Object)vs.add(rowVar));
            }
        }
    }

    protected Substitution inlineLinear(Linear con, NumVar add) {
        NumVar key = con.getKey();
        Substitution subst = con.genSubstitution(key);
        VarSet vs = this.reverse.get(key).getOrElse(VarSet.empty());
        this.applySubstInRows(vs, subst);
        if (add == null) {
            this.getChildOps().addKill(key);
            this.newEqualities = this.newEqualities.union(vs);
        } else {
            this.getChildOps().addSubstitution(subst, add);
        }
        return subst;
    }

    protected void insertLinear(Linear expr) {
        NumVar var = expr.getKey();
        expr = expr.toEquality();
        this.affine = this.affine.bind((Object)var, (Object)expr);
        for (Linear.Term t : expr) {
            if (t.getId().equalTo(var)) continue;
            VarSet vs = this.reverse.get(t.getId()).getOrElse(VarSet.empty());
            vs = vs.add(var);
            this.reverse = this.reverse.bind((Object)t.getId(), (Object)vs);
        }
    }

    protected Linear removeLhsVar(NumVar key) {
        Linear eq = this.affine.get(key).getOrNull();
        if (eq == null) {
            return null;
        }
        this.affine = this.affine.remove((Object)key);
        for (Linear.Term t : eq) {
            NumVar eqVar = t.getId();
            if (eqVar.equalTo(key)) continue;
            VarSet eqVs = this.reverse.get(eqVar).get();
            this.reverse = this.reverse.bind((Object)eqVar, (Object)eqVs.remove(key));
        }
        return eq;
    }

    protected void removeRhsVar(NumVar var, boolean removeFromChild) {
        VarSet vs = this.reverse.get(var).getOrElse(VarSet.empty());
        if (vs.isEmpty()) {
            this.reverse = this.reverse.remove((Object)var);
            if (removeFromChild) {
                this.getChildOps().addKill(var);
            }
        } else {
            NumVar lastVar = vs.get(vs.size() - 1);
            Linear eq = this.removeLhsVar(lastVar);
            assert (eq != null);
            Substitution subst = eq.genSubstitution(var);
            vs = vs.remove(lastVar);
            this.applySubstInRows(vs, subst);
            this.getChildOps().addLinearTransform(eq, removeFromChild ? var : null);
        }
    }

    boolean makeCompatible(AffineStateBuilder snd, boolean forSubset) {
        AffineStateBuilder fst = this;
        ThreeWaySplit<AVLMap<NumVar, Linear>> diff = fst.affine.split(snd.affine);
        HashMap<Integer, NumVar> intToVar = new HashMap<Integer, NumVar>();
        Equations l = new Equations(diff.inBothButDiffering(), diff.onlyInFirst(), intToVar);
        Equations r = new Equations(snd.affine.intersection(diff.inBothButDiffering()), diff.onlyInSecond(), intToVar);
        if (!forSubset) {
            for (Equation eq : l) {
                fst.removeLhsVar(eq.getKey(intToVar));
            }
            for (Equation eq : r) {
                snd.removeLhsVar(eq.getKey(intToVar));
            }
        }
        Equations.AffineHullResult res = Equations.affineHull(l, r);
        if (!forSubset) {
            for (Equation eq : res.common) {
                fst.insertLinear(Linear.linear(eq, intToVar));
                snd.insertLinear(Linear.linear(eq, intToVar));
            }
        }
        for (Equation eq : res.onlyFst) {
            fst.getChildOps().addEquality(Linear.linear(eq, intToVar));
        }
        for (Equation eq : res.onlySnd) {
            snd.getChildOps().addEquality(Linear.linear(eq, intToVar));
        }
        return res.onlySnd.isEmpty();
    }

    FoldMap fold(FoldMap pairs) {
        VarSet lhsVars = VarSet.empty();
        VarSet ephemeralVars = VarSet.empty();
        for (VarPair pair : pairs) {
            ephemeralVars = ephemeralVars.add((NumVar)pair.getEphemeral());
            lhsVars = this.affine.contains((NumVar)pair.getPermanent()) ? lhsVars.add((NumVar)pair.getPermanent()) : lhsVars.union(this.reverse.get((NumVar)pair.getPermanent()).getOrElse(VarSet.empty()));
            if (this.affine.get((NumVar)pair.getEphemeral()).isSome()) {
                lhsVars = lhsVars.add((NumVar)pair.getEphemeral());
                continue;
            }
            lhsVars = lhsVars.union(this.reverse.get((NumVar)pair.getEphemeral()).getOrElse(VarSet.empty()));
        }
        HashMap<Integer, NumVar> intToVar = new HashMap<Integer, NumVar>();
        Equations l = new Equations(lhsVars.size());
        Equations r = new Equations(lhsVars.size());
        for (NumVar i : lhsVars) {
            Linear lin = this.removeLhsVar(i);
            assert (lin != null);
            l.add(lin.toEquation(intToVar));
            r.add(lin.renameVar(pairs).toEquation(intToVar));
        }
        r.gauss();
        Equations.AffineHullResult res = Equations.affineHull(l, r);
        for (Equation eq : res.onlyFst) {
            this.getChildOps().addEquality(Linear.linear(eq, intToVar));
        }
        for (Equation eq : res.onlySnd) {
            this.getChildOps().addEquality(Linear.linear(eq, intToVar));
        }
        Vector<Linear> common = new Vector<Linear>(res.common.size());
        for (Equation eq : res.common) {
            common.add(Linear.linear(eq, intToVar));
        }
        Vector<Linear> assignments = Linear.eliminate(common, ephemeralVars);
        for (Linear eq : assignments) {
            this.getChildOps().addEquality(eq);
        }
        VarSet notToExpand = VarSet.empty();
        for (Linear eq : common) {
            notToExpand = notToExpand.add(eq.getKey());
            this.insertLinear(eq);
        }
        FoldMap newPairs = new FoldMap();
        for (VarPair pair : pairs) {
            if (notToExpand.contains((NumVar)pair.getPermanent())) {
                this.getChildOps().addKill((NumVar)pair.getEphemeral());
                continue;
            }
            newPairs.add(pair);
        }
        return newPairs;
    }

    void sane() {
        for (P2<NumVar, VarSet> p2 : this.reverse) {
            VarSet vs = p2._2();
            for (NumVar v : vs) {
                Linear l = this.affine.get(v).get();
                assert (!l.getCoeff(p2._1()).isZero());
            }
        }
        for (P2<NumVar, Comparable<VarSet>> p2 : this.affine) {
            Linear eq = (Linear)p2._2();
            NumVar key = eq.getKey();
            assert (key == p2._1());
            for (Linear.Term t : eq) {
                if (t.getId() == key) continue;
                VarSet vs = this.reverse.get(t.getId()).getOrElse(VarSet.empty());
                assert (vs.contains(key));
            }
        }
    }

    Linear inlineIntoLinear(Linear eq, Linear.Divisor d) {
        return AffineState.inlineIntoLinear(eq, d, this.affine);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Childops: " + this.getChildOps());
        builder.append("\n");
        builder.append(this.build());
        return builder.toString();
    }
}

