/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.affine;

import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.interfaces.FunctorState;
import com.jamesmurty.utils.XMLBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.persistentcollections.AVLMap;

class AffineState
extends FunctorState {
    public static final AffineState EMPTY = new AffineState(AVLMap.empty(), AVLMap.empty(), VarSet.empty());
    protected final AVLMap<NumVar, Linear> affine;
    protected final AVLMap<NumVar, VarSet> reverse;
    protected final VarSet newEqualities;

    protected AffineState(AVLMap<NumVar, Linear> affine, AVLMap<NumVar, VarSet> reverse, VarSet newEqualities) {
        this.affine = affine;
        this.reverse = reverse;
        this.newEqualities = newEqualities;
    }

    AffineState withoutEqualities() {
        return new AffineState(this.affine, this.reverse, VarSet.empty());
    }

    public Linear inlineIntoLinear(Linear con, Linear.Divisor d) {
        return AffineState.inlineIntoLinear(con, d, this.affine);
    }

    public static Linear inlineIntoLinear(Linear con, Linear.Divisor d, AVLMap<NumVar, Linear> affine) {
        Linear res = con;
        for (NumVar x : con.getVars()) {
            Linear eq = affine.get(x).getOrNull();
            if (eq == null) continue;
            res = Linear.mulAdd(eq.getCoeff(x), res, res.getCoeff(x).negate(), eq);
            if (d == null) continue;
            d.mul(eq.getCoeff(x));
        }
        res = res.lowestForm(d);
        return res;
    }

    public List<Linear> getConstraints(NumVar var) {
        ArrayList<Linear> result = new ArrayList<Linear>();
        if (this.affine.contains(var)) {
            result.add(this.affine.get(var).get());
        }
        if (this.reverse.contains(var)) {
            for (NumVar idVar : this.reverse.get(var).get()) {
                result.add(this.affine.get(idVar).get());
            }
        }
        return result;
    }

    protected boolean notInSupport(NumVar var) {
        return !this.inSupport(var);
    }

    public boolean inSupport(NumVar var) {
        return this.inForwardMapping(var) || this.inReverseMapping(var);
    }

    private boolean inForwardMapping(NumVar var) {
        return this.affine.contains(var);
    }

    private boolean inReverseMapping(NumVar var) {
        Option<VarSet> usedIn = this.reverse.get(var);
        if (usedIn.isNone()) {
            return false;
        }
        return usedIn.get().size() > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.affine == null ? 0 : this.affine.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AffineState)) {
            return false;
        }
        AffineState other = (AffineState)obj;
        if (this.affine == null) {
            if (other.affine != null) {
                return false;
            }
        } else {
            Iterator<P2<NumVar, Linear>> iter1 = this.affine.iterator();
            Iterator<P2<NumVar, Linear>> iter2 = other.affine.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                P2<NumVar, Linear> p1 = iter1.next();
                P2<NumVar, Linear> p2 = iter2.next();
                if (p1._2().equals(p2._2())) continue;
                return false;
            }
            if (!iter1.hasNext() && !iter2.hasNext()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        builder = builder.e("AFFINE");
        for (Linear linear : this.affine.values()) {
            builder = builder.e("Entry").a("type", "equation").e("Value");
            builder = linear.toXML(builder);
            builder = builder.up().up();
        }
        return builder.up();
    }

    public String toString() {
        return "#" + this.affine.size() + " " + this.contentToString();
    }

    private String contentToString() {
        SortedSet<NumVar> sorted = StringHelpers.sortLexically(this.affine.keys());
        Iterator iterator = sorted.iterator();
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            NumVar key = (NumVar)iterator.next();
            Linear value = this.affine.getOrNull(key);
            builder.append(value.toEquationString());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
        builder.append(domainName + ": #" + this.affine.size() + " {");
        for (P2<NumVar, Linear> p2 : this.affine) {
            NumVar variable = p2._1();
            Linear equation = p2._2();
            if (equation.isSingleTerm() && equation.getCoeff(variable).isOne()) continue;
            if (equation.isZero()) {
                builder.append("0");
            } else {
                boolean printedFirstVariable = false;
                for (Linear.Term term : equation) {
                    if (!term.getCoeff().isNegative() && printedFirstVariable) {
                        builder.append("+");
                    }
                    if (term.getCoeff().isEqualTo(BigInt.MINUSONE)) {
                        builder.append("-");
                    } else if (!term.getCoeff().isOne()) {
                        builder.append(term.getCoeff().toString() + "*");
                    }
                    if (!this.inForwardMapping(term.getId())) {
                        childDomain.varToCompactString(builder, term.getId());
                    } else {
                        builder.append(term.getId());
                    }
                    printedFirstVariable = true;
                }
                builder.append("=");
                builder.append(equation.getConstant().negate());
            }
            builder.append(", ");
        }
        builder.setLength(builder.length() - 2);
        builder.append("}\n");
    }

    void appendVar(StringBuilder builder, NumVar var, PrettyDomain child) {
        Option<Linear> value = this.affine.get(var);
        if (value.isNone()) {
            child.varToCompactString(builder, var);
            return;
        }
        Linear linear = value.get();
        if (!linear.isSingleTerm() || !linear.getCoeff(var).isOne()) {
            child.varToCompactString(builder, var);
        } else {
            BigInt c = linear.getConstant();
            builder.append(c.negate().toString());
        }
    }
}

