/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.channels;

import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.DomainPrintHelpers;
import bindead.debug.DomainPrintProperties;
import bindead.debug.DomainStringBuilder;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.channels.DebugChannel;
import bindead.domainnetwork.channels.Domain;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.FunctorState;
import bindead.domainnetwork.interfaces.SemiLattice;
import com.jamesmurty.utils.XMLBuilder;
import java.util.LinkedList;
import java.util.List;
import javalx.data.products.P3;
import javalx.numeric.Range;
import javalx.xml.XmlPrintable;

public abstract class FunctorDomain<S extends FunctorState, C extends SemiLattice<C> & QueryChannel, D extends FunctorDomain<S, C, D>>
extends Domain<D> {
    private final boolean compactPrinting;
    public final S state;
    public final C childState;

    public FunctorDomain(String name, S state, C child) {
        super(name);
        this.compactPrinting = DomainPrintProperties.INSTANCE.printCompact.isTrue();
        this.state = state;
        this.childState = child;
    }

    public abstract D build(S var1, C var2);

    public abstract P3<S, C, C> makeCompatible(D var1, boolean var2);

    @Override
    public D join(D other) {
        P3<S, C, C> p3 = this.makeCompatible(other, false);
        return this.build((FunctorState)p3._1(), ((SemiLattice)p3._2()).join((SemiLattice)p3._3()));
    }

    @Override
    public D widen(D other) {
        P3<S, C, C> p3 = this.makeCompatible(other, true);
        return this.build((FunctorState)p3._1(), ((SemiLattice)p3._2()).widen((SemiLattice)p3._3()));
    }

    @Override
    public boolean subsetOrEqual(D other) {
        P3<S, C, C> p3 = this.makeCompatible(other, false);
        return ((SemiLattice)p3._2()).subsetOrEqual((SemiLattice)p3._3());
    }

    @Override
    public D addToState(D newState, boolean isWideningPoint) {
        if (newState == this) {
            this.debugSubsetOrEqual(isWideningPoint, true);
            return null;
        }
        P3<S, C, C> states = this.makeCompatible(newState, isWideningPoint);
        SemiLattice collectedChild = ((SemiLattice)states._2()).addToState((SemiLattice)states._3(), isWideningPoint);
        if (collectedChild == null) {
            return null;
        }
        return this.build((FunctorState)states._1(), collectedChild);
    }

    @Override
    public AnalysisCtx getContext() {
        return this.childState.getContext();
    }

    @Override
    public D setContext(AnalysisCtx ctx) {
        return this.build(this.state, this.childState.setContext(ctx));
    }

    @Override
    public SetOfEquations queryEqualities(NumVar variable) {
        return ((QueryChannel)this.childState).queryEqualities(variable);
    }

    @Override
    public Range queryRange(Linear lin) {
        return ((QueryChannel)this.childState).queryRange(lin);
    }

    @Override
    public SynthChannel getSynthChannel() {
        SynthChannel channel = ((QueryChannel)this.childState).getSynthChannel();
        return channel.removeVariables(this.localSubset(channel.getVariables()));
    }

    @Override
    public DebugChannel getDebugChannel() {
        return ((QueryChannel)this.childState).getDebugChannel();
    }

    public VarSet localSubset(VarSet toTest) {
        return VarSet.empty();
    }

    @Override
    public final XMLBuilder toXML(XMLBuilder builder) {
        builder = this.state.toXML(builder);
        builder = ((XmlPrintable)this.childState).toXML(builder);
        return builder;
    }

    @Override
    public final void toString(DomainStringBuilder builder) {
        builder.append(this.name, DomainPrintHelpers.printState(this.name, this.state));
        ((PrettyDomain)this.childState).toString(builder);
    }

    public String toString() {
        if (this.compactPrinting) {
            StringBuilder builder = new StringBuilder();
            this.toCompactString(builder);
            return builder.toString();
        }
        return DomainPrintHelpers.printState(this.name, this.state) + this.childState;
    }

    @Override
    public void toCompactString(StringBuilder builder) {
        ((FunctorState)this.state).toCompactString(this.name, builder, (PrettyDomain)this.childState);
        ((PrettyDomain)this.childState).toCompactString(builder);
    }

    @Override
    public void varToCompactString(StringBuilder builder, NumVar var) {
        ((PrettyDomain)this.childState).varToCompactString(builder, var);
    }

    @Override
    public List<D> enumerateAlternatives() {
        LinkedList<D> alts = new LinkedList<D>();
        List cs = this.childState.enumerateAlternatives();
        for (SemiLattice c : cs) {
            alts.add(this.build(this.state, c));
        }
        return alts;
    }
}

