/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.channels;

import bindead.analyses.algorithms.AnalysisProperties;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.debug.PrettyDomain;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.interfaces.SemiLattice;
import javalx.numeric.Range;

public abstract class Domain<D extends Domain<D>>
implements SemiLattice<D>,
QueryChannel,
PrettyDomain {
    private final boolean DEBUGBINARIES;
    private final boolean DEBUGSUBSETOREQUAL;
    private final boolean DEBUGWIDENING;
    protected final String name;

    protected Domain(String name) {
        this.DEBUGBINARIES = AnalysisProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGSUBSETOREQUAL = AnalysisProperties.INSTANCE.debugSubsetOrEqual.isTrue();
        this.DEBUGWIDENING = AnalysisProperties.INSTANCE.debugWidening.isTrue();
        this.name = name;
    }

    public static <D extends SemiLattice<D>> D joinNullables(D first, D second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return first.join(second);
    }

    @Override
    public final Range queryRange(NumVar variable) {
        return this.queryRange(Linear.linear(variable));
    }

    @Override
    public D addToState(D newState, boolean isWideningPoint) {
        return this.addToStateWithLatticeOps(newState, isWideningPoint);
    }

    protected final D addToStateWithLatticeOps(D newState, boolean isWideningPoint) {
        if (newState == this) {
            this.debugSubsetOrEqual(isWideningPoint, true);
            return null;
        }
        Domain thisD = this;
        boolean isSubsetOrEqual = newState.subsetOrEqual((Domain)thisD);
        this.debugSubsetOrEqual(isWideningPoint, isSubsetOrEqual);
        if (isSubsetOrEqual) {
            return null;
        }
        Domain joinedState = (Domain)this.join(newState);
        if (this.DEBUGBINARIES) {
            this.debugJoined(joinedState);
        }
        if (!isWideningPoint) {
            return (D)joinedState;
        }
        Domain widened = this.widen(joinedState);
        if (this.DEBUGWIDENING) {
            this.debugWidened(widened);
        }
        return (D)widened;
    }

    protected void debugWidened(D finalState) {
        System.out.println();
        System.out.println(StringHelpers.indentMultiline("  widened:   ", finalState.toString()) + "\n");
    }

    protected void debugJoined(D joinedState) {
        System.out.println();
        System.out.println(StringHelpers.indentMultiline("  joined:    ", joinedState.toString()) + "\n");
    }

    protected void debugSubsetOrEqual(boolean isWideningPoint, boolean isSubsetOrEqual) {
        if (!this.DEBUGSUBSETOREQUAL) {
            return;
        }
        System.out.println();
        System.out.println("ANALYSIS (subset-or-equal):");
        System.out.println("  subset-or-equal: " + isSubsetOrEqual);
        System.out.println("  widening: " + isWideningPoint);
    }
}

