/*
 * Decompiled with CFR 0.152.
 */
package bindead.debug;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class Benchmark {
    public static boolean measureTimings = true;
    public static boolean quiet = false;
    private static String bname;
    private static final HashMap<String, Integer> counters;
    private static boolean logMessages;
    private static final int RUNS = 5;
    private static final int WARMUP_SECS = 2;

    public Benchmark() {
        bname = this.getClass().getName();
    }

    public static void count(String what, int amount) {
        if (logMessages) {
            Integer old = counters.get(what);
            counters.put(what, old == null ? amount : old + amount);
        }
    }

    public static void log(String s) {
        if (logMessages && !quiet) {
            Benchmark.printb(s);
        }
    }

    public static void warn(String s) {
        if (logMessages) {
            Benchmark.printb("*** WARNING ***\n" + s);
        }
    }

    private static long average(long[] samples) {
        long total = 0L;
        for (long s : samples) {
            total += s;
        }
        return total / (long)samples.length;
    }

    private static void displayCounters() {
        for (Map.Entry<String, Integer> e : counters.entrySet()) {
            System.out.println(String.format("%5d %s", e.getValue(), e.getKey()));
        }
    }

    private static long getMemUsage() {
        long memUsage = 0L;
        for (MemoryPoolMXBean mem : ManagementFactory.getMemoryPoolMXBeans()) {
            memUsage += mem.getPeakUsage().getUsed();
        }
        return memUsage;
    }

    private static void printb(String s) {
        System.out.println("[" + bname + "] " + s);
    }

    private static long quantile(int quantile, int divisor, long[] sortedValues) {
        assert (0 <= quantile && quantile < divisor);
        assert (divisor > 0);
        assert (sortedValues.length > 0);
        long q = 0L;
        for (int j = 0; j < divisor; ++j) {
            q += sortedValues[(quantile * (sortedValues.length - 1) + j) / divisor];
        }
        return (q + (long)(divisor / 2)) / (long)divisor;
    }

    private static void resetMemUsage() {
        for (MemoryPoolMXBean mem : ManagementFactory.getMemoryPoolMXBeans()) {
            mem.resetPeakUsage();
        }
    }

    private static void waitForGC() {
        System.gc();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            Benchmark.printb("benchmark interrupted.");
        }
    }

    public abstract void benchmark();

    public final void run() {
        counters.clear();
        Benchmark.waitForGC();
        Benchmark.resetMemUsage();
        logMessages = false;
        Benchmark.printb("Initializing.");
        this.setup();
        logMessages = true;
        Benchmark.printb("Running.");
        this.benchmark();
        long memUsage = Benchmark.getMemUsage() / 1000L;
        Benchmark.printb(String.format("Ok (memory usage: %6d kB).", memUsage));
        logMessages = false;
        if (measureTimings) {
            Benchmark.printb("warming up for 2s.");
            long end = System.currentTimeMillis() + 2000L;
            System.out.print('|');
            int j = 1;
            int times = 0;
            do {
                this.setup();
                this.benchmark();
                if (++times != j) continue;
                System.out.print('-');
                j *= 2;
            } while (System.currentTimeMillis() < end);
            System.out.println("|");
            times = Math.max(times, 5);
            Benchmark.printb("taking " + times + " samples");
            long[] runtimes1 = new long[times];
            System.out.print('|');
            int j1 = 1;
            for (int i = 0; i < times; ++i) {
                this.setup();
                long start = System.currentTimeMillis();
                this.benchmark();
                runtimes1[i] = System.currentTimeMillis() - start;
                if (i != j1) continue;
                System.out.print('-');
                j1 *= 2;
            }
            System.out.println("|");
            Arrays.sort(runtimes1);
            long[] runtimes = runtimes1;
            System.out.println(String.format("Average time: %6d ms", Benchmark.average(runtimes)));
            System.out.println(String.format("  Minimum:    %6d ms", runtimes[0]));
            for (int q = 1; q < 4; ++q) {
                System.out.println(String.format("  Quartile %1d: %6d ms", q, Benchmark.quantile(q, 4, runtimes)));
            }
            System.out.println(String.format("  Maximum:    %6d ms", runtimes[runtimes.length - 1]));
        }
        Benchmark.displayCounters();
    }

    public void setup() {
    }

    static {
        counters = new HashMap();
        logMessages = false;
    }
}

