/*
 * Decompiled with CFR 0.152.
 */
package bindead.data;

import bindead.data.NumVar;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javalx.data.products.P3;
import javalx.persistentcollections.AVLMap;

public final class VarSet
implements Comparable<VarSet>,
Iterable<NumVar> {
    private static NumVar[] EMPTY_VEC = new NumVar[0];
    private static VarSet EMPTY = new VarSet();
    private final NumVar[] vars;

    private VarSet() {
        this.vars = EMPTY_VEC;
    }

    private VarSet(NumVar[] vars) {
        this.vars = vars;
    }

    public static VarSet empty() {
        return EMPTY;
    }

    public static VarSet of(NumVar ... vars) {
        NumVar[] vs = Arrays.copyOf(vars, vars.length);
        return new VarSet(vs);
    }

    public static VarSet from(Set<NumVar> vars) {
        NumVar[] vs = vars.toArray(EMPTY_VEC);
        return new VarSet(vs);
    }

    public static VarSet from(Iterable<NumVar> vars, int size) {
        NumVar[] vs = new NumVar[size];
        int i = 0;
        for (NumVar var : vars) {
            vs[i++] = var;
        }
        assert (i == size);
        return new VarSet(vs);
    }

    public static VarSet fromKeys(AVLMap<NumVar, ?> map) {
        return VarSet.from(map.keys(), map.size());
    }

    public int size() {
        return this.vars.length;
    }

    public boolean isEmpty() {
        return this.vars.length == 0;
    }

    public NumVar first() {
        return this.vars[0];
    }

    public NumVar get(int index) {
        return this.vars[index];
    }

    public boolean contains(NumVar var) {
        int pos = Arrays.binarySearch(this.vars, 0, this.vars.length, var);
        return pos >= 0;
    }

    public boolean containsAll(VarSet other) {
        int thisIdx = 0;
        int thatIdx = 0;
        while (thisIdx < this.vars.length && thatIdx < other.vars.length) {
            if (this.vars[thisIdx] == other.vars[thatIdx]) {
                ++thisIdx;
                ++thatIdx;
                continue;
            }
            if (this.vars[thisIdx].compareTo(other.vars[thatIdx]) < 0) {
                ++thisIdx;
                continue;
            }
            return false;
        }
        return thatIdx == other.vars.length;
    }

    public boolean containsAny(VarSet other) {
        return !this.intersection(other).isEmpty();
    }

    public VarSet add(NumVar var) {
        if (var == null) {
            return this;
        }
        int pos = Arrays.binarySearch(this.vars, 0, this.vars.length, var);
        if (pos >= 0) {
            return this;
        }
        pos = -pos - 1;
        NumVar[] newVars = new NumVar[this.vars.length + 1];
        System.arraycopy(this.vars, 0, newVars, 0, pos);
        newVars[pos] = var;
        int rem = this.vars.length - pos;
        System.arraycopy(this.vars, pos, newVars, pos + 1, rem);
        return new VarSet(newVars);
    }

    public VarSet remove(NumVar var) {
        if (var == null) {
            return this;
        }
        int pos = Arrays.binarySearch(this.vars, 0, this.vars.length, var);
        if (pos < 0) {
            return this;
        }
        NumVar[] newVars = new NumVar[this.vars.length - 1];
        System.arraycopy(this.vars, 0, newVars, 0, pos);
        int rem = this.vars.length - (pos + 1);
        System.arraycopy(this.vars, pos + 1, newVars, pos, rem);
        return new VarSet(newVars);
    }

    public VarSet union(VarSet other) {
        if (other.vars.length == 0) {
            return this;
        }
        if (this.vars.length == 0) {
            return other;
        }
        int newLength = 0;
        int thisIdx = 0;
        int thatIdx = 0;
        while (thisIdx < this.vars.length && thatIdx < other.vars.length) {
            ++newLength;
            if (this.vars[thisIdx] == other.vars[thatIdx]) {
                ++thisIdx;
                ++thatIdx;
                continue;
            }
            if (this.vars[thisIdx].compareTo(other.vars[thatIdx]) < 0) {
                ++thisIdx;
                continue;
            }
            ++thatIdx;
        }
        NumVar[] newVars = new NumVar[newLength += this.vars.length - thisIdx + other.vars.length - thatIdx];
        thatIdx = 0;
        thisIdx = 0;
        int newIdx = 0;
        while (thisIdx < this.vars.length && thatIdx < other.vars.length) {
            if (this.vars[thisIdx] == other.vars[thatIdx]) {
                newVars[newIdx++] = this.vars[thisIdx];
                ++thisIdx;
                ++thatIdx;
                continue;
            }
            if (this.vars[thisIdx].compareTo(other.vars[thatIdx]) < 0) {
                newVars[newIdx++] = this.vars[thisIdx++];
                continue;
            }
            newVars[newIdx++] = other.vars[thatIdx++];
        }
        while (thisIdx < this.vars.length) {
            newVars[newIdx++] = this.vars[thisIdx++];
        }
        while (thatIdx < other.vars.length) {
            newVars[newIdx++] = other.vars[thatIdx++];
        }
        assert (newIdx == newLength);
        return new VarSet(newVars);
    }

    public VarSet difference(VarSet other) {
        if (other.vars.length == 0) {
            return this;
        }
        int newLength = 0;
        int thisIdx = 0;
        int thatIdx = 0;
        while (thisIdx < this.vars.length && thatIdx < other.vars.length) {
            if (this.vars[thisIdx] == other.vars[thatIdx]) {
                ++thisIdx;
                ++thatIdx;
                continue;
            }
            if (this.vars[thisIdx].compareTo(other.vars[thatIdx]) < 0) {
                ++thisIdx;
                ++newLength;
                continue;
            }
            ++thatIdx;
        }
        NumVar[] newVars = new NumVar[newLength += this.vars.length - thisIdx];
        thatIdx = 0;
        thisIdx = 0;
        int newIdx = 0;
        while (thisIdx < this.vars.length && thatIdx < other.vars.length) {
            if (this.vars[thisIdx] == other.vars[thatIdx]) {
                ++thisIdx;
                ++thatIdx;
                continue;
            }
            if (this.vars[thisIdx].compareTo(other.vars[thatIdx]) < 0) {
                newVars[newIdx++] = this.vars[thisIdx++];
                continue;
            }
            ++thatIdx;
        }
        while (thisIdx < this.vars.length) {
            newVars[newIdx++] = this.vars[thisIdx++];
        }
        assert (newIdx == newLength);
        return new VarSet(newVars);
    }

    public VarSet intersection(VarSet other) {
        if (this.vars.length == 0) {
            return this;
        }
        if (other.vars.length == 0) {
            return other;
        }
        int newLength = 0;
        int thisIdx = 0;
        int thatIdx = 0;
        while (thisIdx < this.vars.length && thatIdx < other.vars.length) {
            if (this.vars[thisIdx] == other.vars[thatIdx]) {
                ++thisIdx;
                ++thatIdx;
                ++newLength;
                continue;
            }
            if (this.vars[thisIdx].compareTo(other.vars[thatIdx]) < 0) {
                ++thisIdx;
                continue;
            }
            ++thatIdx;
        }
        NumVar[] newVars = new NumVar[newLength];
        thatIdx = 0;
        thisIdx = 0;
        int newIdx = 0;
        while (thisIdx < this.vars.length && thatIdx < other.vars.length) {
            if (this.vars[thisIdx] == other.vars[thatIdx]) {
                newVars[newIdx++] = this.vars[thisIdx];
                ++thisIdx;
                ++thatIdx;
                continue;
            }
            if (this.vars[thisIdx].compareTo(other.vars[thatIdx]) < 0) {
                ++thisIdx;
                continue;
            }
            ++thatIdx;
        }
        assert (newIdx == newLength);
        return new VarSet(newVars);
    }

    public P3<VarSet, VarSet, VarSet> split(VarSet other) {
        VarSet common = this.intersection(other);
        VarSet onlyInFirst = this.difference(common);
        VarSet onlyInSecond = other.difference(common);
        return P3.tuple3(onlyInFirst, common, onlyInSecond);
    }

    public VarSet getSmaller(NumVar var) {
        int pos = Arrays.binarySearch(this.vars, 0, this.vars.length, var);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        if (pos == this.vars.length) {
            return this;
        }
        return new VarSet(Arrays.copyOf(this.vars, pos));
    }

    public VarSet substitute(Map<NumVar, NumVar> mapping) {
        Object[] newVars = Arrays.copyOf(this.vars, this.vars.length);
        for (int i = 0; i < newVars.length; ++i) {
            NumVar substitute = mapping.get(this.vars[i]);
            if (substitute == null) continue;
            newVars[i] = substitute;
        }
        Arrays.sort(newVars);
        return new VarSet((NumVar[])newVars);
    }

    @Override
    public int compareTo(VarSet other) {
        int diff = other.vars.length - this.vars.length;
        if (diff != 0) {
            return diff;
        }
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i] == other.vars[i]) continue;
            return this.vars[i].compareTo(other.vars[i]);
        }
        return 0;
    }

    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        return this.compareTo((VarSet)t) == 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Arrays.hashCode(this.vars);
        return hash;
    }

    public String toString() {
        String res = "{";
        String sep = "";
        for (int i = 0; i < this.vars.length; ++i) {
            res = res + sep + this.vars[i];
            sep = ", ";
        }
        return res + "}";
    }

    @Override
    public Iterator<NumVar> iterator() {
        return new Iter();
    }

    private class Iter
    implements Iterator<NumVar> {
        int idx = 0;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < VarSet.this.vars.length;
        }

        @Override
        public NumVar next() {
            return VarSet.this.vars[this.idx++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

