/*
 * Decompiled with CFR 0.152.
 */
package bindead.data;

import bindead.data.MemVarPair;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javalx.data.products.P2;
import rreil.lang.MemVar;

public class FoldMap
implements Iterable<VarPair> {
    private final List<MemVarPair> memlist;
    private final List<VarPair> list;
    private final Map<NumVar, NumVar> map;
    private final Set<NumVar> ephemerals;

    public FoldMap() {
        this.memlist = new LinkedList<MemVarPair>();
        this.list = new LinkedList<VarPair>();
        this.map = new HashMap<NumVar, NumVar>();
        this.ephemerals = new HashSet<NumVar>();
    }

    public FoldMap(FoldMap f) {
        this.memlist = new LinkedList<MemVarPair>(f.memlist);
        this.list = new LinkedList<VarPair>(f.list);
        this.map = new HashMap<NumVar, NumVar>(f.map);
        this.ephemerals = new HashSet<NumVar>(f.ephemerals);
    }

    public static FoldMap empty() {
        return new FoldMap();
    }

    public static FoldMap fromList(List<VarPair> inner) {
        FoldMap fm = new FoldMap();
        for (VarPair vp : inner) {
            fm.add(vp);
        }
        return fm;
    }

    public static FoldMap fromMemList(List<MemVarPair> inner) {
        FoldMap fm = new FoldMap();
        for (MemVarPair vp : inner) {
            fm.add(vp);
        }
        return fm;
    }

    public static FoldMap singleton(NumVar p, NumVar e) {
        FoldMap m = new FoldMap();
        m.add(p, e);
        return m;
    }

    public List<MemVarPair> getMemVarPairs() {
        return this.memlist;
    }

    public void add(MemVar p, MemVar e) {
        this.memlist.add(new MemVarPair(p, e));
    }

    public void add(MemVarPair p) {
        assert (!this.contained(p));
        this.memlist.add(p);
    }

    private boolean contained(MemVarPair p) {
        for (MemVarPair mvp : this.memlist) {
            if (((MemVar)mvp.getEphemeral()).equals(p.getEphemeral())) {
                return true;
            }
            if (((MemVar)mvp.getEphemeral()).equals(p.getPermanent())) {
                return true;
            }
            if (((MemVar)mvp.getPermanent()).equals(p.getEphemeral())) {
                return true;
            }
            if (!((MemVar)mvp.getPermanent()).equals(p.getPermanent())) continue;
            return true;
        }
        return false;
    }

    public void add(NumVar permanent, NumVar ephemeral) {
        this.add(new VarPair(permanent, ephemeral));
    }

    public void add(VarPair p) {
        NumVar permanent = (NumVar)p.getPermanent();
        NumVar ephemeral = (NumVar)p.getEphemeral();
        assert (!this.map.containsKey(permanent));
        assert (!this.map.containsKey(ephemeral));
        assert (!this.ephemerals.contains(permanent));
        assert (!this.ephemerals.contains(ephemeral));
        this.list.add(p);
        this.map.put(permanent, ephemeral);
        this.ephemerals.add(ephemeral);
    }

    public VarSet getAllVars() {
        return this.getPermanent().union(this.getEphemeral());
    }

    public VarSet getPermanent() {
        return VarSet.from(this.map.keySet());
    }

    public VarSet getEphemeral() {
        return VarSet.from(this.ephemerals);
    }

    public NumVar getEphemeral(NumVar perm) {
        assert (perm != null);
        NumVar eph = this.map.get(perm);
        assert (eph != null);
        return eph;
    }

    @Override
    public Iterator<VarPair> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        if (!this.list.isEmpty()) {
            builder.append("v:");
            builder.append(this.list);
            if (!this.memlist.isEmpty()) {
                builder.append(", ");
            }
        }
        if (!this.memlist.isEmpty()) {
            builder.append("m:");
            builder.append(this.memlist);
        }
        builder.append(">");
        return builder.toString();
    }

    public List<P2<NumVar.AddrVar, NumVar.AddrVar>> getAddressPairs() {
        LinkedList<P2<NumVar.AddrVar, NumVar.AddrVar>> ali = new LinkedList<P2<NumVar.AddrVar, NumVar.AddrVar>>();
        for (VarPair vp : this.list) {
            NumVar permanent = (NumVar)vp.getPermanent();
            NumVar ephemeral = (NumVar)vp.getEphemeral();
            boolean pia = permanent.isAddress();
            assert (pia == ephemeral.isAddress());
            if (!pia) continue;
            ali.add(P2.tuple2((NumVar.AddrVar)permanent, (NumVar.AddrVar)ephemeral));
        }
        return ali;
    }

    public void assertCorrectFoldMap() {
        VarSet ephs = VarSet.empty();
        VarSet perms = VarSet.empty();
        for (VarPair vp : this) {
            NumVar p = (NumVar)vp.getPermanent();
            assert (!ephs.contains(p)) : this + " already contains ephemeral " + p;
            assert (!perms.contains(p)) : this + " already contains permanent " + p;
            perms = perms.add(p);
            NumVar e = (NumVar)vp.getEphemeral();
            assert (!ephs.contains(e)) : ephs + " already contains " + e;
            assert (!perms.contains(e)) : perms + " already contains " + e;
            ephs = ephs.add(e);
        }
    }

    public NumVar freshSubstitute(NumVar ov) {
        NumVar fv = NumVar.fresh();
        this.add(new VarPair(ov, fv));
        return fv;
    }

    public boolean isEphemeral(NumVar var) {
        return this.ephemerals.contains(var);
    }

    public boolean isPermanent(NumVar var) {
        return this.map.keySet().contains(var);
    }
}

