/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms;

import bindead.analyses.algorithms.FixpointAnalysis;
import bindead.analyses.algorithms.FixpointAnalysisEvaluator;
import bindead.analyses.algorithms.TraceEvaluator;
import bindead.analyses.algorithms.TraceIterator;
import bindead.analyses.algorithms.data.Flows;
import bindead.analyses.algorithms.data.ProgramCtx;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.AnalysisEnvironment;
import binparse.trace.TraceBinary;
import java.util.List;

public class TraceAnalysis<D extends RootDomain<D>>
extends FixpointAnalysis<D> {
    public final TraceIterator traceIterator;
    private TraceEvaluator<D> evaluator;

    public TraceAnalysis(AnalysisEnvironment environment, TraceBinary binary, D initialState) {
        super(environment, binary, initialState);
        this.traceIterator = new TraceIterator(binary.getTraceDump());
    }

    @Override
    protected FixpointAnalysisEvaluator<D> getEvaluator() {
        if (this.isFollowingTrace()) {
            return this.getTraceEvaluator();
        }
        return super.getEvaluator();
    }

    private FixpointAnalysisEvaluator<D> getTraceEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new TraceEvaluator(this.traceIterator);
        }
        return this.evaluator;
    }

    @Override
    protected boolean updateWorklist(ProgramCtx from, Flows.Successor<D> successor, List<ProgramCtx> queue) {
        ProgramCtx to = new ProgramCtx(from.getCallString(), successor.getAddress());
        boolean updated = this.states.update(from, successor.getType(), to, successor.getState(), !this.isFollowingTrace());
        if (updated || this.isFollowingTrace()) {
            queue.add(to);
            return true;
        }
        return false;
    }

    private boolean isFollowingTrace() {
        return this.traceIterator.hasNext();
    }
}

