/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms;

import bindead.analyses.ProgramAddress;
import bindead.analyses.algorithms.data.Flows;
import bindead.analyses.callback.Callbacks;
import bindead.analyses.systems.SystemModel;
import bindead.analyses.systems.natives.FunctionDefinition;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.AnalysisEnvironment;
import bindead.environment.platform.Platform;
import bindead.exceptions.AnalysisException;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import java.util.List;
import java.util.Stack;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.exceptions.UnimplementedException;
import javalx.numeric.Range;
import rreil.RReilGrammarException;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.Test;
import rreil.lang.util.RReilFactory;
import rreil.lang.util.RReilVisitor;

public class FixpointAnalysisEvaluator<D extends RootDomain<D>>
implements RReilVisitor<Flows<D>, P3<D, ProgramPoint, RReilAddr>> {
    private final long analysisStartCanary;

    public FixpointAnalysisEvaluator(long analysisStartCanary) {
        this.analysisStartCanary = analysisStartCanary;
    }

    private boolean tryCallback(RReil insn, P3<D, ProgramPoint, RReilAddr> ctx, Flows<D> flow) {
        boolean handled;
        AnalysisEnvironment env = ((RootDomain)ctx._1()).getContext().getEnvironment();
        Callbacks hooks = env.getCallbacks();
        SystemModel systemModel = env.getSystemModel();
        if (hooks == null && systemModel == null) {
            return false;
        }
        if (hooks != null && (handled = hooks.tryCallback(insn, (RootDomain)ctx._1(), ctx._2(), env, flow))) {
            return true;
        }
        if (systemModel != null) {
            Option<FunctionDefinition> optFunc = systemModel.handleNativeFunction(ctx._2().getAddress(), insn, (RootDomain)ctx._1());
            if (optFunc.isNone()) {
                return false;
            }
            this.evaluateFunction(optFunc.get(), ctx, flow);
            return true;
        }
        return false;
    }

    @Override
    public Flows<D> visit(RReil.Assign stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        RootDomain domainState = (RootDomain)ctx._1();
        domainState = (RootDomain)domainState.eval(stmt);
        return Flows.next(ctx._3(), domainState);
    }

    @Override
    public Flows<D> visit(RReil.Load stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        RootDomain domainState = (RootDomain)ctx._1();
        try {
            domainState = (RootDomain)domainState.eval(stmt);
            return Flows.next(ctx._3(), domainState);
        }
        catch (Unreachable _) {
            return new Flows();
        }
    }

    @Override
    public Flows<D> visit(RReil.Store stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        RootDomain domainState = (RootDomain)ctx._1();
        domainState = (RootDomain)domainState.eval(stmt);
        return Flows.next(ctx._3(), domainState);
    }

    @Override
    public Flows<D> visit(RReil.Nop stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        return Flows.next(ctx._3(), (RootDomain)ctx._1());
    }

    @Override
    public Flows<D> visit(RReil.BranchToRReil stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        Test notTakenBranch;
        Test takenBranch;
        Rhs condition;
        RootDomain domainState = (RootDomain)ctx._1();
        Flows<RootDomain> flow = new Flows<RootDomain>();
        Rhs.SimpleExpression exp = stmt.getCond();
        RReilFactory rreil = RReilFactory.instance;
        if (exp instanceof Rhs.RangeRhs) {
            throw new UnimplementedException();
        }
        if (exp instanceof Rhs.LinRval) {
            condition = ((Rhs.LinRval)exp).getRval();
            takenBranch = rreil.testIfNonZero((Rhs.Rval)condition);
            notTakenBranch = rreil.testIfZero((Rhs.Rval)condition);
        } else if (exp instanceof Rhs.Lin) {
            condition = (Rhs.Lin)exp;
            takenBranch = rreil.testIfNonZero((Rhs.Lin)condition);
            notTakenBranch = rreil.testIfZero((Rhs.Lin)condition);
        } else if (exp instanceof Rhs.Cmp) {
            condition = (Rhs.Cmp)exp;
            takenBranch = rreil.test((Rhs.Cmp)condition);
            notTakenBranch = takenBranch.not();
        } else {
            throw new RReilGrammarException();
        }
        Rhs.Address target = stmt.getTarget();
        try {
            RootDomain takenState = (RootDomain)domainState.eval(takenBranch);
            RReilAddr rreilTarget = target.getAddress();
            flow.addJump(rreilTarget, takenState);
        }
        catch (Unreachable takenState) {
            // empty catch block
        }
        try {
            RootDomain notTakenState = (RootDomain)domainState.eval(notTakenBranch);
            flow.addNext(ctx._3(), notTakenState);
        }
        catch (Unreachable notTakenState) {
            // empty catch block
        }
        if (flow.isEmpty()) {
            flow.addError(domainState);
            String msg = String.format("Targets for branch instruction %s: %s could not be resolved.", stmt.getRReilAddress(), stmt);
            throw new AnalysisException(msg);
        }
        return flow;
    }

    @Override
    public Flows<D> visit(RReil.BranchToNative stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        RootDomain resultState2;
        Test notTakenBranch;
        Test takenBranch;
        Rhs condition;
        RootDomain domainState = (RootDomain)ctx._1();
        Flows<RootDomain> flow = new Flows<RootDomain>();
        Rhs.SimpleExpression exp = stmt.getCond();
        RReilFactory rreil = RReilFactory.instance;
        if (exp instanceof Rhs.RangeRhs) {
            throw new UnimplementedException();
        }
        if (exp instanceof Rhs.LinRval) {
            condition = ((Rhs.LinRval)exp).getRval();
            takenBranch = rreil.testIfNonZero((Rhs.Rval)condition);
            notTakenBranch = rreil.testIfZero((Rhs.Rval)condition);
        } else if (exp instanceof Rhs.Lin) {
            condition = (Rhs.Lin)exp;
            takenBranch = rreil.testIfNonZero((Rhs.Lin)condition);
            notTakenBranch = rreil.testIfZero((Rhs.Lin)condition);
        } else if (exp instanceof Rhs.Cmp) {
            condition = (Rhs.Cmp)exp;
            takenBranch = rreil.test((Rhs.Cmp)condition);
            notTakenBranch = takenBranch.not();
        } else {
            throw new RReilGrammarException();
        }
        Rhs.Lin target = stmt.getTarget();
        try {
            resultState2 = (RootDomain)domainState.eval(notTakenBranch);
            flow.addNext(ctx._3(), resultState2);
        }
        catch (Unreachable resultState2) {
            // empty catch block
        }
        try {
            ProgramAddress jumpPoint;
            resultState2 = (RootDomain)domainState.eval(takenBranch);
            Range range = resultState2.queryRange(target);
            if (range == null) {
                throw new DomainStateException.VariableSupportSetException(target);
            }
            if (!range.isConstant()) {
                throw new UnsupportedOperationException("Non-constant branch target: " + range);
            }
            RReilAddr singleTarget = RReilAddr.valueOf(range.getConstantOrNull());
            P3<RootDomain, ProgramAddress, RReilAddr> newCtx = P3.tuple3(resultState2 = this.setInstructionPointerAdd(resultState2, singleTarget.base()), jumpPoint = new ProgramAddress(singleTarget), ctx._3());
            boolean handledByCallback = this.tryCallback(stmt, newCtx, flow);
            if (!handledByCallback) {
                flow.addJump(singleTarget, resultState2);
            }
        }
        catch (Unreachable resultState3) {
            // empty catch block
        }
        if (flow.isEmpty()) {
            flow.addError(domainState);
            String msg = String.format("Targets for branch instruction %s: %s could not be resolved.", stmt.getRReilAddress(), stmt);
            throw new AnalysisException(msg);
        }
        return flow;
    }

    @Override
    public Flows<D> visit(RReil.Branch stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        RootDomain domainState = (RootDomain)ctx._1();
        ProgramAddress nextInstructionAddress = new ProgramAddress(ctx._3());
        List targets = domainState.eval(stmt, ctx._2(), nextInstructionAddress);
        Flows<RootDomain> flow = new Flows<RootDomain>();
        for (P2 target : targets) {
            RReilAddr targetAddress = target._1();
            ProgramAddress jumpPoint = new ProgramAddress(targetAddress);
            RootDomain targetState = (RootDomain)target._2();
            P3<RootDomain, ProgramAddress, RReilAddr> newCtx = P3.tuple3(targetState = this.setInstructionPointerAdd(targetState, targetAddress.base()), jumpPoint, ctx._3());
            boolean handledByCallback = this.tryCallback(stmt, newCtx, flow);
            if (handledByCallback) continue;
            switch (stmt.getBranchType()) {
                case Call: {
                    flow.addCall(targetAddress, targetState);
                    break;
                }
                case Return: {
                    if (targetAddress.base() == this.analysisStartCanary) {
                        flow.addHalt(targetState);
                        break;
                    }
                    flow.addReturn(targetAddress, targetState);
                    break;
                }
                case Jump: {
                    flow.addJump(targetAddress, targetState);
                }
            }
        }
        if (flow.isEmpty()) {
            flow.addError(domainState);
            String msg = String.format("Targets for branch instruction %s: %s could not be resolved.", stmt.getRReilAddress(), stmt);
            throw new AnalysisException(msg);
        }
        return flow;
    }

    private D setInstructionPointerAssign(D state, long targetIP) {
        Platform platform = state.getContext().getEnvironment().getPlatform();
        int size = platform.defaultArchitectureSize();
        String ip = platform.getInstructionPointer();
        state = (RootDomain)state.eval(String.format("mov.%d %s, %d", size, ip, targetIP));
        return state;
    }

    private D setInstructionPointerAdd(D state, long targetIP) {
        Platform platform = state.getContext().getEnvironment().getPlatform();
        int size = platform.defaultArchitectureSize();
        String ip = platform.getInstructionPointer();
        String tmp = "ipJumpOffsetReg";
        String calcOffset = String.format("sub.%d %s, %d, %s", size, tmp, targetIP, ip);
        String addOffset = String.format("add.%d %s, %s, %s", size, ip, ip, tmp);
        state = (RootDomain)state.eval(calcOffset, addOffset);
        return state;
    }

    @Override
    public Flows<D> visit(RReil.PrimOp primOp, P3<D, ProgramPoint, RReilAddr> ctx) {
        RootDomain domainState = (RootDomain)ctx._1();
        RReilAddr nextInstructionaddress = ctx._3();
        if (primOp.is("halt", 0, 0)) {
            return Flows.halt(domainState);
        }
        try {
            domainState = (RootDomain)domainState.eval(primOp);
            return Flows.next(nextInstructionaddress, domainState);
        }
        catch (Unreachable _) {
            return Flows.error(domainState);
        }
    }

    @Override
    public Flows<D> visit(RReil.Native stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        AnalysisEnvironment env = ((RootDomain)ctx._1()).getContext().getEnvironment();
        SystemModel systemModel = env.getSystemModel();
        if (systemModel != null) {
            List<Option<FunctionDefinition>> functions = systemModel.handleNative(stmt, (RootDomain)ctx._1(), ctx._2());
            Flows<RootDomain> flows = new Flows<RootDomain>();
            if (functions.isEmpty()) {
                flows.addHalt((RootDomain)ctx._1());
                return flows;
            }
            for (Option<FunctionDefinition> optFunc : functions) {
                if (optFunc.isSome()) {
                    FunctionDefinition function = optFunc.get();
                    this.evaluateFunction(function, ctx, flows);
                    continue;
                }
                flows.addError((RootDomain)ctx._1());
            }
            return flows;
        }
        throw new UnsupportedOperationException("Natives not supported without SystemModel!");
    }

    @Override
    public Flows<D> visit(RReil.Assertion stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        RootDomain domainState = (RootDomain)ctx._1();
        RReilAddr nextInstructionaddress = ctx._3();
        return Flows.next(nextInstructionaddress, domainState);
    }

    private void evaluateFunction(FunctionDefinition function, P3<D, ProgramPoint, RReilAddr> ctx, Flows<D> flows) {
        RReilAddr startAddr = function.getInstructions().firstKey();
        Flows.Successor<RootDomain> init = new Flows.Successor<RootDomain>(Flows.FlowType.Jump, startAddr, (RootDomain)ctx._1());
        Stack todo = new Stack();
        todo.add(init);
        while (!todo.isEmpty()) {
            Flows.Successor succ = (Flows.Successor)todo.pop();
            switch (succ.getType()) {
                case Return: {
                    break;
                }
                case Halt: {
                    flows.addHalt((RootDomain)ctx._1());
                    break;
                }
                case Jump: 
                case Next: {
                    RReilAddr localAddr = succ.getAddress();
                    if (function.reachedEnd(localAddr)) {
                        flows.addNext(ctx._3(), (RootDomain)succ.getState());
                        break;
                    }
                    RReil rreil = (RReil)function.getInstructions().get(localAddr);
                    if (rreil == null) {
                        throw new IllegalStateException("Jumps to targets outside the local address space are not allowed inside functions!");
                    }
                    P3 localCtx = P3.tuple3(succ.getState(), ctx._2(), ctx._3());
                    Flows nextFlows = (Flows)rreil.accept(this, localCtx);
                    for (Flows.Successor nextSucc : nextFlows) {
                        todo.add(nextSucc);
                    }
                    break;
                }
                case Call: {
                    throw new IllegalStateException("No calls allowed inside native functions!");
                }
                case Error: {
                    flows.addError((RootDomain)ctx._1());
                    break;
                }
            }
        }
    }

    @Override
    public Flows<D> visit(RReil.Throw stmt, P3<D, ProgramPoint, RReilAddr> data) {
        throw new UnimplementedException();
    }

    @Override
    public Flows<D> visit(RReil.Flop stmt, P3<D, ProgramPoint, RReilAddr> data) {
        throw new UnimplementedException();
    }
}

