/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses;

import bindead.analyses.ProgramAddress;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.analyses.warnings.UnknownInstructionWarning;
import bindead.analyses.warnings.WarningsMap;
import bindead.domainnetwork.channels.WarningMessage;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.exceptions.UnknownCodeAddressException;
import bindis.DecodeCtx;
import bindis.DecodeException;
import bindis.Disassembler;
import bindis.x86.common.X86PrettyPrinter;
import binparse.Binary;
import binparse.Segment;
import binparse.Symbol;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import javalx.data.Option;
import javalx.numeric.FiniteRange;
import javalx.persistentcollections.tree.FiniteRangeTree;
import javalx.persistentcollections.tree.OverlappingRanges;
import rreil.disassembler.BlockOfInstructions;
import rreil.disassembler.Instruction;
import rreil.disassembler.UnknownInstruction;
import rreil.lang.RReilAddr;

public class BinaryCodeCache {
    private final Binary binary;
    private final Disassembler disassembler;
    private FiniteRangeTree<Segment> segments = FiniteRangeTree.empty();
    private final SortedMap<Long, Instruction> instructions = new TreeMap<Long, Instruction>();
    private final SortedMap<Long, BlockOfInstructions> blocks = new TreeMap<Long, BlockOfInstructions>();
    private final Map<Long, String> symbolsCache = new HashMap<Long, String>();
    private final boolean SKIPUNKNOWNINSNS;
    private final boolean DISASSEMBLEBLOCKS;
    private WarningsMap warningsMap;

    public BinaryCodeCache(Binary binary, Disassembler dis, WarningsMap warningsMap) {
        this.SKIPUNKNOWNINSNS = AnalysisProperties.INSTANCE.skipDisassembleErrors.isTrue();
        this.DISASSEMBLEBLOCKS = AnalysisProperties.INSTANCE.disassembleBlockWise.isTrue();
        this.binary = binary;
        this.disassembler = dis;
        this.warningsMap = warningsMap;
        this.loadCodeSegments();
    }

    public Binary getBinary() {
        return this.binary;
    }

    public int instructionsCount() {
        return this.instructions.size();
    }

    public SortedMap<Long, Instruction> getInstructions() {
        return this.instructions;
    }

    public Instruction getInstruction(long nativeAddress) {
        if (!this.hasInstruction(nativeAddress)) {
            throw new IllegalArgumentException("Instruction for address " + nativeAddress + " not found.");
        }
        return (Instruction)this.instructions.get(nativeAddress);
    }

    public boolean hasInstruction(long nativeAddress) {
        if (this.DISASSEMBLEBLOCKS) {
            return this.blocks.containsKey(nativeAddress);
        }
        return this.instructions.containsKey(nativeAddress);
    }

    private void addWarning(long nativeAddress, WarningMessage warning) {
        ProgramAddress location = new ProgramAddress(RReilAddr.valueOf(nativeAddress));
        WarningsContainer warnings = this.warningsMap.get(location);
        warnings.addWarning(warning);
        this.warningsMap.put(location, 0, warnings);
    }

    public Instruction decodeInstruction(long nativeAddress) {
        Instruction insn;
        Segment segment = this.findSegment(nativeAddress);
        try {
            insn = this.disassembler.decodeOne(segment.getData(), (int)(nativeAddress - segment.getAddress()), nativeAddress);
        }
        catch (DecodeException e) {
            if (this.SKIPUNKNOWNINSNS) {
                DecodeCtx ctx = e.getErrCtx().getDecodeCtx();
                insn = new UnknownInstruction(ctx.getStartPc(), ctx.slice());
                this.addWarning(nativeAddress, new UnknownInstructionWarning(insn));
            }
            throw e;
        }
        this.instructions.put(nativeAddress, insn);
        return insn;
    }

    public BlockOfInstructions decodeBlock(long nativeAddress) {
        Segment segment = this.findSegment(nativeAddress);
        BlockOfInstructions block = this.disassembler.decodeBlock(segment.getData(), (int)(nativeAddress - segment.getAddress()), nativeAddress);
        this.blocks.put(nativeAddress, block);
        for (Instruction insn : block.getInstructions()) {
            this.instructions.put(insn.baseAddress(), insn);
        }
        return block;
    }

    public long getNextDisassemblyAddress(long nativeAddress) {
        BlockOfInstructions block = (BlockOfInstructions)this.blocks.get(nativeAddress);
        if (block != null) {
            return nativeAddress + (long)block.byteLength();
        }
        Instruction insn = (Instruction)this.instructions.get(nativeAddress);
        if (insn != null) {
            return nativeAddress + (long)insn.length();
        }
        throw new IllegalArgumentException("Instruction for address " + nativeAddress + " not found.");
    }

    private Segment findSegment(long nativeAddress) throws UnknownCodeAddressException {
        OverlappingRanges<Segment> overlapping = this.segments.searchOverlaps(FiniteRange.of(nativeAddress));
        switch (overlapping.size()) {
            case 0: {
                throw new UnknownCodeAddressException();
            }
            case 1: {
                return overlapping.getFirst()._2();
            }
        }
        throw new UnknownCodeAddressException();
    }

    private void loadCodeSegments() {
        for (Segment s : this.binary.getSegments()) {
            if (s.getSize() <= 0L) continue;
            FiniteRange key = BinaryCodeCache.intervalKey(s);
            this.segments = this.segments.bind(key, s);
        }
    }

    private static FiniteRange intervalKey(Segment s) {
        long size = s.getSize();
        long address = s.getAddress();
        assert (size > 0L) : "invalid Segment size";
        return FiniteRange.of(address, address + size - 1L);
    }

    public String toString() {
        return this.toDisassemblyString();
    }

    public String toDisassemblyString() {
        Long endOfPreviousInstruction = null;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Long, Instruction> entry : this.getInstructions().entrySet()) {
            Long address = entry.getKey();
            Instruction instruction = entry.getValue();
            if (endOfPreviousInstruction != null && !endOfPreviousInstruction.equals(address)) {
                long gapLength = address - endOfPreviousInstruction;
                builder.append("...........");
                builder.append("(" + gapLength + " bytes)\n");
            }
            endOfPreviousInstruction = address + (long)instruction.length();
            Option<Symbol> symbol = this.binary.getSymbol(address);
            if (symbol.isSome()) {
                builder.append("\n" + symbol.get() + ":\n");
            }
            String addressString = String.format("%08x", address);
            String opcode = String.format("%-33s", instruction.opcode(new StringBuilder()).toString());
            builder.append(addressString + ": ");
            builder.append(" " + opcode + " ");
            builder.append(this.toRichInstructionString(instruction));
            builder.append("\n");
        }
        return builder.toString();
    }

    public String toRichInstructionString(Instruction instruction) {
        return this.appendSymbolForJumpsCalls(instruction);
    }

    private String appendSymbolForJumpsCalls(Instruction instruction) {
        String architecture = this.binary.getArchitectureName();
        if (architecture.equals("x86-32") || architecture.equals("x86-64")) {
            X86PrettyPrinter printer = new X86PrettyPrinter(instruction);
            return printer.getRichInstruction(this.binary);
        }
        return instruction.toString();
    }

    public String getEnclosingFunction(Instruction instruction) {
        Long address = instruction.baseAddress();
        String functionName = this.symbolsCache.get(address);
        if (functionName == null) {
            block7: {
                Option<Symbol> functionSymbol = this.binary.getSymbol(address);
                if (functionSymbol.isSome()) {
                    functionName = functionSymbol.get().toString();
                } else {
                    Long previousInstructionAddress = address;
                    do {
                        try {
                            previousInstructionAddress = this.instructions.headMap(previousInstructionAddress).lastKey();
                        }
                        catch (IllegalArgumentException _) {
                            functionName = "<unkn>";
                            break block7;
                        }
                        catch (NoSuchElementException _) {
                            functionName = "<unkn>";
                            break block7;
                        }
                    } while (!(functionSymbol = this.binary.getSymbol(previousInstructionAddress)).isSome());
                    functionName = functionSymbol.get().toString();
                }
            }
            this.symbolsCache.put(address, functionName);
        }
        return functionName;
    }
}

