/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Dimchange;
import apron.Dimperm;
import apron.Environment;
import apron.Texpr0Node;
import apron.Texpr1BinNode;
import apron.Texpr1Node;
import java.io.Serializable;

public class Texpr0BinNode
extends Texpr0Node
implements Cloneable,
Serializable {
    public int op;
    public int rtype;
    public int rdir;
    public Texpr0Node lArg;
    public Texpr0Node rArg;
    public static final int OP_ADD = 0;
    public static final int OP_SUB = 1;
    public static final int OP_MUL = 2;
    public static final int OP_DIV = 3;
    public static final int OP_MOD = 4;
    public static final int OP_POW = 5;

    public static String opName(int n) {
        switch (n) {
            case 0: {
                return "+";
            }
            case 1: {
                return "-";
            }
            case 2: {
                return "*";
            }
            case 3: {
                return "/";
            }
            case 4: {
                return "%";
            }
            case 5: {
                return "^";
            }
        }
        throw new IllegalArgumentException("unknown binary operation: " + n);
    }

    public static int opPrecedence(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
        }
        throw new IllegalArgumentException("unknown binary operation: " + n);
    }

    public Texpr0BinNode(int n, int n2, int n3, Texpr0Node texpr0Node, Texpr0Node texpr0Node2) {
        this.op = n;
        this.rtype = n2;
        this.rdir = n3;
        this.lArg = texpr0Node;
        this.rArg = texpr0Node2;
    }

    public Texpr0BinNode(int n, Texpr0Node texpr0Node, Texpr0Node texpr0Node2) {
        this(n, 0, 4, texpr0Node, texpr0Node2);
    }

    @Override
    public Texpr0Node shallowCopy() {
        return new Texpr0BinNode(this.op, this.rtype, this.rdir, this.lArg, this.rArg);
    }

    @Override
    public Texpr0Node deepCopy() {
        return new Texpr0BinNode(this.op, this.rtype, this.rdir, this.lArg.deepCopy(), this.rArg.deepCopy());
    }

    @Override
    public Texpr1Node toTexpr1Node(Environment environment) {
        return new Texpr1BinNode(this.op, this.rtype, this.rdir, this.lArg.toTexpr1Node(environment), this.rArg.toTexpr1Node(environment));
    }

    @Override
    public String toString(String[] stringArray) {
        String string = Texpr0BinNode.opName(this.op);
        String string2 = this.rtype == 0 ? "" : "_" + Texpr0BinNode.suffixRType(this.rtype) + "," + Texpr0BinNode.suffixRDir(this.rdir);
        String string3 = this.lArg.toString(stringArray);
        String string4 = this.rArg.toString(stringArray);
        if (this.lArg.getPrecedence() < Texpr0BinNode.opPrecedence(this.op)) {
            string3 = "(" + string3 + ")";
        }
        if (this.rArg.getPrecedence() <= Texpr0BinNode.opPrecedence(this.op)) {
            string4 = "(" + string4 + ")";
        }
        return string3 + " " + string + string2 + " " + string4;
    }

    public int getOperation() {
        return this.op;
    }

    public void setOperation(int n) {
        this.op = n;
    }

    public int getRoundingType() {
        return this.rtype;
    }

    public void setRoundingType(int n) {
        this.rtype = n;
    }

    public int getRoundingDirection() {
        return this.rdir;
    }

    public void setRoundingDirection(int n) {
        this.rdir = n;
    }

    public Texpr0Node getLeftArgument() {
        return this.lArg;
    }

    public void setLeftArgument(Texpr0Node texpr0Node) {
        this.lArg = texpr0Node;
    }

    public Texpr0Node getRightArgument() {
        return this.rArg;
    }

    public void setRightArgument(Texpr0Node texpr0Node) {
        this.rArg = texpr0Node;
    }

    @Override
    public int getDepth() {
        int n;
        int n2 = this.lArg.getDepth();
        return (n2 > (n = this.rArg.getDepth()) ? n2 : n) + 1;
    }

    @Override
    public int getSize() {
        return this.lArg.getSize() + this.rArg.getSize() + 1;
    }

    @Override
    public int maxDim() {
        int n;
        int n2 = this.lArg.maxDim();
        return n2 > (n = this.rArg.maxDim()) ? n2 : n;
    }

    @Override
    public boolean hasDim(int n) {
        return this.lArg.hasDim(n) || this.rArg.hasDim(n);
    }

    @Override
    protected void fillDims(boolean[] blArray) {
        this.lArg.fillDims(blArray);
        this.rArg.fillDims(blArray);
    }

    @Override
    public boolean isIntervalCst() {
        return this.lArg.isIntervalCst() && this.rArg.isIntervalCst();
    }

    @Override
    public boolean isIntervalLinear() {
        if (this.rtype != 0) {
            return false;
        }
        switch (this.op) {
            case 0: 
            case 1: {
                return this.lArg.isIntervalLinear() && this.rArg.isIntervalLinear();
            }
            case 2: {
                return this.lArg.isIntervalLinear() && this.rArg.isIntervalCst() || this.rArg.isIntervalLinear() && this.lArg.isIntervalCst();
            }
            case 3: {
                return this.lArg.isIntervalLinear() && this.rArg.isIntervalCst();
            }
        }
        return false;
    }

    @Override
    public boolean isIntervalPolynomial() {
        if (this.rtype != 0) {
            return false;
        }
        switch (this.op) {
            case 0: 
            case 1: 
            case 2: {
                return this.lArg.isIntervalPolynomial() && this.rArg.isIntervalPolynomial();
            }
            case 3: {
                return this.lArg.isIntervalPolynomial() && this.rArg.isIntervalCst();
            }
            case 5: {
                return this.lArg.isIntervalPolynomial() && this.rArg.isIntervalCst();
            }
        }
        return false;
    }

    @Override
    public boolean isIntervalPolyfrac() {
        if (this.rtype != 0) {
            return false;
        }
        switch (this.op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.lArg.isIntervalPolyfrac() && this.rArg.isIntervalPolyfrac();
            }
            case 5: {
                return this.lArg.isIntervalPolyfrac() && this.rArg.isIntervalCst();
            }
        }
        return false;
    }

    @Override
    public boolean isScalar() {
        return this.lArg.isScalar() && this.rArg.isScalar();
    }

    @Override
    public Texpr0Node substitute(int n, Texpr0Node texpr0Node) {
        this.lArg = this.lArg.substitute(n, texpr0Node);
        this.rArg = this.rArg.substitute(n, texpr0Node);
        return this;
    }

    @Override
    public void addDimensions(Dimchange dimchange) {
        this.lArg.addDimensions(dimchange);
        this.rArg.addDimensions(dimchange);
    }

    @Override
    public Texpr0Node removeDimensions(Dimchange dimchange) {
        this.lArg = this.lArg.removeDimensions(dimchange);
        this.rArg = this.rArg.removeDimensions(dimchange);
        return this;
    }

    @Override
    public void permuteDimensions(Dimperm dimperm) {
        this.lArg.permuteDimensions(dimperm);
        this.rArg.permuteDimensions(dimperm);
    }

    @Override
    public int hashCode() {
        return this.lArg.hashCode() ^ this.rArg.hashCode() ^ this.rtype ^ this.rdir ^ this.op;
    }

    @Override
    public boolean isEqual(Texpr0Node texpr0Node) {
        if (texpr0Node instanceof Texpr0BinNode) {
            Texpr0BinNode texpr0BinNode = (Texpr0BinNode)texpr0Node;
            return this.op == texpr0BinNode.op && this.rtype == texpr0BinNode.rtype && this.rdir == texpr0BinNode.rdir && this.lArg.isEqual(texpr0BinNode.lArg) && this.rArg.isEqual(texpr0BinNode.rArg);
        }
        return false;
    }

    @Override
    public int getPrecedence() {
        return Texpr0BinNode.opPrecedence(this.op);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Texpr0BinNode && this.isEqual((Texpr0BinNode)object);
    }
}

