/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Coeff;
import apron.DoubleScalar;
import apron.MpfrScalar;
import apron.MpqScalar;
import apron.Scalar;
import gmp.Mpfr;
import gmp.Mpq;
import gmp.Mpz;
import java.io.Serializable;
import java.math.BigInteger;

public class Interval
extends Coeff
implements Cloneable,
Serializable {
    public Scalar inf;
    public Scalar sup;

    public Interval() {
        this.inf = new DoubleScalar(0.0);
        this.sup = new DoubleScalar(0.0);
    }

    public Interval(Scalar scalar, Scalar scalar2) {
        this.inf = scalar;
        this.sup = scalar2;
    }

    public Interval(Interval interval) {
        this.inf = interval.inf.copy();
        this.sup = interval.sup.copy();
    }

    public Interval(int n, int n2) {
        this.inf = new MpqScalar(n);
        this.sup = new MpqScalar(n2);
    }

    public Interval(int n, int n2, int n3, int n4) {
        this.inf = new MpqScalar(n, n2);
        this.sup = new MpqScalar(n3, n4);
    }

    public Interval(BigInteger bigInteger, BigInteger bigInteger2) {
        this.inf = new MpqScalar(bigInteger);
        this.sup = new MpqScalar(bigInteger2);
    }

    public Interval(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.inf = new MpqScalar(bigInteger, bigInteger2);
        this.sup = new MpqScalar(bigInteger3, bigInteger4);
    }

    public Interval(Mpz mpz, Mpz mpz2) {
        this.inf = new MpqScalar(mpz);
        this.sup = new MpqScalar(mpz2);
    }

    public Interval(Mpz mpz, Mpz mpz2, Mpz mpz3, Mpz mpz4) {
        this.inf = new MpqScalar(mpz, mpz2);
        this.sup = new MpqScalar(mpz3, mpz4);
    }

    public Interval(Mpq mpq, Mpq mpq2) {
        this.inf = new MpqScalar(mpq);
        this.sup = new MpqScalar(mpq2);
    }

    public Interval(double d, double d2) {
        this.inf = new DoubleScalar(d);
        this.sup = new DoubleScalar(d2);
    }

    public Interval(Mpfr mpfr, Mpfr mpfr2) {
        this.inf = new MpfrScalar(mpfr);
        this.sup = new MpfrScalar(mpfr2);
    }

    @Override
    public Interval copy() {
        return new Interval(this);
    }

    public void setInf(Scalar scalar) {
        this.inf = scalar;
    }

    public void setSup(Scalar scalar) {
        this.sup = scalar;
    }

    public void setTop() {
        this.inf.setInfty(-1);
        this.sup.setInfty(1);
    }

    public void setBottom() {
        this.inf.set(1);
        this.sup.set(-1);
    }

    public boolean isTop() {
        return this.inf.isInfty() < 0 && this.sup.isInfty() > 0;
    }

    public boolean isBottom() {
        return this.inf.cmp(this.sup) > 0;
    }

    @Override
    public boolean isZero() {
        return this.inf.isEqual(0) && this.sup.isEqual(0);
    }

    public boolean isLeq(Interval interval) {
        int n = this.inf.cmp(interval.inf);
        int n2 = this.sup.cmp(interval.sup);
        return n >= 0 && n2 <= 0 || this.isBottom();
    }

    public int cmp(Interval interval) {
        int n = this.inf.cmp(interval.inf);
        int n2 = this.sup.cmp(interval.sup);
        if (n == 0 && n2 == 0) {
            return 0;
        }
        if (n >= 0 && n2 <= 0) {
            return -1;
        }
        if (n <= 0 && n2 >= 0) {
            return 1;
        }
        boolean bl = this.isBottom();
        boolean bl2 = interval.isBottom();
        if (bl && bl2) {
            return 0;
        }
        if (bl) {
            return -1;
        }
        if (bl2) {
            return 1;
        }
        if (n > 0) {
            return 2;
        }
        return -2;
    }

    public boolean isEqual(Interval interval) {
        return this.inf.isEqual(interval.inf) && this.sup.isEqual(interval.sup) || this.isBottom() && interval.isBottom();
    }

    @Override
    public boolean isEqual(int n) {
        return this.inf.isEqual(n) && this.sup.isEqual(n);
    }

    @Override
    public boolean isScalar() {
        return this.inf.isEqual(this.sup);
    }

    @Override
    public boolean isEqual(Coeff coeff) {
        if (coeff instanceof Interval) {
            return this.isEqual((Interval)coeff);
        }
        if (coeff instanceof Scalar) {
            Scalar scalar = (Scalar)coeff;
            return this.inf.isEqual(scalar) && this.sup.isEqual(scalar);
        }
        throw new IllegalArgumentException("unknown Coeff subtype");
    }

    @Override
    public int cmp(Coeff coeff) {
        if (coeff instanceof Interval) {
            return this.cmp((Interval)coeff);
        }
        if (coeff instanceof Scalar) {
            Scalar scalar = (Scalar)coeff;
            return this.cmp(new Interval(scalar, scalar));
        }
        throw new IllegalArgumentException("unknown Coeff subtype");
    }

    @Override
    public void neg() {
        Scalar scalar = this.inf;
        this.inf = this.sup;
        this.sup = scalar;
        this.inf.neg();
        this.sup.neg();
    }

    @Override
    public Scalar inf() {
        return this.inf;
    }

    @Override
    public Scalar sup() {
        return this.sup;
    }

    @Override
    public String toString() {
        return "[" + this.inf + "," + this.sup + "]";
    }

    @Override
    public int hashCode() {
        return this.inf.hashCode() ^ this.sup.hashCode();
    }

    public Interval clone() throws CloneNotSupportedException {
        return this.copy();
    }
}

