# -*- coding: utf-8 -*-
# Generated by Django 1.9.8 on 2017-07-27 17:37
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AuthGroup',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=80, unique=True)),
            ],
            options={
                'db_table': 'auth_group',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='AuthGroupPermissions',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'auth_group_permissions',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='AuthPermission',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('codename', models.CharField(max_length=100)),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'db_table': 'auth_permission',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='AuthUser',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('password', models.CharField(max_length=128)),
                ('last_login', models.DateTimeField(blank=True, null=True)),
                ('is_superuser', models.BooleanField()),
                ('first_name', models.CharField(max_length=30)),
                ('last_name', models.CharField(max_length=30)),
                ('email', models.CharField(max_length=254)),
                ('is_staff', models.BooleanField()),
                ('is_active', models.BooleanField()),
                ('date_joined', models.DateTimeField()),
                ('username', models.CharField(max_length=150, unique=True)),
            ],
            options={
                'db_table': 'auth_user',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='AuthUserGroups',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'auth_user_groups',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='AuthUserUserPermissions',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
            ],
            options={
                'db_table': 'auth_user_user_permissions',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DjangoAdminLog',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('object_id', models.TextField(blank=True, null=True)),
                ('object_repr', models.CharField(max_length=200)),
                ('action_flag', models.PositiveSmallIntegerField()),
                ('change_message', models.TextField()),
                ('action_time', models.DateTimeField()),
            ],
            options={
                'db_table': 'django_admin_log',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DjangoContentType',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('app_label', models.CharField(max_length=100)),
                ('model', models.CharField(max_length=100)),
            ],
            options={
                'db_table': 'django_content_type',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DjangoMigrations',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('app', models.CharField(max_length=255)),
                ('name', models.CharField(max_length=255)),
                ('applied', models.DateTimeField()),
            ],
            options={
                'db_table': 'django_migrations',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DjangoSession',
            fields=[
                ('session_key', models.CharField(max_length=40, primary_key=True, serialize=False)),
                ('session_data', models.TextField()),
                ('expire_date', models.DateTimeField()),
            ],
            options={
                'db_table': 'django_session',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DocResults',
            fields=[
                ('id', models.IntegerField(blank=True, primary_key=True, serialize=False)),
                ('project_id', models.IntegerField(blank=True, null=True)),
                ('doc_ext', models.TextField(blank=True, null=True)),
                ('doc_url', models.TextField(blank=True, null=True)),
                ('doc_location', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'doc_results',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='LinkedinCompanyEmployees',
            fields=[
                ('id', models.IntegerField(blank=True, primary_key=True, serialize=False)),
                ('project_id', models.IntegerField(blank=True, null=True)),
                ('name', models.TextField(blank=True, null=True)),
                ('job_title', models.TextField(blank=True, null=True)),
                ('linkedin_url', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'db_table': 'linkedin_company_employees',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='LinkedinCompanyInfo',
            fields=[
                ('id', models.IntegerField(blank=True, primary_key=True, serialize=False)),
                ('project_id', models.IntegerField(blank=True, null=True)),
                ('company_name', models.IntegerField(blank=True, null=True)),
                ('company_linkedin_url', models.IntegerField(blank=True, null=True)),
                ('company_description', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'db_table': 'linkedin_company_info',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='MailHarvestResults',
            fields=[
                ('id', models.IntegerField(blank=True, primary_key=True, serialize=False)),
                ('project_id', models.IntegerField(blank=True, null=True)),
                ('mail_results', models.TextField(blank=True, null=True)),
                ('mail_pgp_results', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'mail_harvest_results',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='MainDomainResults',
            fields=[
                ('id', models.IntegerField(blank=True, primary_key=True, serialize=False)),
                ('project_id', models.IntegerField(blank=True, null=True)),
                ('domain', models.TextField(blank=True, null=True)),
                ('domain_whois', models.TextField(blank=True, null=True)),
                ('email', models.TextField(blank=True, null=True)),
                ('domain_reputation', models.TextField(blank=True, null=True)),
                ('domain_blacklist', models.TextField(blank=True, null=True)),
                ('ns_record', models.TextField(blank=True, db_column='NS_record', null=True)),
                ('mx_record', models.TextField(blank=True, db_column='MX_record', null=True)),
            ],
            options={
                'db_table': 'main_domain_results',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Projects',
            fields=[
                ('project_id', models.IntegerField(blank=True, primary_key=True, serialize=False)),
                ('project_domain', models.TextField(blank=True, null=True)),
                ('project_org', models.TextField(blank=True, null=True)),
                ('started_time', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'projects',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='SubdomainResults',
            fields=[
                ('id', models.IntegerField(blank=True, primary_key=True, serialize=False)),
                ('project_id', models.IntegerField(blank=True, null=True)),
                ('subdomain', models.TextField(blank=True, null=True)),
                ('ip_address', models.TextField(blank=True, null=True)),
                ('banner', models.TextField(blank=True, null=True)),
                ('wappalyzer', models.TextField(blank=True, null=True)),
                ('robots_txt', models.TextField(blank=True, null=True)),
                ('is_contain_git', models.IntegerField(blank=True, null=True)),
                ('is_contain_svn', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'db_table': 'subdomain_results',
                'managed': True,
            },
        ),
    ]
