/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.enumeration;

import java.net.InetAddress;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.ServerRuntimeException;
import java.rmi.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import nb.barmie.modes.enumeration.RMIEndpoint;
import nb.barmie.modes.enumeration.RMIReplyDataParser;
import nb.barmie.net.TCPEndpoint;
import nb.barmie.net.TimeoutClientSocketFactory;
import nb.barmie.net.proxy.RMIReturnDataCapturingProxy;
import nb.barmie.util.ProgramOptions;

public class RMIEnumerator {
    private final String DEFAULT_UNBIND_NAME = "7a7e92763ffa6ed3a01bc9308dec09a944a6c9ffe6475be7cf70b2ab660ea000d60db9dfe2acee3a59d162da82800bb6de2e5f515dc57b24dfbfa233973c43cb";
    private final ProgramOptions _options;

    public RMIEnumerator(ProgramOptions options) {
        this._options = options;
    }

    public RMIEndpoint enumerateEndpoint(TCPEndpoint target) {
        Registry reg;
        RMIEndpoint rmie = new RMIEndpoint(target);
        try {
            reg = LocateRegistry.getRegistry(target.getHost(), target.getPort(), new TimeoutClientSocketFactory(this._options.getSocketTimeout()));
        }
        catch (RemoteException re) {
            throw new RuntimeException("Unable to create a java.rmi.Registry reference for the endpoint '" + target.getHost() + ":" + target.getPort() + "'.");
        }
        try {
            String[] objectNames = reg.list();
            rmie.setIsRMIEndpoint(true);
            rmie.setIsRegistry(true);
            try {
                String unbindName = this.getUnboundObjectName(objectNames);
                reg.unbind(unbindName);
            }
            catch (NotBoundException nbe) {
                rmie.setIsRemotelyModifiable(true);
            }
            catch (Exception nbe) {
                // empty catch block
            }
            RMIReturnDataCapturingProxy rmiProxy = new RMIReturnDataCapturingProxy(InetAddress.getByName(target.getHost()), target.getPort(), this._options);
            rmiProxy.startProxy();
            reg = LocateRegistry.getRegistry(rmiProxy.getServerListenAddress().getHostAddress(), rmiProxy.getServerListenPort(), new TimeoutClientSocketFactory(this._options.getSocketTimeout()));
            objectNames = reg.list();
            RMIReplyDataParser replyParser = new RMIReplyDataParser();
            for (int i = 0; i < objectNames.length; ++i) {
                rmiProxy.resetDataBuffer();
                try {
                    Remote obj = reg.lookup(objectNames[i]);
                }
                catch (Exception nbe) {
                    // empty catch block
                }
                Thread.sleep(250L);
                if (rmiProxy.didReconnect()) {
                    rmiProxy.resetReconnectFlag();
                    --i;
                    continue;
                }
                rmie.addRMIObject(replyParser.extractObjectDetails(objectNames[i], rmiProxy.getDataBuffer()));
            }
            rmiProxy.stopProxy(true);
        }
        catch (AccessException ae) {
            rmie.setIsRMIEndpoint(true);
            rmie.setIsRegistry(true);
            rmie.setEnumException(ae);
        }
        catch (NoSuchObjectException | ServerError | ServerException | ServerRuntimeException se) {
            rmie.setIsRMIEndpoint(true);
            rmie.setEnumException(se);
        }
        catch (ConnectException | ConnectIOException | UnknownHostException ce) {
            rmie.setEnumException(ce);
        }
        catch (Exception re) {
            rmie.setEnumException(re);
        }
        return rmie;
    }

    private String getUnboundObjectName(String[] objectNames) {
        ArrayList<String> objNames = new ArrayList<String>(Arrays.asList(objectNames));
        String objName = this.DEFAULT_UNBIND_NAME;
        SecureRandom sRand = new SecureRandom();
        while (objNames.contains(objName)) {
            objName = Long.toHexString(sRand.nextLong()) + Long.toHexString(sRand.nextLong()) + Long.toHexString(sRand.nextLong());
        }
        return objName;
    }
}

