/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.OutputZipFile;
import com.android.sched.util.file.StreamFileStatus;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.ZipLocation;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.InMemoryVDir;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VFSStatCategory;
import com.android.sched.vfs.VPath;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class WriteZipFS
extends BaseVFS<ZipVDir, ZipVFile>
implements VFS {
    @Nonnull
    private static final Set<Capabilities> CAPABILITIES = Collections.unmodifiableSet(EnumSet.of(Capabilities.WRITE, Capabilities.CASE_SENSITIVE));
    @Nonnull
    private final ZipVDir root = new ZipVDir(this, new ZipEntry(""), "");
    @Nonnull
    private final AtomicBoolean lastVFileOpen = new AtomicBoolean(false);
    @Nonnull
    private final OutputZipFile zipFile;
    @CheckForNull
    private String infoString;

    public WriteZipFS(@Nonnull OutputZipFile zipFile) {
        this.zipFile = zipFile;
    }

    void notifyVFileClosed() {
        boolean previousState = this.lastVFileOpen.getAndSet(false);
        assert (previousState);
    }

    boolean notifyVFileOpenAndReturnPreviousState() {
        return this.lastVFileOpen.getAndSet(true);
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "zip archive writer";
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.zipFile.getLocation();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.zipFile.getPath();
    }

    @Override
    @Nonnull
    public ZipVDir getRootDir() {
        return this.root;
    }

    @Override
    public synchronized void close() throws CannotCloseException {
        if (!this.closed) {
            if (this.zipFile.getStatus() == StreamFileStatus.OPEN) {
                try {
                    this.zipFile.getOutputStream().close();
                }
                catch (IOException e) {
                    throw new CannotCloseException((HasLocation)this, (Exception)e);
                }
            }
            this.closed = true;
        }
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull ZipVFile file) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    synchronized OutputStream openWrite(@Nonnull ZipVFile file) {
        assert (!this.isClosed());
        if (this.notifyVFileOpenAndReturnPreviousState()) {
            throw new AssertionError((Object)(this.getLocation().getDescription() + " cannot be written to because a previous stream has not been closed."));
        }
        return new ZipEntryOutputStream(this, file.getZipEntry());
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull ZipVFile file, boolean append) {
        if (append) {
            throw new UnsupportedOperationException();
        }
        return this.openWrite(file);
    }

    @Override
    @Nonnull
    ZipVDir getVDir(@Nonnull ZipVDir parent, @Nonnull String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    ZipVFile getVFile(@Nonnull ZipVDir parent, @Nonnull String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    ZipVDir createVDir(@Nonnull ZipVDir parent, @Nonnull String name) {
        assert (!this.isClosed());
        return new ZipVDir(this, new ZipEntry(parent.getZipEntry().getName() + name + '/'), name);
    }

    @Override
    @Nonnull
    ZipVFile createVFile(@Nonnull ZipVDir parent, @Nonnull String name) {
        assert (!this.isClosed());
        ZipVFile vFile = new ZipVFile(this, new ZipEntry(parent.getZipEntry().getName() + name), name);
        VFSStatCategory.ZIP_CREATED_ENTRIES.getCounterStat(this.getTracer(), this.infoString).incValue();
        return vFile;
    }

    @Override
    @Nonnull
    void delete(@Nonnull ZipVFile file) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull ZipVDir dir) {
        return dir.list();
    }

    @Override
    boolean isEmpty(@Nonnull ZipVDir dir) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    FileTime getLastModified(@Nonnull ZipVFile file) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull ZipVFile file) {
        return new ZipLocation(this.zipFile.getLocation(), file.getZipEntry());
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull ZipVDir parent, @Nonnull String name) {
        return new ZipLocation(this.zipFile.getLocation(), new ZipEntry(parent.getZipEntry().getName() + name));
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull ZipVDir dir) {
        return new ZipLocation(this.zipFile.getLocation(), dir.getZipEntry());
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull ZipVDir parent, @Nonnull String name) {
        return new ZipLocation(this.zipFile.getLocation(), new ZipEntry(parent.getZipEntry().getName() + name + '/'));
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull ZipVDir parent, @Nonnull VPath path) {
        return new ZipLocation(this.zipFile.getLocation(), new ZipEntry(parent.getZipEntry().getName() + path.getPathAsString('/')));
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull ZipVDir parent, @Nonnull VPath path) {
        return new ZipLocation(this.zipFile.getLocation(), new ZipEntry(parent.getZipEntry().getName() + path.getPathAsString('/') + '/'));
    }

    @Override
    public boolean needsSequentialWriting() {
        return true;
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull ZipVDir parent, @Nonnull ZipVFile file) {
        String fileEntryPath = file.getZipEntry().getName();
        String parentEntryPath = parent.getZipEntry().getName();
        assert (fileEntryPath.contains(parentEntryPath));
        String newPath = fileEntryPath.substring(fileEntryPath.indexOf(parentEntryPath));
        return new VPath(newPath, '/');
    }

    @Override
    @Nonnull
    VPath getPathFromRoot(@Nonnull ZipVFile file) {
        return this.getPathFromDir(this.root, file);
    }

    public void setInfoString(@CheckForNull String infoString) {
        this.infoString = infoString;
    }

    @Override
    public String getInfoString() {
        return this.infoString;
    }

    public String toString() {
        return "wZipFS: " + this.getLocation().getDescription();
    }

    private static class ZipEntryOutputStream
    extends FilterOutputStream {
        @Nonnull
        private final WriteZipFS vfs;
        @Nonnull
        private final ZipEntry zipEntry;
        private boolean entryWritten = false;

        public ZipEntryOutputStream(@Nonnull WriteZipFS vfs, @Nonnull ZipEntry zipEntry) {
            super(vfs.zipFile.getOutputStream());
            this.vfs = vfs;
            this.zipEntry = zipEntry;
        }

        @Override
        public void close() throws IOException {
            this.writeEntryIfNeeded();
            this.vfs.notifyVFileClosed();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.writeEntryIfNeeded();
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.writeEntryIfNeeded();
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.writeEntryIfNeeded();
            this.out.write(b);
        }

        private synchronized void writeEntryIfNeeded() throws IOException {
            if (!this.entryWritten) {
                try {
                    ((ZipOutputStream)this.out).putNextEntry(this.zipEntry);
                }
                catch (ZipException e) {
                    throw new AssertionError((Object)e);
                }
                this.entryWritten = true;
            }
        }
    }

    static class ZipVFile
    extends BaseVFile {
        @Nonnull
        private final ZipEntry zipEntry;

        ZipVFile(@Nonnull BaseVFS<? extends ZipVDir, ? extends ZipVFile> vfs, @Nonnull ZipEntry zipEntry, @Nonnull String name) {
            super(vfs, name);
            this.zipEntry = zipEntry;
        }

        @Nonnull
        public ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        @Override
        @Nonnull
        public VPath getPath() {
            return new VPath(this.zipEntry.getName(), '/');
        }
    }

    static class ZipVDir
    extends InMemoryVDir {
        @Nonnull
        private final ZipEntry zipEntry;

        ZipVDir(@Nonnull BaseVFS<? extends ZipVDir, ? extends ZipVFile> vfs, @Nonnull ZipEntry zipEntry, @Nonnull String name) {
            super((BaseVFS<? extends InMemoryVDir, ? extends BaseVFile>)vfs, name);
            this.zipEntry = zipEntry;
        }

        @Nonnull
        public ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        @Override
        @Nonnull
        public VPath getPath() {
            return new VPath(this.zipEntry.getName(), '/');
        }
    }
}

