/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Transform JDynamicCastOperation to have only one target type")
@Name(value="IntersectionTypeRemover")
@Constraint(need={JDynamicCastOperation.class})
@Transform(add={JDynamicCastOperation.class}, remove={JCastOperation.WithIntersectionType.class})
@Filter(value={TypeWithoutPrebuiltFilter.class})
public class IntersectionTypeRemover
implements RunnableSchedulable<JMethod> {
    @Override
    public void run(@Nonnull JMethod method) {
        TransformationRequest request = new TransformationRequest(method);
        Visitor visitor = new Visitor(request);
        visitor.accept(method);
        request.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;

        public Visitor(@Nonnull TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public boolean visit(@Nonnull JDynamicCastOperation cast) {
            JExpression expr = cast.getExpr();
            if (cast.getTypes().size() > 1) {
                for (JType type : cast.getTypes()) {
                    expr = new JDynamicCastOperation(cast.getSourceInfo(), expr, type);
                }
                this.tr.append(new Replace(cast, expr));
            }
            return super.visit(cast);
        }
    }
}

