/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JLock;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JStatementList;
import com.android.jack.ir.ast.JSynchronizedBlock;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JUnlock;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.JNodeLookup;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.ReportableException;
import com.android.jack.reporting.Reporter;
import com.android.jack.transformations.BoostLockedRegionPriorityFeature;
import com.android.jack.transformations.request.AppendStatement;
import com.android.jack.transformations.request.PrependStatement;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.MethodNameCodec;
import com.android.jack.util.NamingTools;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Raise locked region priority for certain types of locks.")
@Constraint(need={JLock.class, JUnlock.class}, no={JSynchronizedBlock.class})
@Transform(add={JExpressionStatement.class, JMethodCall.class})
public class BoostLockedRegionPriority
implements RunnableSchedulable<JMethod> {
    @CheckForNull
    private final JClass lockClass;
    @CheckForNull
    private final JClass requestClass;
    @CheckForNull
    private final JClass resetClass;
    @CheckForNull
    private final JMethodIdWide requestMethodId;
    @CheckForNull
    private final JMethodIdWide resetMethodId;
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    public BoostLockedRegionPriority() {
        String className = ThreadConfig.get(BoostLockedRegionPriorityFeature.BOOST_LOCK_CLASSNAME);
        MethodNameCodec.MethodNameValue requestMethodNameValue = ThreadConfig.get(BoostLockedRegionPriorityFeature.BOOST_LOCK_REQUEST_METHOD);
        MethodNameCodec.MethodNameValue resetMethodNameValue = ThreadConfig.get(BoostLockedRegionPriorityFeature.BOOST_LOCK_RESET_METHOD);
        JNodeLookup lookup = Jack.getSession().getLookup();
        this.lockClass = BoostLockedRegionPriority.getClassOrReportFailure(lookup, NamingTools.getTypeSignatureName(className), BoostLockedRegionPriorityFeature.BOOST_LOCK_CLASSNAME.getName());
        this.requestClass = BoostLockedRegionPriority.getClassOrReportFailure(lookup, NamingTools.getTypeSignatureName(requestMethodNameValue.getClassName()), BoostLockedRegionPriorityFeature.BOOST_LOCK_REQUEST_METHOD.getName());
        this.resetClass = BoostLockedRegionPriority.getClassOrReportFailure(lookup, NamingTools.getTypeSignatureName(resetMethodNameValue.getClassName()), BoostLockedRegionPriorityFeature.BOOST_LOCK_RESET_METHOD.getName());
        this.requestMethodId = BoostLockedRegionPriority.getStaticMethodOrReportFailure(this.requestClass, requestMethodNameValue.getMethodName(), BoostLockedRegionPriorityFeature.BOOST_LOCK_REQUEST_METHOD.getName());
        this.resetMethodId = BoostLockedRegionPriority.getStaticMethodOrReportFailure(this.resetClass, resetMethodNameValue.getMethodName(), BoostLockedRegionPriorityFeature.BOOST_LOCK_RESET_METHOD.getName());
    }

    private static JClass getClassOrReportFailure(JNodeLookup lookup, String name, String prop) {
        try {
            return lookup.getClass(name);
        }
        catch (Throwable e) {
            Jack.getSession().getReporter().report(Reporter.Severity.FATAL, new BadBoostLockedRegionPriorityConfigurationException(prop, e));
            Jack.getSession().abortEventually();
            return null;
        }
    }

    private static JMethodIdWide getStaticMethodOrReportFailure(JClass cls, String name, String prop) {
        try {
            return cls.getMethodIdWide(name, Collections.emptyList(), MethodKind.STATIC);
        }
        catch (Throwable e) {
            Jack.getSession().getReporter().report(Reporter.Severity.FATAL, new BadBoostLockedRegionPriorityConfigurationException(prop, e));
            Jack.getSession().abortEventually();
            return null;
        }
    }

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        if (this.lockClass == null || this.requestClass == null || this.resetClass == null || this.requestMethodId == null || this.resetMethodId == null) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(method, tr);
        visitor.accept(method);
        tr.commit();
    }

    private static void abortPass() {
        Jack.getSession().getReporter().report(Reporter.Severity.FATAL, new BadBoostLockedRegionPriorityState());
        Jack.getSession().abortEventually();
    }

    private static class BadBoostLockedRegionPriorityState
    implements Reportable {
        private BadBoostLockedRegionPriorityState() {
        }

        @Override
        public String getMessage() {
            return "Cannot perform BoostLockedRegionPriority. This is likely due to a library coming from a Jar, which is not supported.";
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.ERROR;
        }
    }

    private static class BadBoostLockedRegionPriorityConfigurationException
    extends ReportableException {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final String prop;

        public BadBoostLockedRegionPriorityConfigurationException(@Nonnull String prop, @Nonnull Throwable cause) {
            super(cause);
            this.prop = prop;
        }

        @Override
        public String getMessage() {
            return this.getCause().getMessage() + " needed by property " + this.prop;
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.ERROR;
        }
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final JMethod method;
        @Nonnull
        private final TransformationRequest tr;

        public Visitor(@Nonnull JMethod method, TransformationRequest tr) {
            this.method = method;
            this.tr = tr;
        }

        @Override
        public void endVisit(@Nonnull JLock jLock) {
            JStatement next;
            assert (BoostLockedRegionPriority.this.lockClass != null);
            if (!jLock.getLockExpr().getType().isSameType(BoostLockedRegionPriority.this.lockClass)) {
                return;
            }
            JStatementList list = (JStatementList)jLock.getParent();
            int index = list.getStatements().indexOf(jLock) + 1;
            if (index >= list.getStatements().size()) {
                BoostLockedRegionPriority.abortPass();
            }
            if (!((next = list.getStatements().get(index)) instanceof JTryStatement)) {
                BoostLockedRegionPriority.abortPass();
                return;
            }
            JTryStatement jTry = (JTryStatement)next;
            JBlock finallyBlock = jTry.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            this.tr.append(new PrependStatement(jTry.getTryBlock(), this.makeRequestCall(jLock.getSourceInfo())));
            this.tr.append(new AppendStatement(finallyBlock, this.makeResetCall(jLock.getSourceInfo())));
        }

        @Nonnull
        private JExpressionStatement makeRequestCall(SourceInfo info) {
            assert (BoostLockedRegionPriority.this.lockClass != null && BoostLockedRegionPriority.this.requestClass != null && BoostLockedRegionPriority.this.requestMethodId != null);
            return new JExpressionStatement(info, new JMethodCall(info, null, BoostLockedRegionPriority.this.requestClass, BoostLockedRegionPriority.this.requestMethodId, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType(), false));
        }

        @Nonnull
        private JExpressionStatement makeResetCall(SourceInfo info) {
            assert (BoostLockedRegionPriority.this.lockClass != null && BoostLockedRegionPriority.this.resetClass != null && BoostLockedRegionPriority.this.resetMethodId != null);
            return new JExpressionStatement(info, new JMethodCall(info, null, BoostLockedRegionPriority.this.resetClass, BoostLockedRegionPriority.this.resetMethodId, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType(), false));
        }
    }
}

