/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.merger;

import com.android.jack.dx.dex.file.AnnotationItem;
import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.io.EncodedValueCodec;
import com.android.jack.dx.io.EncodedValueReader;
import com.android.jack.dx.io.FieldId;
import com.android.jack.dx.rop.annotation.Annotation;
import com.android.jack.dx.rop.annotation.AnnotationVisibility;
import com.android.jack.dx.rop.annotation.Annotations;
import com.android.jack.dx.rop.annotation.AnnotationsList;
import com.android.jack.dx.rop.annotation.NameValuePair;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstAnnotation;
import com.android.jack.dx.rop.cst.CstArray;
import com.android.jack.dx.rop.cst.CstBoolean;
import com.android.jack.dx.rop.cst.CstByte;
import com.android.jack.dx.rop.cst.CstChar;
import com.android.jack.dx.rop.cst.CstDouble;
import com.android.jack.dx.rop.cst.CstEnumRef;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstFloat;
import com.android.jack.dx.rop.cst.CstIndexMap;
import com.android.jack.dx.rop.cst.CstInteger;
import com.android.jack.dx.rop.cst.CstKnownNull;
import com.android.jack.dx.rop.cst.CstLong;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstNat;
import com.android.jack.dx.rop.cst.CstShort;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.CstType;
import com.android.jack.dx.util.ByteInput;
import com.android.jack.dx.util.Leb128Utils;
import com.android.jack.tools.merger.MergerTools;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class AnnotationMerger
extends MergerTools {
    @CheckForNull
    private CstIndexMap cstIndexMap;

    public void mergeAnnotationDirectory(@Nonnull DexBuffer dex, @Nonnegative int annotationDirectoryOffset, @Nonnull ClassDefItem newClassDef, @Nonnull CstIndexMap cstIndexMap) {
        CstMethodRef cstMethodRef;
        int i;
        this.cstIndexMap = cstIndexMap;
        DexBuffer.Section directoryIn = dex.open(annotationDirectoryOffset);
        int classAnnotationSetOffset = directoryIn.readInt();
        if (classAnnotationSetOffset != 0) {
            newClassDef.setClassAnnotations(this.readAnnotationSet(dex, classAnnotationSetOffset));
        }
        int fieldsSize = directoryIn.readInt();
        int methodsSize = directoryIn.readInt();
        int parameterListSize = directoryIn.readInt();
        for (i = 0; i < fieldsSize; ++i) {
            CstFieldRef cstFieldRef = cstIndexMap.getCstFieldRef(directoryIn.readInt());
            newClassDef.addFieldAnnotations(cstFieldRef, this.readAnnotationSet(dex, directoryIn.readInt()));
        }
        for (i = 0; i < methodsSize; ++i) {
            cstMethodRef = cstIndexMap.getCstMethodRef(directoryIn.readInt());
            newClassDef.addMethodAnnotations(cstMethodRef, this.readAnnotationSet(dex, directoryIn.readInt()));
        }
        for (i = 0; i < parameterListSize; ++i) {
            cstMethodRef = cstIndexMap.getCstMethodRef(directoryIn.readInt());
            newClassDef.addParameterAnnotations(cstMethodRef, this.readAnnotationSetRefList(dex, directoryIn.readInt()));
        }
    }

    @Nonnull
    private AnnotationsList readAnnotationSetRefList(@Nonnull DexBuffer dex, @Nonnegative int annotationSetRefListOffset) {
        DexBuffer.Section annotationSetRefListIn = dex.open(annotationSetRefListOffset);
        int parameterCount = annotationSetRefListIn.readInt();
        AnnotationsList parameterAnnotationList = new AnnotationsList(parameterCount);
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            Annotations annotations = this.readAnnotationSet(dex, annotationSetRefListIn.readInt());
            annotations.setImmutable();
            parameterAnnotationList.set(paramIdx, annotations);
        }
        return parameterAnnotationList;
    }

    @Nonnull
    private Annotations readAnnotationSet(@Nonnull DexBuffer dex, @Nonnegative int annotationSetOffset) {
        DexBuffer.Section annotationSetIn = dex.open(annotationSetOffset);
        int size = annotationSetIn.readInt();
        Annotations annotations = new Annotations();
        for (int j = 0; j < size; ++j) {
            annotations.add(this.readAnnotationItem(dex, annotationSetIn.readInt()));
        }
        return annotations;
    }

    @Nonnull
    private Annotation readAnnotationItem(@Nonnull DexBuffer dex, @Nonnegative int annotationItemOffset) {
        DexBuffer.Section annotationItemIn = dex.open(annotationItemOffset);
        com.android.jack.dx.io.Annotation ioAnnotation = annotationItemIn.readAnnotation();
        assert (this.cstIndexMap != null);
        CstType annotationType = this.cstIndexMap.getCstType(ioAnnotation.getTypeIndex());
        Annotation a = new Annotation(annotationType, AnnotationItem.getAnnotationVisibility(ioAnnotation.getVisibility()));
        for (int i = 0; i < ioAnnotation.getValues().length; ++i) {
            AnnotationValueReader avr = new AnnotationValueReader(dex, ioAnnotation.getValues()[i].asByteInput());
            avr.readValue();
            assert (this.cstIndexMap != null);
            a.add(new NameValuePair(this.cstIndexMap.getCstString(ioAnnotation.getNames()[i]), avr.getCstValue()));
        }
        return a;
    }

    private final class AnnotationValueReader
    extends EncodedValueReader {
        @CheckForNull
        private Constant constantValue;
        @Nonnull
        private final DexBuffer dex;

        public AnnotationValueReader(@Nonnull DexBuffer dex, ByteInput in) {
            super(in);
            this.dex = dex;
        }

        @Nonnull
        public Constant getCstValue() {
            assert (this.constantValue != null);
            return this.constantValue;
        }

        @Override
        protected void visitEncodedBoolean(int argAndType) {
            int arg = (argAndType & 0xE0) >> 5;
            this.constantValue = CstBoolean.make(arg);
        }

        @Override
        protected void visitString(int type, int index) {
            assert (AnnotationMerger.this.cstIndexMap != null);
            this.constantValue = AnnotationMerger.this.cstIndexMap.getCstString(index);
        }

        @Override
        protected void visitEncodedNull(int argAndType) {
            this.constantValue = CstKnownNull.THE_ONE;
        }

        @Override
        public final void readAnnotation() {
            int typeIndex = Leb128Utils.readUnsignedLeb128(this.in);
            int size = Leb128Utils.readUnsignedLeb128(this.in);
            assert (AnnotationMerger.this.cstIndexMap != null);
            Annotation embeddedAnnotation = new Annotation(AnnotationMerger.this.cstIndexMap.getCstType(typeIndex), AnnotationVisibility.EMBEDDED);
            for (int i = 0; i < size; ++i) {
                assert (AnnotationMerger.this.cstIndexMap != null);
                CstString pairName = AnnotationMerger.this.cstIndexMap.getCstString(Leb128Utils.readUnsignedLeb128(this.in));
                this.readValue();
                embeddedAnnotation.add(new NameValuePair(pairName, this.constantValue));
                this.constantValue = null;
            }
            embeddedAnnotation.setImmutable();
            this.constantValue = new CstAnnotation(embeddedAnnotation);
        }

        @Override
        protected void visitAnnotation(int typeIndex, int size) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitAnnotationName(int nameIndex) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitAnnotationValue(int argAndType) {
        }

        @Override
        public void readArray() {
            int size = Leb128Utils.readUnsignedLeb128(this.in);
            CstArray.List constants = new CstArray.List(size);
            for (int i = 0; i < size; ++i) {
                this.readValue();
                constants.set(i, this.constantValue);
                this.constantValue = null;
            }
            constants.setImmutable();
            this.constantValue = new CstArray(constants);
        }

        @Override
        protected void visitArrayValue(int argAndType) {
        }

        @Override
        protected void visitField(int type, int index) {
            assert (AnnotationMerger.this.cstIndexMap != null);
            if (type == 25) {
                this.constantValue = AnnotationMerger.this.cstIndexMap.getCstFieldRef(index);
            } else {
                assert (type == 27);
                FieldId fieldId = this.dex.fieldIds().get(index);
                CstNat fieldNat = new CstNat(AnnotationMerger.this.cstIndexMap.getCstString(fieldId.getNameIndex()), new CstString(this.dex.typeNames().get(fieldId.getTypeIndex())));
                this.constantValue = new CstEnumRef(fieldNat);
            }
        }

        @Override
        protected void visitMethod(int type, int index) {
            assert (AnnotationMerger.this.cstIndexMap != null);
            this.constantValue = AnnotationMerger.this.cstIndexMap.getCstMethodRef(index);
        }

        @Override
        protected void visitType(int type, int index) {
            assert (AnnotationMerger.this.cstIndexMap != null);
            this.constantValue = AnnotationMerger.this.cstIndexMap.getCstType(index);
        }

        @Override
        protected void visitPrimitive(int argAndType, int type, int arg, int size) {
            switch (type) {
                case 0: {
                    this.constantValue = CstByte.make((byte)EncodedValueCodec.readSignedInt(this.in, arg));
                    break;
                }
                case 3: {
                    this.constantValue = CstChar.make((char)EncodedValueCodec.readUnsignedInt(this.in, arg, false));
                    break;
                }
                case 2: {
                    this.constantValue = CstShort.make((short)EncodedValueCodec.readSignedInt(this.in, arg));
                    break;
                }
                case 4: {
                    this.constantValue = CstInteger.make(EncodedValueCodec.readSignedInt(this.in, arg));
                    break;
                }
                case 6: {
                    this.constantValue = CstLong.make(EncodedValueCodec.readSignedLong(this.in, arg));
                    break;
                }
                case 16: {
                    this.constantValue = CstFloat.make(EncodedValueCodec.readUnsignedInt(this.in, arg, true));
                    break;
                }
                case 17: {
                    this.constantValue = CstDouble.make(EncodedValueCodec.readUnsignedLong(this.in, arg, true));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }
}

