/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.spec;

import com.android.jack.ir.ast.HasModifier;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.shrob.spec.Specification;
import java.util.Collections;
import java.util.EnumSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ModifierSpecification
implements Specification<HasModifier> {
    @Nonnull
    private static final EnumSet<Modifier> TYPE_MODIFIERS = EnumSet.of(Modifier.STATIC, new Modifier[]{Modifier.FINAL, Modifier.ENUM, Modifier.SYNTHETIC, Modifier.ABSTRACT, Modifier.INTERFACE, Modifier.ANNOTATION, Modifier.SUPER, Modifier.STRICTFP});
    @Nonnull
    private static final EnumSet<Modifier> FIELD_MODIFIERS = EnumSet.of(Modifier.STATIC, new Modifier[]{Modifier.FINAL, Modifier.TRANSIENT, Modifier.VOLATILE, Modifier.ENUM, Modifier.SYNTHETIC});
    @Nonnull
    private static final EnumSet<Modifier> METHOD_MODIFIERS = EnumSet.of(Modifier.STATIC, new Modifier[]{Modifier.NATIVE, Modifier.ABSTRACT, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.BRIDGE, Modifier.SYNTHETIC, Modifier.STRICTFP, Modifier.VARARGS});
    @Nonnull
    private final EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    @Nonnull
    private final EnumSet<Modifier> modifiersWithNegator = EnumSet.noneOf(Modifier.class);
    @Nonnull
    private final EnumSet<AccessFlags> accessFlags = EnumSet.noneOf(AccessFlags.class);
    @Nonnull
    private final EnumSet<AccessFlags> accessFlagsWithNegator = EnumSet.noneOf(AccessFlags.class);

    public void addModifier(Modifier modifier, boolean hasNegator) {
        if (hasNegator) {
            this.modifiersWithNegator.add(modifier);
        } else {
            this.modifiers.add(modifier);
        }
    }

    public void addAccessFlag(AccessFlags accessFlag, boolean hasNegator) {
        if (hasNegator) {
            this.accessFlagsWithNegator.add(accessFlag);
        } else {
            this.accessFlags.add(accessFlag);
        }
    }

    @Nonnull
    private static EnumSet<Modifier> convertJModifier(HasModifier hasModifier) {
        EnumSet<Modifier> listOfModifiers;
        if (hasModifier instanceof JClassOrInterface) {
            listOfModifiers = TYPE_MODIFIERS;
        } else if (hasModifier instanceof JField) {
            listOfModifiers = FIELD_MODIFIERS;
        } else if (hasModifier instanceof JMethod) {
            listOfModifiers = METHOD_MODIFIERS;
        } else {
            throw new AssertionError();
        }
        int toConvert = hasModifier.getModifier();
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        for (Modifier currentModifier : listOfModifiers) {
            if ((currentModifier.value & toConvert) == 0) continue;
            modifiers.add(currentModifier);
        }
        return modifiers;
    }

    @CheckForNull
    private static AccessFlags getAccessFlags(HasModifier hasModifier) {
        int toConvert = hasModifier.getModifier();
        for (AccessFlags accFlags : AccessFlags.values()) {
            if ((accFlags.value & toConvert) == 0) continue;
            return accFlags;
        }
        return null;
    }

    @Override
    public boolean matches(@Nonnull HasModifier candidate) {
        AccessFlags candidateAccFlags = ModifierSpecification.getAccessFlags(candidate);
        if (!this.accessFlags.isEmpty() && !this.accessFlags.contains((Object)candidateAccFlags)) {
            return false;
        }
        if (this.accessFlagsWithNegator.contains((Object)candidateAccFlags)) {
            return false;
        }
        EnumSet<Modifier> candidateModifiers = ModifierSpecification.convertJModifier(candidate);
        if (!candidateModifiers.containsAll(this.modifiers)) {
            return false;
        }
        return Collections.disjoint(candidateModifiers, this.modifiersWithNegator);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AccessFlags accessFlag : this.accessFlags) {
            sb.append(accessFlag.name);
            sb.append(' ');
        }
        for (AccessFlags accessFlag : this.accessFlagsWithNegator) {
            sb.append('!');
            sb.append(accessFlag.name);
            sb.append(' ');
        }
        for (Modifier modifier : this.modifiers) {
            sb.append(modifier.name);
            sb.append(' ');
        }
        for (Modifier modifier : this.modifiersWithNegator) {
            sb.append('!');
            sb.append(modifier.name);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static enum Modifier {
        STATIC("static", 8),
        FINAL("final", 16),
        SUPER("super", 32),
        SYNCHRONIZED("synchronized", 32),
        VOLATILE("volatile", 64),
        BRIDGE("bridge", 64),
        TRANSIENT("transient", 128),
        VARARGS("varargs", 128),
        NATIVE("native", 256),
        INTERFACE("interface", 512),
        ABSTRACT("abstract", 1024),
        STRICTFP("strictfp", 2048),
        SYNTHETIC("synthetic", 4096),
        ANNOTATION("annotation", 8192),
        ENUM("enum", 16384);

        private final int value;
        private final String name;

        private Modifier(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }

    public static enum AccessFlags {
        PUBLIC("public", 1),
        PRIVATE("private", 2),
        PROTECTED("protected", 4);

        private final int value;
        private final String name;

        private AccessFlags(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }
}

