/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.spec;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.shrob.proguard.GrammarActions;
import com.android.jack.shrob.spec.AnnotationSpecification;
import com.android.jack.shrob.spec.ClassTypeSpecification;
import com.android.jack.shrob.spec.FieldSpecification;
import com.android.jack.shrob.spec.InheritanceSpecification;
import com.android.jack.shrob.spec.KeepModifier;
import com.android.jack.shrob.spec.MethodSpecification;
import com.android.jack.shrob.spec.ModifierSpecification;
import com.android.jack.shrob.spec.NameSpecification;
import com.android.jack.shrob.spec.Specification;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ClassSpecification
implements Specification<JDefinedClassOrInterface> {
    @Nonnull
    private KeepModifier keepModifier;
    @CheckForNull
    private AnnotationSpecification annotationType;
    @CheckForNull
    private ModifierSpecification modifier;
    @Nonnull
    private final ClassTypeSpecification classType;
    @Nonnull
    private final NameSpecification name;
    @CheckForNull
    private InheritanceSpecification inheritance;
    @Nonnull
    private final List<FieldSpecification> fieldSpecs = new ArrayList<FieldSpecification>();
    @Nonnull
    private final List<MethodSpecification> methodSpecs = new ArrayList<MethodSpecification>();

    public ClassSpecification(@Nonnull NameSpecification name, @Nonnull ClassTypeSpecification classType, @CheckForNull AnnotationSpecification annotation) {
        this.name = name;
        this.classType = classType;
        this.annotationType = annotation;
        this.keepModifier = new KeepModifier();
    }

    @Nonnull
    public List<FieldSpecification> getFieldSpecs() {
        return this.fieldSpecs;
    }

    @Nonnull
    public List<MethodSpecification> getMethodSpecs() {
        return this.methodSpecs;
    }

    public void setAnnotationType(@CheckForNull AnnotationSpecification annotationType) {
        this.annotationType = annotationType;
    }

    public void setKeepModifier(@Nonnull KeepModifier keepModifier) {
        this.keepModifier = keepModifier;
    }

    @Nonnull
    public KeepModifier getKeepModifier() {
        return this.keepModifier;
    }

    @Override
    public boolean matches(@Nonnull JDefinedClassOrInterface type) {
        if (this.annotationType != null && !this.annotationType.matches(type.getAnnotations())) {
            return false;
        }
        if (this.modifier != null && !this.modifier.matches(type)) {
            return false;
        }
        if (!this.classType.matches(type)) {
            return false;
        }
        if (!this.name.matches(GrammarActions.getSourceFormatter().getName(type))) {
            return false;
        }
        return this.inheritance == null || this.inheritance.matches(type);
    }

    public void setModifier(@CheckForNull ModifierSpecification modifier) {
        this.modifier = modifier;
    }

    @CheckForNull
    public ModifierSpecification getModifier() {
        return this.modifier;
    }

    public void add(@Nonnull MethodSpecification methodSpecification) {
        this.methodSpecs.add(methodSpecification);
    }

    public void add(@Nonnull FieldSpecification fieldSpecification) {
        this.fieldSpecs.add(fieldSpecification);
    }

    public void setInheritance(@CheckForNull InheritanceSpecification inheritanceSpec) {
        this.inheritance = inheritanceSpec;
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.annotationType != null) {
            sb.append(this.annotationType);
            sb.append(' ');
        }
        if (this.modifier != null) {
            sb.append(this.modifier);
            sb.append(' ');
        }
        sb.append(this.classType);
        sb.append(' ');
        sb.append(this.name);
        if (this.inheritance != null) {
            sb.append(' ');
            sb.append(this.inheritance.toString());
        }
        sb.append("\n{\n");
        for (FieldSpecification fieldSpec : this.fieldSpecs) {
            sb.append(fieldSpec);
            sb.append('\n');
        }
        for (MethodSpecification methodSpec : this.methodSpecs) {
            sb.append(methodSpec);
            sb.append('\n');
        }
        sb.append("}");
        return sb.toString();
    }
}

