/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.shrink;

import com.android.jack.Jack;
import com.android.jack.google.common.base.Function;
import com.android.jack.google.common.base.Joiner;
import com.android.jack.google.common.collect.Iterables;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JPhantomClassOrInterface;
import com.android.jack.reporting.Reportable;
import com.android.sched.item.Description;
import com.android.sched.marker.DynamicValidOn;
import com.android.sched.marker.Marker;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Indicates that the type hierarchy is partial.")
public class PartialTypeHierarchy
implements Marker,
Reportable {
    @Nonnull
    private static final Joiner typeNameJoiner = Joiner.on(", ");
    @Nonnull
    private final List<JPhantomClassOrInterface> unknownTypes;
    @Nonnull
    private final JDefinedClassOrInterface definedType;

    public PartialTypeHierarchy(@Nonnull JDefinedClassOrInterface definedType, @Nonnull List<JPhantomClassOrInterface> unknownTypes) {
        this.definedType = definedType;
        this.unknownTypes = unknownTypes;
    }

    @DynamicValidOn
    public boolean isValidOn(@Nonnull JDefinedClassOrInterface type) {
        return type.isToEmit();
    }

    @Override
    public Marker cloneIfNeeded() {
        return this;
    }

    @Override
    @Nonnull
    public String getMessage() {
        return "Shrinking: force to keep members of '" + Jack.getUserFriendlyFormatter().getName(this.definedType) + "' due to unknown referenced types " + typeNameJoiner.join(Iterables.transform(this.unknownTypes, new Function<JPhantomClassOrInterface, String>(){

            @Override
            public String apply(JPhantomClassOrInterface arg0) {
                return Jack.getUserFriendlyFormatter().getName(arg0);
            }
        }));
    }

    @Override
    @Nonnull
    public Reportable.ProblemLevel getDefaultProblemLevel() {
        return Reportable.ProblemLevel.WARNING;
    }
}

