/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.resource;

import com.android.jack.Options;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JPackageLookupException;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.Resource;
import com.android.jack.ir.naming.CompositeName;
import com.android.jack.ir.naming.PackageName;
import com.android.jack.ir.naming.TypeName;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.shrob.spec.FilterSpecification;
import com.android.jack.shrob.spec.Flags;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.vfs.VPath;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Refines resource names when necessary")
@Constraint(need={OriginalNames.class})
public class ResourceRefiner
implements RunnableSchedulable<JSession> {
    @Nonnull
    private final Flags flags = ThreadConfig.get(Options.FLAGS);
    private static final char BINARY_QN_SEPARATOR = '/';

    @CheckForNull
    private CharSequence getResourceRefinedName(@Nonnull VPath resPath, @Nonnull JPackage topLevelPackage) {
        JPackage currentPackage = topLevelPackage;
        Iterator<String> iterator = resPath.split().iterator();
        String name = null;
        while (iterator.hasNext()) {
            name = iterator.next();
            if (iterator.hasNext()) {
                try {
                    currentPackage = currentPackage.getSubPackage(name);
                    continue;
                }
                catch (JPackageLookupException e) {
                    break;
                }
            }
            int index = name.indexOf(46);
            if (index == -1) continue;
            String typeName = name.substring(0, index);
            String extension = name.substring(index);
            try {
                JDefinedClassOrInterface type = currentPackage.getType(typeName);
                CompositeName refinedName = new CompositeName(new TypeName(TypeName.Kind.BINARY_QN, type), extension);
                return refinedName;
            }
            catch (JTypeLookupException jTypeLookupException) {
            }
        }
        if (currentPackage == topLevelPackage) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        assert (name != null);
        sb.append(name);
        while (iterator.hasNext()) {
            sb.append('/');
            sb.append(iterator.next());
        }
        CompositeName refinedName = new CompositeName(new PackageName(PackageName.Kind.BINARY_QN, currentPackage), sb.toString());
        return refinedName;
    }

    @Override
    public void run(@Nonnull JSession session) {
        List<FilterSpecification> adaptResourceFileNames = this.flags.getAdaptResourceFileNames();
        if (!adaptResourceFileNames.isEmpty()) {
            for (Resource res : session.getResources()) {
                CharSequence refinedName;
                VPath resName = res.getPath();
                if (!Flags.matches(adaptResourceFileNames, resName.getPathAsString('/')) || (refinedName = this.getResourceRefinedName(resName, session.getTopLevelPackage())) == null) continue;
                VPath vPath = new VPath(refinedName, '/');
                assert (vPath.equals(resName));
                res.setPath(vPath);
            }
        }
    }
}

