/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.google.common.collect.Iterators;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JPhantomClassOrInterface;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;

@ValidOn(value={JDefinedClassOrInterface.class, JPhantomClassOrInterface.class})
@Description(value="Contains all the subclasses and subinterfaces of a type.")
public class SubClassOrInterfaceMarker
implements Marker,
Iterable<JDefinedClassOrInterface> {
    @Nonnull
    private final Set<JDefinedClass> subClasses = new HashSet<JDefinedClass>();
    @Nonnull
    private final Set<JDefinedInterface> subInterfaces = new HashSet<JDefinedInterface>();

    public synchronized void addSubClass(@Nonnull JDefinedClass subClass) {
        this.subClasses.add(subClass);
    }

    public synchronized void addSubInterface(@Nonnull JDefinedInterface subInterface) {
        this.subInterfaces.add(subInterface);
    }

    @Nonnull
    public Set<JDefinedClass> getSubClasses() {
        return this.subClasses;
    }

    @Nonnull
    public Set<JDefinedInterface> getSubInterfaces() {
        return this.subInterfaces;
    }

    @Override
    public Marker cloneIfNeeded() {
        return this;
    }

    @Override
    public Iterator<JDefinedClassOrInterface> iterator() {
        return Iterators.concat(this.subClasses.iterator(), this.subInterfaces.iterator());
    }

    public void addSubClassOrInterface(@Nonnull JDefinedClassOrInterface type) {
        if (type instanceof JDefinedClass) {
            this.addSubClass((JDefinedClass)type);
        } else {
            this.addSubInterface((JDefinedInterface)type);
        }
    }
}

