/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.wofr;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.optimizations.wofr.FieldReadWriteCountsMarker;
import com.android.jack.optimizations.wofr.WofrSchedulable;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import javax.annotation.Nonnull;

@Description(value="Write-only field removal, fields removal")
@Constraint(need={FieldReadWriteCountsMarker.class})
@Transform(modify={JField.class}, remove={FieldReadWriteCountsMarker.class})
@ExclusiveAccess(value=JDefinedClassOrInterface.class)
@Synchronized
@Name(value="WriteOnlyFieldRemoval: RemoveFields")
public class WofrRemoveFields
extends WofrSchedulable
implements RunnableSchedulable<JField> {
    private final boolean removeUnusedFields = ThreadConfig.get(Optimizations.WriteOnlyFieldRemoval.REMOVE_UNUSED_FIELDS);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public synchronized void run(@Nonnull JField field) {
        if (this.removeUnusedFields && !FieldReadWriteCountsMarker.hasReads(field) && !FieldReadWriteCountsMarker.hasWrites(field) && field.getAnnotations(this.disablingAnnotationType).isEmpty() && field.getEnclosingType().getAnnotations(this.disablingAnnotationType).isEmpty()) {
            TransformationRequest request = new TransformationRequest(field);
            request.append(new Remove(field));
            request.commit();
            ((Counter)this.tracer.getStatistic(FIELDS_REMOVED)).incValue();
        }
        field.removeMarker(FieldReadWriteCountsMarker.class);
    }
}

