/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.modifiers;

import com.android.jack.Jack;
import com.android.jack.annotations.DisableMethodFinalizerOptimization;
import com.android.jack.google.common.collect.Maps;
import com.android.jack.google.common.collect.Sets;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.optimizations.common.DirectlyDerivedClassesMarker;
import com.android.jack.optimizations.modifiers.EffectivelyFinalMethodMarker;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@Description(value="Tighten 'final' modifiers on methods.")
@Constraint(need={DirectlyDerivedClassesMarker.class})
@Support(value={Optimizations.MethodFinalizer.class})
@Transform(add={EffectivelyFinalMethodMarker.class})
public class MethodFinalizer
implements RunnableSchedulable<JDefinedClassOrInterface> {
    private final boolean addFinalModifier = ThreadConfig.get(Optimizations.MethodFinalizer.ADD_FINAL_MODIFIER);
    @Nonnull
    public static final StatisticId<Counter> METHODS_FINALIZED = new StatisticId<Counter>("jack.optimization.method-finalizer", "Methods made final", CounterImpl.class, Counter.class);
    @Nonnull
    private final JAnnotationType disablingAnnotationType = Jack.getSession().getPhantomLookup().getAnnotationType(NamingTools.getTypeSignatureName(DisableMethodFinalizerOptimization.class.getName()));
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final TypePackageAndMethodFormatter formatter = Jack.getLookupFormatter();

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        JClass superClass = type.getSuperClass();
        if (!(type instanceof JDefinedClass) || superClass == null || superClass.isToEmit()) {
            return;
        }
        State state = new State();
        this.trackOverridingChains((JDefinedClass)type, state);
        for (JMethod method : state.effectivelyFinalMethods) {
            if (method.isAbstract() || method.isFinal()) continue;
            assert (!(method.isStatic() || method.isPrivate() || method instanceof JConstructor));
            EffectivelyFinalMethodMarker.markAsEffectivelyFinal(method);
            if (!this.addFinalModifier || !method.getAnnotations(this.disablingAnnotationType).isEmpty() || !method.getEnclosingType().getAnnotations(this.disablingAnnotationType).isEmpty()) continue;
            method.setFinal();
            this.tracer.getStatistic(METHODS_FINALIZED).incValue();
        }
    }

    private void trackOverridingChains(@Nonnull JDefinedClass currentClass, @Nonnull State state) {
        String signature;
        for (JMethod method : currentClass.getMethods()) {
            if (method.getMethodIdWide().getKind() != MethodKind.INSTANCE_VIRTUAL) continue;
            signature = this.getSignatureId(method);
            if (!state.currentMethods.containsKey(signature)) {
                state.newMethods.add(method);
            }
            state.currentMethods.put(signature, method);
        }
        for (JDefinedClass derived : DirectlyDerivedClassesMarker.getDirectlyDerivedClasses(currentClass)) {
            this.trackOverridingChains(derived, state);
        }
        for (JMethod method : currentClass.getMethods()) {
            if (method.getMethodIdWide().getKind() != MethodKind.INSTANCE_VIRTUAL) continue;
            signature = this.getSignatureId(method);
            assert (state.currentMethods.containsKey(signature));
            JMethod candidate = state.currentMethods.get(signature);
            if (candidate != null) {
                assert (candidate == method);
                state.effectivelyFinalMethods.add(method);
            }
            if (state.newMethods.contains(method)) {
                state.currentMethods.remove(signature);
                continue;
            }
            state.currentMethods.put(signature, null);
        }
    }

    @Nonnull
    private String getSignatureId(@Nonnull JMethod method) {
        return this.formatter.getName(method);
    }

    private static class State {
        @Nonnull
        final Map<String, JMethod> currentMethods = Maps.newHashMap();
        @Nonnull
        final Set<JMethod> newMethods = Sets.newIdentityHashSet();
        @Nonnull
        final Set<JMethod> effectivelyFinalMethods = Sets.newIdentityHashSet();

        private State() {
        }
    }
}

