/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JCharLiteral;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NLiteral;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NCharLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.CHAR_LITERAL;
    public char value;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JCharLiteral jCharLiteral = (JCharLiteral)node;
        this.value = jCharLiteral.getValue();
        this.sourceInfo = loader.load(jCharLiteral.getSourceInfo());
    }

    @Override
    @Nonnull
    public JCharLiteral exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JCharLiteral jCharLiteral = new JCharLiteral(jSourceInfo, this.value);
        return jCharLiteral;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeChar(this.value);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.value = in.readChar();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

