/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.StringInterner;
import com.android.jack.ir.ast.CanBeRenamed;
import com.android.jack.ir.ast.HasEnclosingPackage;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JEnum;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPackageLookupException;
import com.android.jack.ir.ast.JPhantomAnnotationType;
import com.android.jack.ir.ast.JPhantomClass;
import com.android.jack.ir.ast.JPhantomClassOrInterface;
import com.android.jack.ir.ast.JPhantomEnum;
import com.android.jack.ir.ast.JPhantomInterface;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MissingJTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.PackageLoader;
import com.android.jack.lookup.JLookupException;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Represents a Java package")
public class JPackage
extends JNode
implements HasName,
CanBeRenamed,
HasEnclosingPackage {
    @Nonnull
    public static final StatisticId<Counter> PACKAGE_CREATION = new StatisticId<Counter>("jack.package.create", "Created JPackage", CounterImpl.class, Counter.class);
    @Nonnull
    public static final StatisticId<Counter> PHANTOM_CREATION = new StatisticId<Counter>("jack.phantom.create", "Created phantom class or interface", CounterImpl.class, Counter.class);
    @CheckForNull
    private JPackage enclosingPackage;
    @Nonnull
    private final ArrayList<JPackage> subPackages = new ArrayList();
    @Nonnull
    private final ArrayList<JDefinedClassOrInterface> declaredTypes = new ArrayList();
    @Nonnull
    private final List<JPhantomClassOrInterface> phantomTypes = new ArrayList<JPhantomClassOrInterface>();
    @Nonnull
    private final List<JPhantomClass> phantomClasses = new ArrayList<JPhantomClass>();
    @Nonnull
    private final List<JPhantomEnum> phantomEnums = new ArrayList<JPhantomEnum>();
    @Nonnull
    private final List<JPhantomInterface> phantomInterfaces = new ArrayList<JPhantomInterface>();
    @Nonnull
    private final List<JPhantomAnnotationType> phantomAnnotations = new ArrayList<JPhantomAnnotationType>();
    @Nonnull
    private final Set<String> deletedItems = new HashSet<String>();
    @Nonnull
    private String name;
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final List<PackageLoader> loaders = new LinkedList<PackageLoader>();
    private OnPath isOnPath = OnPath.NOT_YET_AVAILABLE;

    public JPackage(@Nonnull String name, @CheckForNull JPackage enclosingPackage) {
        this(name, enclosingPackage, Collections.emptyList());
    }

    public JPackage(@Nonnull String name, @CheckForNull JPackage enclosingPackage, @Nonnull List<PackageLoader> loaders) {
        super(SourceInfo.UNKNOWN);
        this.name = StringInterner.get().intern(name);
        this.loaders.addAll(loaders);
        if (enclosingPackage != null) {
            assert (!name.isEmpty());
            this.enclosingPackage = enclosingPackage;
            this.enclosingPackage.addPackage(this);
        }
        this.tracer.getStatistic(PACKAGE_CREATION).incValue();
    }

    public void addType(@Nonnull JDefinedClassOrInterface type) {
        this.addItemWithName(type);
        this.declaredTypes.add(type);
    }

    public void addPackage(@Nonnull JPackage newPackage) {
        this.addItemWithName(newPackage);
        this.subPackages.add(newPackage);
    }

    public void add(@Nonnull HasEnclosingPackage node) {
        this.addItemWithName((HasName)((Object)node));
        if (node instanceof JDefinedClassOrInterface) {
            this.addType((JDefinedClassOrInterface)node);
        } else if (node instanceof JPackage) {
            this.addPackage((JPackage)node);
        } else if (node instanceof JPhantomEnum) {
            this.phantomEnums.add((JPhantomEnum)node);
        } else if (node instanceof JPhantomAnnotationType) {
            this.phantomAnnotations.add((JPhantomAnnotationType)node);
        } else if (node instanceof JPhantomClass) {
            this.phantomClasses.add((JPhantomClass)node);
        } else if (node instanceof JPhantomInterface) {
            this.phantomInterfaces.add((JPhantomInterface)node);
        } else if (node instanceof JPhantomClassOrInterface) {
            this.phantomTypes.add((JPhantomClassOrInterface)node);
        } else {
            throw new AssertionError((Object)"Not supported");
        }
    }

    @Nonnull
    public List<JPackage> getSubPackages() {
        this.loadSubPackages();
        return this.subPackages;
    }

    @Nonnull
    public List<JDefinedClassOrInterface> getTypes() {
        this.loadClassesAndInterfaces();
        return this.declaredTypes;
    }

    @Override
    @CheckForNull
    public JPackage getEnclosingPackage() {
        return this.enclosingPackage;
    }

    @Override
    public void setEnclosingPackage(@CheckForNull JPackage enclosingPackage) {
        this.enclosingPackage = enclosingPackage;
    }

    public boolean isTopLevelPackage() {
        return this.enclosingPackage == null;
    }

    @Nonnull
    public synchronized JPackage getSubPackage(@Nonnull String packageName) throws JPackageLookupException {
        for (JPackage f : this.subPackages) {
            if (!f.name.equals(packageName)) continue;
            return f;
        }
        return this.loadSubPackage(packageName);
    }

    @Nonnull
    public synchronized JPackage getOrCreateSubPackage(@Nonnull String packageName) {
        try {
            return this.getSubPackage(packageName);
        }
        catch (JPackageLookupException e) {
            assert (!packageName.isEmpty());
            JPackage newPackage = new JPackage(packageName, this);
            newPackage.updateParents(this);
            return newPackage;
        }
    }

    @Nonnull
    public synchronized JDefinedClassOrInterface getType(@Nonnull String typeName) throws JTypeLookupException {
        for (JDefinedClassOrInterface type : this.declaredTypes) {
            if (!type.getName().equals(typeName)) continue;
            return type;
        }
        return this.loadClassOrInterface(typeName);
    }

    public void setOnPath() {
        this.isOnPath = OnPath.TRUE;
    }

    public boolean isOnPath() {
        if (this.isOnPath == OnPath.NOT_YET_AVAILABLE) {
            this.isOnPath = OnPath.FALSE;
            for (PackageLoader loader : this.loaders) {
                if (!loader.isOnPath(this)) continue;
                this.isOnPath = OnPath.TRUE;
                break;
            }
        }
        return this.isOnPath == OnPath.TRUE;
    }

    @Nonnull
    public synchronized JClassOrInterface getPhantomClassOrInterface(@Nonnull String typeName) {
        try {
            return this.getType(typeName);
        }
        catch (JLookupException e) {
            for (JPhantomClassOrInterface f : this.phantomTypes) {
                if (!f.name.equals(typeName)) continue;
                return f;
            }
            JPhantomClassOrInterface phantom = new JPhantomClassOrInterface(typeName, this);
            this.phantomTypes.add(phantom);
            this.tracer.getStatistic(PHANTOM_CREATION).incValue();
            return phantom;
        }
    }

    @Nonnull
    public synchronized JClass getPhantomClass(@Nonnull String typeName) {
        try {
            JDefinedClassOrInterface defined = this.getType(typeName);
            if (defined instanceof JClass) {
                return (JClass)((Object)defined);
            }
        }
        catch (JLookupException defined) {
            // empty catch block
        }
        for (JPhantomClass f : this.phantomClasses) {
            if (!f.name.equals(typeName)) continue;
            return f;
        }
        JPhantomClass phantom = new JPhantomClass(typeName, this);
        this.phantomClasses.add(phantom);
        this.tracer.getStatistic(PHANTOM_CREATION).incValue();
        return phantom;
    }

    @Nonnull
    public synchronized JEnum getPhantomEnum(@Nonnull String typeName) {
        try {
            JDefinedClassOrInterface defined = this.getType(typeName);
            if (defined instanceof JEnum) {
                return (JEnum)((Object)defined);
            }
        }
        catch (JLookupException defined) {
            // empty catch block
        }
        for (JPhantomEnum f : this.phantomEnums) {
            if (!f.name.equals(typeName)) continue;
            return f;
        }
        JPhantomEnum phantom = new JPhantomEnum(typeName, this);
        this.phantomEnums.add(phantom);
        this.tracer.getStatistic(PHANTOM_CREATION).incValue();
        return phantom;
    }

    @Nonnull
    public synchronized JInterface getPhantomInterface(@Nonnull String typeName) {
        try {
            JDefinedClassOrInterface defined = this.getType(typeName);
            if (defined instanceof JInterface) {
                return (JInterface)((Object)defined);
            }
        }
        catch (JLookupException defined) {
            // empty catch block
        }
        for (JPhantomInterface f : this.phantomInterfaces) {
            if (!f.name.equals(typeName)) continue;
            return f;
        }
        JPhantomInterface phantom = new JPhantomInterface(typeName, this);
        this.phantomInterfaces.add(phantom);
        this.tracer.getStatistic(PHANTOM_CREATION).incValue();
        return phantom;
    }

    @Nonnull
    public synchronized JAnnotationType getPhantomAnnotationType(@Nonnull String typeName) {
        try {
            JDefinedClassOrInterface defined = this.getType(typeName);
            if (defined instanceof JAnnotationType) {
                return (JAnnotationType)((Object)defined);
            }
        }
        catch (JLookupException defined) {
            // empty catch block
        }
        for (JPhantomAnnotationType f : this.phantomAnnotations) {
            if (!f.name.equals(typeName)) continue;
            return f;
        }
        JPhantomAnnotationType phantom = new JPhantomAnnotationType(typeName, this);
        this.phantomAnnotations.add(phantom);
        this.tracer.getStatistic(PHANTOM_CREATION).incValue();
        return phantom;
    }

    @Nonnull
    public synchronized Collection<JPhantomClassOrInterface> getPhantoms() {
        ArrayList<JPhantomClassOrInterface> phantoms = new ArrayList<JPhantomClassOrInterface>(this.phantomTypes.size() + this.phantomClasses.size() + this.phantomInterfaces.size() + this.phantomEnums.size() + this.phantomAnnotations.size());
        phantoms.addAll(this.phantomTypes);
        phantoms.addAll(this.phantomClasses);
        phantoms.addAll(this.phantomInterfaces);
        phantoms.addAll(this.phantomEnums);
        phantoms.addAll(this.phantomAnnotations);
        return phantoms;
    }

    @Override
    public void setName(@Nonnull String name) {
        if (this.enclosingPackage != null) {
            this.enclosingPackage.removeItemWithName(this);
        }
        this.name = StringInterner.get().intern(name);
    }

    public boolean isDefaultPackage() {
        return this.name.equals("");
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            if (visitor.needLoading()) {
                this.loadSubPackages();
                this.loadClassesAndInterfaces();
            }
            visitor.accept(this.subPackages);
            visitor.accept(this.declaredTypes);
        }
        visitor.endVisit(this);
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        boolean found = false;
        if (existingNode instanceof JPackage) {
            found = JPackage.transform(this.subPackages, existingNode, (JPackage)newNode, transformation);
        } else if (existingNode instanceof JDefinedClassOrInterface) {
            found = JPackage.transform(this.declaredTypes, existingNode, (JDefinedClassOrInterface)newNode, transformation);
        } else if (existingNode instanceof JPhantomClassOrInterface && !(found = JPackage.transform(this.phantomTypes, existingNode, (JPhantomClassOrInterface)newNode, transformation))) {
            if (existingNode instanceof JPhantomInterface) {
                found = JPackage.transform(this.phantomInterfaces, existingNode, (JPhantomInterface)newNode, transformation);
                if (!found && existingNode instanceof JPhantomAnnotationType) {
                    found = JPackage.transform(this.phantomAnnotations, existingNode, (JPhantomAnnotationType)newNode, transformation);
                }
            } else if (existingNode instanceof JPhantomClass && !(found = JPackage.transform(this.phantomClasses, existingNode, (JPhantomClass)newNode, transformation)) && existingNode instanceof JPhantomEnum) {
                found = JPackage.transform(this.phantomEnums, existingNode, (JPhantomEnum)newNode, transformation);
            }
        }
        if (!found) {
            super.transform(existingNode, newNode, transformation);
        } else if (transformation == JNode.Transformation.REMOVE) {
            assert (existingNode instanceof HasName);
            this.removeItemWithName((HasName)((Object)existingNode));
        }
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JPackage child : this.subPackages) {
            child.traverse(schedule);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Collection<? extends JDefinedClassOrInterface> getLoadedTypes() {
        return this.declaredTypes;
    }

    @Nonnull
    public JPackage addLoader(@Nonnull PackageLoader loader) {
        this.loaders.add(loader);
        return this;
    }

    @Nonnull
    public List<Location> getLocations(@Nonnull JPackage loaded) {
        ArrayList<Location> locations = new ArrayList<Location>(this.loaders.size());
        for (PackageLoader loader : this.loaders) {
            locations.add(loader.getLocation(loaded));
        }
        return locations;
    }

    @Nonnull
    protected JPackage loadSubPackage(@Nonnull String simpleName) throws JPackageLookupException {
        assert (!this.deletedItems.contains(simpleName));
        LinkedList<PackageLoader> subLoaders = null;
        for (PackageLoader loader : this.loaders) {
            try {
                PackageLoader subLoader = loader.getLoaderForSubPackage(this, simpleName);
                if (subLoaders == null) {
                    subLoaders = new LinkedList<PackageLoader>();
                }
                subLoaders.add(subLoader);
            }
            catch (JPackageLookupException jPackageLookupException) {}
        }
        if (subLoaders != null) {
            JPackage subPackage = new JPackage(simpleName, this, subLoaders);
            subPackage.updateParents(this);
            return subPackage;
        }
        throw new JPackageLookupException(simpleName, this);
    }

    protected void loadSubPackages() {
        HashSet<String> subNames = new HashSet<String>();
        for (PackageLoader loader : this.loaders) {
            subNames.addAll(loader.getSubPackageNames(this));
        }
        for (String name : subNames) {
            if (this.deletedItems.contains(name)) continue;
            try {
                this.getSubPackage(name);
            }
            catch (JPackageLookupException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Nonnull
    protected JDefinedClassOrInterface loadClassOrInterface(@Nonnull String simpleName) throws JTypeLookupException {
        if (!this.deletedItems.contains(simpleName)) {
            for (PackageLoader loader : this.loaders) {
                try {
                    return loader.loadClassOrInterface(this, simpleName);
                }
                catch (JLookupException jLookupException) {
                }
            }
        }
        throw new MissingJTypeLookupException(this, simpleName);
    }

    protected void loadClassesAndInterfaces() {
        HashSet<String> subNames = new HashSet<String>();
        for (PackageLoader loader : this.loaders) {
            subNames.addAll(loader.getSubClassNames(this));
        }
        for (String name : subNames) {
            if (this.deletedItems.contains(name)) continue;
            try {
                this.getType(name);
            }
            catch (JTypeLookupException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public void checkValidity() {
        if (this.parent instanceof JPackage) {
            if (this.parent != this.enclosingPackage) {
                throw new JNodeInternalError(this, "Invalid parent or enclosing package");
            }
        } else if (this.parent instanceof JSession) {
            if (this.enclosingPackage != null) {
                throw new JNodeInternalError(this, "Invalid parent or enclosing package");
            }
        } else {
            throw new JNodeInternalError(this, "Invalid parent or enclosing package");
        }
    }

    void removeItemWithName(@Nonnull HasName itemWithName) {
        this.deletedItems.add(itemWithName.getName());
    }

    private void addItemWithName(@Nonnull HasName itemWithName) {
        assert (itemWithName instanceof JPackage || itemWithName instanceof JClassOrInterface);
        this.deletedItems.remove(itemWithName.getName());
    }

    private static enum OnPath {
        NOT_YET_AVAILABLE,
        TRUE,
        FALSE;

    }
}

