/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.incremental;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.Options;
import com.android.jack.analysis.dependency.Dependency;
import com.android.jack.analysis.dependency.file.FileDependencies;
import com.android.jack.analysis.dependency.file.FileDependenciesInLibraryWriter;
import com.android.jack.analysis.dependency.library.LibraryDependencies;
import com.android.jack.analysis.dependency.library.LibraryDependenciesInLibraryWriter;
import com.android.jack.analysis.dependency.type.TypeDependencies;
import com.android.jack.analysis.dependency.type.TypeDependenciesInLibraryWriter;
import com.android.jack.incremental.CommonFilter;
import com.android.jack.incremental.IncrementalException;
import com.android.jack.incremental.IncrementalLogWriter;
import com.android.jack.incremental.InputFilter;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.Resource;
import com.android.jack.library.FileType;
import com.android.jack.library.FileTypeDoesNotExistException;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.JackLibraryFactory;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.LibraryReadingException;
import com.android.jack.library.LibraryVersionException;
import com.android.jack.library.LibraryWritingException;
import com.android.jack.library.NotJackLibraryException;
import com.android.jack.library.OutputJackLibrary;
import com.android.jack.meta.Meta;
import com.android.jack.reporting.ReportableIOException;
import com.android.jack.reporting.Reporter;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.ReaderFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.UnionVFSReadOnlyException;
import com.android.sched.vfs.VPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@ImplementationName(iface=InputFilter.class, name="incremental")
@HasKeyId
public class IncrementalInputFilter
extends CommonFilter
implements InputFilter {
    @Nonnull
    public static final BooleanPropertyId INCREMENTAL_LOG = BooleanPropertyId.create("jack.incremental.log", "Enable incremental log").addDefaultValue(Boolean.FALSE);
    @Nonnull
    public static final StatisticId<Counter> COMPILED_FILES = new StatisticId<Counter>("jack.incremental.source.compiled", "Source files that will be compile", CounterImpl.class, Counter.class);
    @Nonnull
    public static final StatisticId<Counter> MODIFIED_FILES = new StatisticId<Counter>("jack.incremental.source.modified", "Source files modified from the previous incremental compilation", CounterImpl.class, Counter.class);
    @Nonnull
    public static final StatisticId<Counter> DELETED_FILES = new StatisticId<Counter>("jack.incremental.source.deleted", "Source files deleted from the previous incremental compilation", CounterImpl.class, Counter.class);
    @Nonnull
    public static final StatisticId<Counter> ADDED_FILES = new StatisticId<Counter>("jack.incremental.source.added", "Source files added from the previous incremental compilation", CounterImpl.class, Counter.class);
    @Nonnull
    public static final StatisticId<Counter> SOURCE_FILES = new StatisticId<Counter>("jack.incremental.source", "Source files to compile", CounterImpl.class, Counter.class);
    @CheckForNull
    private final InputJackLibrary incrementalInputLibrary;
    @Nonnull
    private final LibraryDependencies libraryDependencies = new LibraryDependencies();
    @Nonnull
    private final FileDependencies fileDependencies = new FileDependencies();
    @Nonnull
    private final TypeDependencies typeDependencies = new TypeDependencies();
    @Nonnull
    private final Set<String> fileNamesOnCmdLine;
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final Set<String> deletedFileNames = new HashSet<String>();
    @Nonnull
    private final Set<String> addedFileNames = new HashSet<String>();
    @Nonnull
    private final Set<String> modifiedFileNames = new HashSet<String>();
    @Nonnull
    private final Set<String> filesToRecompiles;
    @Nonnull
    private List<InputLibrary> importedLibraries;
    @Nonnull
    private final List<Resource> importedResources;
    @Nonnull
    private final List<Meta> importedMetas;
    @Nonnull
    private final List<? extends InputLibrary> librariesOnClasspath;

    public IncrementalInputFilter(@Nonnull Options options) {
        boolean mergingEnabled;
        Config config = ThreadConfig.getConfig();
        this.incrementalInputLibrary = this.getIncrementalInternalLibrary();
        this.fileNamesOnCmdLine = this.getJavaFileNamesSpecifiedOnCommandLine(options);
        this.tracer.getStatistic(SOURCE_FILES).incValue(this.fileNamesOnCmdLine.size());
        List<InputLibrary> importedLibrariesFromCommandLine = config.get(Options.IMPORTED_LIBRARIES);
        JSession session = Jack.getSession();
        if (this.incrementalInputLibrary != null && this.incrementalInputLibrary.containsFileType(FileType.DEPENDENCIES)) {
            mergingEnabled = this.incrementalInputLibrary.canBeMerged(importedLibrariesFromCommandLine);
            if (mergingEnabled) {
                this.incrementalInputLibrary.mergeInputLibraries(importedLibrariesFromCommandLine);
                this.importedLibraries = Collections.singletonList(this.incrementalInputLibrary);
            } else {
                this.importedLibraries = new ArrayList<InputLibrary>(importedLibrariesFromCommandLine.size() + 1);
                this.importedLibraries.add(this.incrementalInputLibrary);
                this.importedLibraries.addAll(importedLibrariesFromCommandLine);
            }
            this.deleteAllResources();
            try {
                this.fillDependencies(this.incrementalInputLibrary, FileDependencies.vpath, this.fileDependencies);
                this.fillDependencies(this.incrementalInputLibrary, TypeDependencies.vpath, this.typeDependencies);
                this.fillDependencies(this.incrementalInputLibrary, LibraryDependencies.vpath, this.libraryDependencies);
            }
            catch (CannotReadException e) {
                LibraryReadingException reportable = new LibraryReadingException(new LibraryFormatException(this.incrementalInputLibrary.getLocation()));
                session.getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
            catch (FileTypeDoesNotExistException e) {
                LibraryReadingException reportable = new LibraryReadingException(new LibraryFormatException(this.incrementalInputLibrary.getLocation()));
                session.getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
            this.fillAddedFileNames(this.addedFileNames);
            this.fillModifiedFileNames(this.modifiedFileNames);
            this.fillDeletedFileNames(this.deletedFileNames);
        } else {
            mergingEnabled = session.getJackOutputLibrary().canBeMerged(importedLibrariesFromCommandLine);
            if (mergingEnabled) {
                session.getJackOutputLibrary().mergeInputLibraries(importedLibrariesFromCommandLine);
            }
        }
        List<InputLibrary> classpathContent = config.get(Options.CLASSPATH);
        this.librariesOnClasspath = this.getClasspathLibraries(classpathContent, config.get(Jack.STRICT_CLASSPATH));
        session.getLibraryDependencies().addImportedLibraries(importedLibrariesFromCommandLine);
        session.getLibraryDependencies().addLibrariesOnClasspath(this.librariesOnClasspath);
        this.filesToRecompiles = this.getInternalFileNamesToCompile();
        this.importedResources = this.importStandaloneResources();
        this.importedMetas = this.importStandaloneMetas();
        if (config.get(INCREMENTAL_LOG).booleanValue()) {
            try {
                IncrementalLogWriter incLog = new IncrementalLogWriter(session.getJackOutputLibrary());
                incLog.writeString("type: " + (this.needFullBuild() ? "full" : "incremental"));
                incLog.writeLibraryDescriptions("classpath", this.librariesOnClasspath);
                incLog.writeStrings("classpath digests (" + (this.libraryDependencies.hasSameLibraryOnClasspath(session.getLibraryDependencies()) ? "identical" : "modified") + ")", session.getLibraryDependencies().getDigestOfLibrariesOnClasspath());
                incLog.writeLibraryDescriptions("import", importedLibrariesFromCommandLine);
                incLog.writeStrings("import digests (" + (this.libraryDependencies.hasSameImportedLibrary(session.getLibraryDependencies()) ? "identical" : "modified") + ")", session.getLibraryDependencies().getDigestOfImportedLibraries());
                incLog.writeStrings("added (" + this.addedFileNames.size() + ")", this.addedFileNames);
                incLog.writeStrings("deleted (" + this.deletedFileNames.size() + ")", this.deletedFileNames);
                incLog.writeStrings("modified (" + this.modifiedFileNames.size() + ")", this.modifiedFileNames);
                incLog.writeStrings("compiled (" + this.filesToRecompiles.size() + ")", this.filesToRecompiles);
                incLog.writeString("imported libraries have " + (mergingEnabled ? "" : "not ") + "been unified");
                incLog.close();
            }
            catch (LibraryIOException e) {
                LibraryWritingException reportable = new LibraryWritingException(e);
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
                throw new JackAbortException(reportable);
            }
        }
        if (this.needFullBuild()) {
            session.setFileDependencies(new FileDependencies());
            session.setTypeDependencies(new TypeDependencies());
            this.importedLibraries = importedLibrariesFromCommandLine;
            if (this.incrementalInputLibrary != null) {
                try {
                    this.incrementalInputLibrary.close();
                }
                catch (LibraryIOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        } else {
            try {
                this.updateIncrementalState();
            }
            catch (IncrementalException e) {
                session.getReporter().report(Reporter.Severity.FATAL, e);
                throw new JackAbortException(e);
            }
        }
    }

    @Override
    @Nonnull
    public List<? extends InputLibrary> getClasspath() {
        return this.librariesOnClasspath;
    }

    @Override
    @Nonnull
    public Set<ReaderFile> getFileToCompile() {
        HashSet<ReaderFile> fileToCompile = new HashSet<ReaderFile>();
        for (String fileName : this.filesToRecompiles) {
            fileToCompile.add((ReaderFile)this.path2ReaderFile.get(fileName));
        }
        return fileToCompile;
    }

    @Nonnull
    private Set<String> getInternalFileNamesToCompile() {
        if (this.needFullBuild()) {
            this.tracer.getStatistic(COMPILED_FILES).incValue(this.fileNamesOnCmdLine.size());
            return this.fileNamesOnCmdLine;
        }
        Map<String, Set<String>> typeRecompileDependencies = this.typeDependencies.getRecompileDependencies();
        HashSet<String> filesToRecompile = new HashSet<String>();
        filesToRecompile.addAll(this.addedFileNames);
        filesToRecompile.addAll(this.modifiedFileNames);
        this.addDependencies(filesToRecompile, typeRecompileDependencies, this.modifiedFileNames);
        this.addDependencies(filesToRecompile, typeRecompileDependencies, this.deletedFileNames);
        this.tracer.getStatistic(COMPILED_FILES).incValue(filesToRecompile.size());
        return filesToRecompile;
    }

    private void addDependencies(@Nonnull Set<String> filesToRecompile, @Nonnull Map<String, Set<String>> typeRecompileDependencies, @Nonnull Set<String> fileNames) {
        for (String fileName : fileNames) {
            for (String dependencyFileName : this.getDependencyFileNamesToRecompile(typeRecompileDependencies, fileName)) {
                filesToRecompile.add(dependencyFileName);
            }
        }
    }

    private void updateIncrementalState() throws IncrementalException {
        if (this.incrementalInputLibrary != null) {
            for (String fileToRecompile : this.filesToRecompiles) {
                this.deleteOldFilesFromJavaFiles(fileToRecompile);
            }
            for (String deletedFileName : this.deletedFileNames) {
                this.deleteOldFilesFromJavaFiles(deletedFileName);
            }
            this.typeDependencies.update(this.fileDependencies, this.deletedFileNames, this.modifiedFileNames);
            this.fileDependencies.update(this.deletedFileNames, this.modifiedFileNames);
            OutputJackLibrary outputLibrary = Jack.getSession().getJackOutputLibrary();
            FileDependenciesInLibraryWriter.write(outputLibrary, this.fileDependencies);
            TypeDependenciesInLibraryWriter.write(outputLibrary, this.typeDependencies);
            LibraryDependenciesInLibraryWriter.write(outputLibrary, this.libraryDependencies);
            Jack.getSession().setFileDependencies(this.fileDependencies);
            Jack.getSession().setTypeDependencies(this.typeDependencies);
        }
    }

    private void deleteAllResources() {
        assert (this.incrementalInputLibrary != null);
        Iterator<InputVFile> vFileIt = this.incrementalInputLibrary.iterator(FileType.RSC);
        while (vFileIt.hasNext()) {
            try {
                this.incrementalInputLibrary.delete(FileType.RSC, vFileIt.next().getPathFromRoot());
            }
            catch (FileTypeDoesNotExistException | CannotDeleteFileException e) {
                throw new AssertionError((Object)e);
            }
            catch (UnionVFSReadOnlyException unionVFSReadOnlyException) {
            }
        }
    }

    private void deleteOldFilesFromJavaFiles(@Nonnull String javaFileName) throws IncrementalException {
        ArrayList<String> deletedTypes = new ArrayList<String>();
        for (String typeNameToRemove : this.fileDependencies.getTypeNames(javaFileName)) {
            if (deletedTypes.contains(typeNameToRemove)) continue;
            deletedTypes.add(typeNameToRemove);
            VPath vpath = new VPath(typeNameToRemove, '/');
            this.deleteFile(FileType.JAYCE, vpath);
            this.deleteFile(FileType.PREBUILT, vpath);
        }
    }

    private void deleteFile(@Nonnull FileType fileType, @Nonnull VPath vpath) throws IncrementalException {
        assert (this.incrementalInputLibrary != null);
        try {
            this.incrementalInputLibrary.delete(fileType, vpath);
        }
        catch (FileTypeDoesNotExistException fileTypeDoesNotExistException) {
        }
        catch (CannotDeleteFileException e) {
            throw new IncrementalException(e);
        }
    }

    private boolean needFullBuild() {
        JSession session = Jack.getSession();
        return this.incrementalInputLibrary == null || !this.libraryDependencies.hasSameLibraryOnClasspath(session.getLibraryDependencies()) || !this.libraryDependencies.hasSameImportedLibrary(session.getLibraryDependencies());
    }

    @Nonnull
    private List<String> getDependencyFileNamesToRecompile(@Nonnull Map<String, Set<String>> typeRecompileDependencies, @Nonnull String modifiedJavaFileName) {
        ArrayList<String> fileNamesToRecompile = new ArrayList<String>();
        assert (this.fileDependencies != null);
        for (String modifiedTypeName : this.fileDependencies.getTypeNames(modifiedJavaFileName)) {
            for (String typeName : typeRecompileDependencies.get(modifiedTypeName)) {
                String dependentFileName = this.fileDependencies.getJavaFileName(typeName);
                if (dependentFileName == null || this.deletedFileNames.contains(dependentFileName)) continue;
                fileNamesToRecompile.add(dependentFileName);
            }
        }
        return fileNamesToRecompile;
    }

    @CheckForNull
    private InputJackLibrary getIncrementalInternalLibrary() {
        try {
            return JackLibraryFactory.getInputLibrary(Jack.getSession().getJackOutputLibrary());
        }
        catch (NotJackLibraryException notJackLibraryException) {
        }
        catch (LibraryVersionException libraryVersionException) {
        }
        catch (LibraryFormatException libraryFormatException) {
            // empty catch block
        }
        return null;
    }

    @Nonnull
    private void fillAddedFileNames(@Nonnull Set<String> addedFileNames) {
        assert (this.fileDependencies != null);
        Set<String> previousFiles = this.fileDependencies.getCompiledJavaFiles();
        for (String javaFileName : this.fileNamesOnCmdLine) {
            if (previousFiles.contains(javaFileName)) continue;
            addedFileNames.add(javaFileName);
        }
        this.tracer.getStatistic(ADDED_FILES).incValue(addedFileNames.size());
    }

    @Nonnull
    private void fillModifiedFileNames(@Nonnull Set<String> modifiedFileNames) {
        assert (this.fileDependencies != null);
        assert (this.incrementalInputLibrary != null);
        for (String javaFileName : this.fileDependencies.getCompiledJavaFiles()) {
            if (!this.fileNamesOnCmdLine.contains(javaFileName)) continue;
            File javaFile = new File(javaFileName);
            for (String typeName : this.fileDependencies.getTypeNames(javaFileName)) {
                InputVFile dexFile;
                try {
                    dexFile = this.incrementalInputLibrary.getFile(FileType.PREBUILT, new VPath(typeName, '/'));
                }
                catch (FileTypeDoesNotExistException e) {
                    dexFile = null;
                }
                try {
                    try {
                        if (dexFile != null && Files.getLastModifiedTime(javaFile.toPath(), new LinkOption[0]).compareTo(dexFile.getLastModified()) <= 0) continue;
                        modifiedFileNames.add(javaFileName);
                    }
                    catch (IOException e) {
                        throw new CannotReadException(new FileLocation(javaFile), (Throwable)e);
                    }
                }
                catch (CannotGetModificationTimeException | CannotReadException e) {
                    ReportableIOException reportable = new ReportableIOException("Computing incremental state", e);
                    Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
                    throw new JackAbortException(reportable);
                }
            }
        }
        this.tracer.getStatistic(MODIFIED_FILES).incValue(modifiedFileNames.size());
    }

    @Nonnull
    private void fillDeletedFileNames(@Nonnull Set<String> deletedFileNames) {
        assert (this.fileDependencies != null);
        for (String javaFileName : this.fileDependencies.getCompiledJavaFiles()) {
            if (this.fileNamesOnCmdLine.contains(javaFileName)) continue;
            deletedFileNames.add(javaFileName);
        }
        this.tracer.getStatistic(DELETED_FILES).incValue(deletedFileNames.size());
    }

    @Nonnull
    private void fillDependencies(@Nonnull InputJackLibrary library, @Nonnull VPath dependencyVPath, @Nonnull Dependency dependency) throws CannotReadException, FileTypeDoesNotExistException {
        InputVFile dependenciesVFile = library.getFile(FileType.DEPENDENCIES, dependencyVPath);
        InputStreamReader fileReader = null;
        try {
            fileReader = new InputStreamReader(dependenciesVFile.getInputStream());
            dependency.read(fileReader);
        }
        catch (WrongPermissionException | IOException | NoSuchElementException e) {
            throw new CannotReadException(dependenciesVFile, (Throwable)e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    @Nonnull
    public List<? extends InputLibrary> getImportedLibraries() {
        return this.importedLibraries;
    }

    @Override
    @Nonnull
    public List<? extends Resource> getImportedResources() {
        return this.importedResources;
    }

    @Override
    @Nonnull
    public List<? extends Meta> getImportedMetas() {
        return this.importedMetas;
    }
}

