/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.core;

import com.android.jack.freemarker.core.Environment;
import com.android.jack.freemarker.core.EvalUtil;
import com.android.jack.freemarker.core.Expression;
import com.android.jack.freemarker.core.Interpolation;
import com.android.jack.freemarker.core.MarkupOutputFormat;
import com.android.jack.freemarker.core.OutputFormat;
import com.android.jack.freemarker.core.ParameterRole;
import com.android.jack.freemarker.core.TemplateElement;
import com.android.jack.freemarker.core.TemplateMarkupOutputModel;
import com.android.jack.freemarker.core._DelayedToString;
import com.android.jack.freemarker.core._TemplateModelException;
import com.android.jack.freemarker.template.TemplateException;
import com.android.jack.freemarker.template.utility.StringUtil;
import java.io.IOException;
import java.io.Writer;

final class DollarVariable
extends Interpolation {
    private final Expression expression;
    private final Expression escapedExpression;
    private final OutputFormat outputFormat;
    private final MarkupOutputFormat markupOutputFormat;
    private final boolean autoEscape;

    DollarVariable(Expression expression, Expression escapedExpression, OutputFormat outputFormat, boolean autoEscape) {
        this.expression = expression;
        this.escapedExpression = escapedExpression;
        this.outputFormat = outputFormat;
        this.markupOutputFormat = (MarkupOutputFormat)(outputFormat instanceof MarkupOutputFormat ? outputFormat : null);
        this.autoEscape = autoEscape;
    }

    TemplateElement[] accept(Environment env) throws TemplateException, IOException {
        Object moOrStr = this.calculateInterpolatedStringOrMarkup(env);
        Writer out = env.getOut();
        if (moOrStr instanceof String) {
            String s = (String)moOrStr;
            if (this.autoEscape) {
                this.markupOutputFormat.output(s, out);
            } else {
                out.write(s);
            }
        } else {
            TemplateMarkupOutputModel mo = (TemplateMarkupOutputModel)moOrStr;
            MarkupOutputFormat<TemplateMarkupOutputModel> moOF = mo.getOutputFormat();
            if (moOF != this.outputFormat && !this.outputFormat.isOutputFormatMixingAllowed()) {
                String srcPlainText = moOF.getSourcePlainText(mo);
                if (srcPlainText == null) {
                    throw new _TemplateModelException(this.escapedExpression, "The value to print is in ", new _DelayedToString(moOF), " format, which differs from the current output format, ", new _DelayedToString(this.outputFormat), ". Format conversion wasn't possible.");
                }
                if (this.outputFormat instanceof MarkupOutputFormat) {
                    ((MarkupOutputFormat)this.outputFormat).output(srcPlainText, out);
                } else {
                    out.write(srcPlainText);
                }
            } else {
                moOF.output(mo, out);
            }
        }
        return null;
    }

    protected Object calculateInterpolatedStringOrMarkup(Environment env) throws TemplateException {
        return EvalUtil.coerceModelToStringOrMarkup(this.escapedExpression.eval(env), this.escapedExpression, null, env);
    }

    protected String dump(boolean canonical, boolean inStringLiteral) {
        StringBuilder sb = new StringBuilder();
        sb.append("${");
        String exprCF = this.expression.getCanonicalForm();
        sb.append(inStringLiteral ? StringUtil.FTLStringLiteralEnc(exprCF, '\"') : exprCF);
        sb.append("}");
        if (!canonical && this.expression != this.escapedExpression) {
            sb.append(" auto-escaped");
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return "${...}";
    }

    boolean heedsOpeningWhitespace() {
        return true;
    }

    boolean heedsTrailingWhitespace() {
        return true;
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.expression;
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.CONTENT;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

