/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.io.instructions;

import com.android.jack.dx.io.IndexType;
import com.android.jack.dx.io.OpcodeInfo;
import com.android.jack.dx.io.instructions.DecodedInstruction;
import com.android.jack.dx.io.instructions.InstructionCodec;

public final class OneRegisterDecodedInstruction
extends DecodedInstruction {
    private final int a;

    public OneRegisterDecodedInstruction(InstructionCodec format, int opcode, int firstIndex, IndexType firstIndexType, int target, long literal, int a) {
        this(format, opcode, firstIndex, firstIndexType, target, literal, a, 0, IndexType.NONE);
        assert (!OpcodeInfo.hasDualConstants(opcode));
    }

    public OneRegisterDecodedInstruction(InstructionCodec format, int opcode, int firstIndex, IndexType firstIndexType, int target, long literal, int a, int secondIndex, IndexType secondIndexType) {
        super(format, opcode, firstIndex, firstIndexType, target, literal, secondIndex, secondIndexType);
        this.a = a;
    }

    @Override
    public int getRegisterCount() {
        return 1;
    }

    @Override
    public int getA() {
        return this.a;
    }

    @Override
    public DecodedInstruction withIndex(int newFirstIndex, int newSecondIndex) {
        return new OneRegisterDecodedInstruction(this.getFormat(), this.getOpcode(), newFirstIndex, this.getFirstIndexType(), this.getTarget(), this.getLiteral(), this.a, newSecondIndex, this.getSecondIndexType());
    }
}

