/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;

public final class ZipUtils {
    public static final char ZIP_SEPARATOR = '/';
    static final String ZIP_SEPARATOR_STRING = "/";
    static final String ROOT_ENTRY_NAME = "";

    private ZipUtils() {
    }

    @Nonnull
    static String getFileSimpleName(@Nonnull ZipEntry entry) {
        String name = entry.getName();
        assert (!name.endsWith(ZIP_SEPARATOR_STRING));
        int index = name.lastIndexOf(47);
        if (index < 0) {
            return name;
        }
        return name.substring(index + 1);
    }

    @Nonnull
    static String getDirSimpleName(@Nonnull ZipEntry entry) {
        String name = entry.getName();
        if (name.equals(ROOT_ENTRY_NAME)) {
            return ROOT_ENTRY_NAME;
        }
        assert (name.endsWith(ZIP_SEPARATOR_STRING));
        int index = name.lastIndexOf(47, name.length() - 2);
        int startIndex = index + 1;
        return name.substring(startIndex, name.length() - 1);
    }
}

