/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.StandardInputLocation;
import com.android.sched.util.stream.QueryableInputStream;
import com.android.sched.util.stream.UncloseableInputStream;
import com.android.sched.vfs.ReaderProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ReaderFile
extends AbstractStreamFile
implements ReaderProvider {
    @Nonnegative
    private static final int BUFFER_SIZE = 8192;
    @CheckForNull
    private BufferedReader reader;
    @Nonnull
    private final Charset charset;
    @Nonnegative
    private final int bufferSize;

    public ReaderFile(@Nonnull String name) throws WrongPermissionException, NotFileException, NoSuchFileException {
        this(new File(name), Charset.defaultCharset(), new FileLocation(name));
    }

    public ReaderFile(@Nonnull String name, @Nonnull Charset charset) throws WrongPermissionException, NotFileException, NoSuchFileException {
        this(new File(name), charset, new FileLocation(name));
    }

    public ReaderFile() {
        this(Charset.defaultCharset());
    }

    public ReaderFile(@Nonnull Charset charset) {
        super(new StandardInputLocation());
        this.charset = charset;
        this.bufferSize = 8192;
        this.stream = new QueryableInputStream(new UncloseableInputStream(System.in));
        this.reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.stream), charset), this.bufferSize);
    }

    public ReaderFile(@Nonnull InputStream stream, @Nonnull Location location) {
        this(stream, Charset.defaultCharset(), location);
    }

    public ReaderFile(@Nonnull InputStream stream, @Nonnull Charset charset, @Nonnull Location location) {
        super(location);
        this.charset = charset;
        this.bufferSize = 8192;
        this.stream = new QueryableInputStream(new UncloseableInputStream(System.in));
        this.reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.stream), charset), this.bufferSize);
    }

    public ReaderFile(@Nonnull InputStream stream, @Nonnull Charset charset, @Nonnegative int bufferSize, @Nonnull Location location) {
        super(location);
        this.charset = charset;
        this.bufferSize = bufferSize;
        this.stream = new QueryableInputStream(new UncloseableInputStream(System.in));
        this.reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.stream), charset), bufferSize);
    }

    public ReaderFile(@CheckForNull Directory workingDirectory, @Nonnull String string) throws NotFileException, WrongPermissionException, NoSuchFileException {
        this(ReaderFile.getFileFromWorkingDirectory(workingDirectory, string), Charset.defaultCharset(), new FileLocation(string));
    }

    public ReaderFile(@CheckForNull Directory workingDirectory, @Nonnull String string, @Nonnull Charset charset) throws NotFileException, WrongPermissionException, NoSuchFileException {
        this(ReaderFile.getFileFromWorkingDirectory(workingDirectory, string), charset, new FileLocation(string));
    }

    public ReaderFile(@CheckForNull Directory workingDirectory, @Nonnull String string, @Nonnull Charset charset, @Nonnegative int bufferSize) throws NotFileException, WrongPermissionException, NoSuchFileException {
        super(ReaderFile.getFileFromWorkingDirectory(workingDirectory, string), new FileLocation(string), null);
        try {
            this.performChecks(FileOrDirectory.Existence.MUST_EXIST, 1, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        this.charset = charset;
        this.bufferSize = bufferSize;
    }

    private ReaderFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull FileLocation location) throws WrongPermissionException, NotFileException, NoSuchFileException {
        super(file, location, null);
        try {
            this.performChecks(FileOrDirectory.Existence.MUST_EXIST, 1, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        this.charset = charset;
        this.bufferSize = 8192;
    }

    @Override
    @Nonnull
    public synchronized BufferedReader getBufferedReader() {
        this.wasUsed = true;
        if (this.reader == null) {
            this.clearRemover();
            try {
                this.stream = new QueryableInputStream(new FileInputStream(this.file));
                this.reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.stream), this.charset), this.bufferSize);
            }
            catch (FileNotFoundException e) {
                throw new ConcurrentIOException(e);
            }
        }
        return this.reader;
    }

    @Nonnull
    public Charset getCharset() {
        return this.charset;
    }
}

