/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.item.Items;
import com.android.sched.item.Synchronized;
import com.android.sched.marker.MarkerNotConformException;
import com.android.sched.schedulable.Schedulable;
import com.android.sched.scheduler.SchedulableNotConformException;
import com.android.sched.util.HasDescription;
import com.android.sched.util.log.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class ManagedSchedulable
implements HasDescription {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Class<? extends Schedulable> schedulable;
    @Nonnull
    private final String name;
    @Nonnull
    private final String description;
    private boolean isSynchronized = false;
    @CheckForNull
    private Method dynamicIsSynchronized = null;

    protected ManagedSchedulable(@Nonnull Class<? extends Schedulable> schedulable) throws SchedulableNotConformException {
        this.schedulable = schedulable;
        this.name = Items.getName(schedulable);
        String description = Items.getDescription(schedulable);
        if (description == null) {
            throw new SchedulableNotConformException("Schedulable '" + schedulable.getCanonicalName() + "' must have a @" + Description.class.getSimpleName());
        }
        this.description = description;
        this.extractSynchronized(schedulable);
    }

    @Nonnull
    public <T> Class<? extends Schedulable> getSchedulable() {
        return this.schedulable;
    }

    public abstract boolean isVisitor();

    public abstract boolean isRunnable();

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isSynchronized(@Nonnull Schedulable schedulable) {
        if (this.isSynchronized) {
            return true;
        }
        if (this.dynamicIsSynchronized != null) {
            try {
                return (Boolean)this.dynamicIsSynchronized.invoke((Object)schedulable, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                logger.log(Level.WARNING, "Method '" + this.dynamicIsSynchronized.toString() + "' threw an exception", e.getCause());
                return false;
            }
        }
        return false;
    }

    public boolean isStaticallySynchronized() {
        return this.isSynchronized;
    }

    @CheckForNull
    public Method getDynamicallySynchronizedMethod() {
        return this.dynamicIsSynchronized;
    }

    @Nonnull
    public abstract Class<? extends Component> getRunOn();

    @Override
    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public abstract String toString();

    private void extractSynchronized(@Nonnull Class<? extends Schedulable> cls) {
        Synchronized sync = cls.getAnnotation(Synchronized.class);
        this.isSynchronized = sync != null;
        for (Method method : cls.getMethods()) {
            Synchronized dynamicSynchronizedOnAnnotation = method.getAnnotation(Synchronized.class);
            if (dynamicSynchronizedOnAnnotation == null) continue;
            if (!method.getReturnType().equals(Boolean.TYPE)) {
                throw new SchedulableNotConformException("Annotated method '" + method.toString() + "' with @" + Synchronized.class.getSimpleName() + " must have a 'boolean' return type");
            }
            if (method.getParameterTypes().length != 0) {
                throw new SchedulableNotConformException("Annotated method '" + method.toString() + "' with @" + Synchronized.class.getSimpleName() + " must have no parameter");
            }
            if (this.isSynchronized) {
                throw new SchedulableNotConformException("Schedulable '" + this.name + "' cannot have both a static and a dynamic @" + Synchronized.class.getName() + " (on class '" + cls.getCanonicalName() + "')");
            }
            if (this.dynamicIsSynchronized != null) {
                throw new MarkerNotConformException("Schedulable '" + this.name + "' cannot have two @" + Synchronized.class.getName() + " ('" + method.toString() + "' and '" + this.dynamicIsSynchronized + "')");
            }
            this.dynamicIsSynchronized = method;
        }
    }
}

