/$ NASL.h

/*
AUSTIN - A PalmOS Security Scanner.
Copyright (C) 2003  @stake, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Handles all TCP communications

#ifndef	__NASL_H__
#define	__NASL_H__

#define	NASL_CRAPCHAR	"A"

// the ip address to use for NASL functions
string _nasl_ip;

int open_sock_tcp(int port) {
	return tcpConnect(_nasl_ip, port);
}

string crap(int length) {
	int i, l = 0;
	string s, res = "";
	
	while (l < length) {
		i = 1; s = NASL_CRAPCHAR;
		while ((i<<1) <= length-l) {
			s = s + s;
			i = i << 1;
		}
		l = l + i;
		res = res + s;
	}
	return res;
}

string tolower(string str) {
	return strlwr(str);
}

string toupper(string str) {
	return strupr(str);
}

#endif
