/$ Constants.h

/*
AUSTIN - A Palm OS Security Scanner.
Copyright (C) 2003  @stake, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// General constants

#ifndef	__CONSTANTS_H__
#define	__CONSTANTS_H__

#define	TRUE		1
#define	FALSE		0
#define	NULL		0

#define	AUSTIN_VERSION				101

#define	ERR_NOHOSTSSPECIFIED		"No host(s) specified."
#define	ERR_NOTCPPORTSSPECIFIED		"No TCP ports(s) specified above & no TCP entries are selected in the Prefs DB."
#define	ERR_NOUDPPORTSSPECIFIED		"No UDP ports(s) specified above & no UDP entries are selected in the Prefs DB."
#define	ERR_NOSCANTYPESPECIFIED		"Select either a TCP or UDP scan."
#define	ERR_INVALIDHOSTS			"Unable to parse hosts, use only chars 0-9, ',', '.', and '-'"
#define	ERR_INVALIDPORTS			"Unable to parse ports, use only chars 0-9, ',', '.', and '-'"
#define	ERR_WEBVULNWITHOUTBANNER	"URL Scan requires Banner Grabbing to check ports for HTTP. Press Scan! to continue."
#define ERR_NOBANNERSTRING			"No banner string has been selected from the AUSTIN Prefs DB."
#define ERR_NOSCANCOUNTSPECIFIED	"You must specify & select the 'Scan count' pref in the AUSTIN Prefs DB."
#define ERR_NOSLEEPTIMESPECIFIED	"You must specify & select the 'Sleep time' pref in the AUSTIN Prefs DB."
#define ERR_NOSLEEPFIRSTSPECIFIED	"You must specify & select the 'Sleep first' pref in the AUSTIN Prefs DB."


// AUSTIN version number

int _AUSTIN_version = AUSTIN_VERSION;

#endif
