/*
 *  © Darren McDonald 2010
 *
 *  This file is part of athena-ssl-cipher-check.
 *
 *  athena-ssl-cipher-check is free software: you can redistribute it
 *  and/or modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, either version 3 of the License,
 *  or (at your option) any later version.
 *
 *  athena-ssl-cipher-check is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 *  Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with athena-ssl-cipher-check. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

package athenasslciphercheck;

public class Settings {
    private String host;
    private int port;

    private int proxyType;
    private String proxyHost;
    private int proxyPort;

    private String basicAuth;

    private int timeout;
    private int throttle;
    private int retrys;

    private boolean client;
    private boolean lazy = false;
    private boolean safe = false;

    public static final int DIRECT = 0; //No proxy
    public static final int HTTP = 1; //HTTP Connect
    public static final String VERSION = "0.6.2"; //version number

    public void setClient( boolean c )
    {
        client = c;
    }

    public boolean getClient()
    {
        return client;
    }

    public void setHost( String host)
    {
        this.host = host;
    }

    public String getHost()
    {
        return this.host;
    }

    public void setPort( int port )
    {
        this.port = port;
    }

    public int getPort()
    {
        return port;
    }

    public void setProxyType( int proxyType )
    {
        this.proxyType = proxyType;
    }

    public int getProxyType()
    {
        return proxyType;
    }

    public void setProxyHost( String proxyHost)
    {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost()
    {
        return this.proxyHost;
    }

    public void setProxyPort( int proxyPort )
    {
        this.proxyPort = proxyPort;
    }

    public int getProxyPort()
    {
        return proxyPort;
    }

    public void setTimeout( int timeout )
    {
        this.timeout = timeout;
    }

    public int getTimeout()
    {
        return timeout;
    }

    public void setThrottle( int throttle )
    {
        this.throttle = throttle;
    }

    public int getThrottle()
    {
        return throttle;
    }

    public void setRetrys( int retrys )
    {
        this.retrys = retrys;
    }

    public int getRetrys()
    {
        return retrys;
    }

    public void setBasicAuth( String basicAuth )
    {
        //System.out.println(Base64.encodeBytes(basicAuth.getBytes()));
        this.basicAuth = Base64.encodeBytes(basicAuth.getBytes());
    }

    public String getBasicAuth()
    {
        return basicAuth;
    }

    public void setLazy(  )
    {
        this.lazy = true;
    }

    public boolean getLazy()
    {
        return lazy;
    }

    public void setSafe(  )
    {
        this.safe = true;
    }

    public boolean getSafe()
    {
        return safe;
    }

}
