/*
 *  This file is part of athena-ssl-cipher-check.
 *
 *  athena-ssl-cipher-check is free software: you can redistribute it
 *  and/or modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, either version 3 of the License,
 *  or (at your option) any later version.
 *
 *  athena-ssl-cipher-check is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 *  Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with athena-ssl-cipher-check. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

package athenasslciphercheck;

import java.util.ArrayList;

/**
 *
 * @author notroot
 */
public class Results {
    public static Settings settings;

    private static ArrayList<Cipher> lines = new ArrayList<Cipher>();
    private static ArrayList<String> lines2 = new ArrayList<String>();
    private static String host;
    private static String port;
    private static String filename;
    private static int countCiphers = 0;

    public static void addResultLine( Cipher l, String p )
    {
        if( l != null )
            System.out.println( l.getDesc() );
        else
            System.out.println( p );
        lines2.add( p );
        lines.add( l );

        if( !p.equals("SSLv2") )
          countCiphers ++;
    }

    public static int getCount()
    {
        return countCiphers;
    }

    public static void setHost( String h )
    {
        host = h;
    }

    public static void setPort( String p )
    {
        port = p;
    }


    public static String getLazy()
    {
        boolean first = true;
        int count = 0;
        //Print Weak Ciphers
        String s = "\nThe following ciphers should be disabled on " + host + ":" + port + "\n";
        s += "Ciphers will appear in multiple lists if they have multiple problems\n";
        
        for( int i = 0; i < lines.size(); i++ )
        {
            if( lines.get(i).getKeySize() < 128 && lines.get(i).getKeySize() != 0 )
            {
                if( first )
                {
                    first = false;
                    s += "\nWeak Ciphers\n";
                    count++;
                }
                s += lines2.get(i) + " " + lines.get(i).getDesc() + "\n";
            }
        }

        first = true;

        //Print Anonymous Ciphers
        
        for( int i = 0; i < lines.size(); i++ )
        {
            if( lines.get(i).getanonymous() == 1 )
            {
                if( first )
                {
                    first = false;
                    s += "\nAnonymous Ciphers\n";
                    count++;
                }
                s += lines2.get(i) + " " + lines.get(i).getDesc() + "\n";
            }
        }
        
        first = true;

        //Print NULL Ciphers

        for( int i = 0; i < lines.size(); i++ )
        {
            if( lines.get(i).getKeySize() == 0 )
            {
                if( first )
                {
                    first = false;
                    s += "\nNull Ciphers\n";
                    count++;
                }
                s += lines2.get(i) + " " + lines.get(i).getDesc() + "\n";
            }
        }
        
        first = true;

        //Print SSLv2 Ciphers
        for( int i = 0; i < lines.size(); i++ )
        {
            if( lines2.get(i).equals("SSLv2") )
            {
                if( first )
                {
                    first = false;
                    s += "\nSSLv2 Ciphers\n";
                    count++;
                }
                s += lines2.get(i) + " " + lines.get(i).getDesc() + "\n";
            }
        }

        if( count == 0 )
            s+= "\nNone";

        return s;
    }
    
}
