/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class ATextField
extends JTextField {
    protected JPopupMenu menu = null;

    public ATextField(int cols) {
        super(cols);
        this.createMenu();
    }

    public ATextField(Document doc, String text, int cols) {
        super(doc, text, cols);
        this.createMenu();
    }

    public ATextField(String text, int cols) {
        super(text, cols);
        this.createMenu();
    }

    public ATextField() {
        this.createMenu();
    }

    public void createMenu() {
        if (this.menu != null) {
            return;
        }
        this.menu = new JPopupMenu();
        JMenuItem cut = new JMenuItem("Cut", 67);
        JMenuItem copy2 = new JMenuItem("Copy", 111);
        JMenuItem paste = new JMenuItem("Paste", 80);
        JMenuItem clear = new JMenuItem("Clear", 108);
        cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ATextField.this.cut();
            }
        });
        copy2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ATextField.this.copy();
            }
        });
        paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ATextField.this.paste();
            }
        });
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ATextField.this.setText("");
            }
        });
        this.menu.add(cut);
        this.menu.add(copy2);
        this.menu.add(paste);
        this.menu.add(clear);
        this.addMouseListener(new MouseAdapter(){

            public void handle(MouseEvent ev) {
                if (ev.isPopupTrigger()) {
                    ATextField.this.menu.show((JComponent)ev.getSource(), ev.getX(), ev.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                this.handle(ev);
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
                this.handle(ev);
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                this.handle(ev);
            }
        });
    }
}

