/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.engine.types.DoubleValue;
import sleep.engine.types.IntValue;
import sleep.engine.types.LongValue;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Operator;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarType;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintUtils;

public class BasicNumbers
implements Predicate,
Operator,
Loadable,
Function {
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        Hashtable hashtable = scriptInstance.getScriptEnvironment().getEnvironment();
        Object object = TaintUtils.Sanitizer(this);
        String[] stringArray = new String[]{"&abs", "&acos", "&asin", "&atan", "&atan2", "&ceil", "&cos", "&log", "&round", "&sin", "&sqrt", "&tan", "&radians", "&degrees", "&exp", "&floor", "&sum"};
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], object);
        }
        hashtable.put("&double", object);
        hashtable.put("&int", object);
        hashtable.put("&uint", object);
        hashtable.put("&long", object);
        hashtable.put("&parseNumber", object);
        hashtable.put("&formatNumber", object);
        hashtable.put("+", object);
        hashtable.put("-", object);
        hashtable.put("/", object);
        hashtable.put("*", object);
        hashtable.put("**", object);
        hashtable.put("% ", object);
        hashtable.put("<<", object);
        hashtable.put(">>", object);
        hashtable.put("&", object);
        hashtable.put("|", object);
        hashtable.put("^", object);
        hashtable.put("&not", object);
        hashtable.put("==", this);
        hashtable.put("!=", this);
        hashtable.put("<=", this);
        hashtable.put(">=", this);
        hashtable.put("<", this);
        hashtable.put(">", this);
        hashtable.put("is", this);
        hashtable.put("&rand", object);
        hashtable.put("&srand", object);
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&abs")) {
            return SleepUtils.getScalar(Math.abs(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&acos")) {
            return SleepUtils.getScalar(Math.acos(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&asin")) {
            return SleepUtils.getScalar(Math.asin(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&atan")) {
            return SleepUtils.getScalar(Math.atan(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&atan2")) {
            return SleepUtils.getScalar(Math.atan2(BridgeUtilities.getDouble(stack, 0.0), BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&ceil")) {
            return SleepUtils.getScalar(Math.ceil(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&floor")) {
            return SleepUtils.getScalar(Math.floor(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&cos")) {
            return SleepUtils.getScalar(Math.cos(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&log") && stack.size() == 1) {
            return SleepUtils.getScalar(Math.log(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&log") && stack.size() == 2) {
            return SleepUtils.getScalar(Math.log(BridgeUtilities.getDouble(stack, 0.0)) / Math.log(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&round")) {
            if (stack.size() == 1) {
                return SleepUtils.getScalar(Math.round(BridgeUtilities.getDouble(stack, 0.0)));
            }
            double d = BridgeUtilities.getDouble(stack, 0.0);
            double d2 = Math.pow(10.0, BridgeUtilities.getInt(stack, 0));
            d = Math.round(d * d2);
            return SleepUtils.getScalar(d /= d2);
        }
        if (string.equals("&sin")) {
            return SleepUtils.getScalar(Math.sin(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&sqrt")) {
            return SleepUtils.getScalar(Math.sqrt(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&tan")) {
            return SleepUtils.getScalar(Math.tan(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&radians")) {
            return SleepUtils.getScalar(Math.toRadians(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&degrees")) {
            return SleepUtils.getScalar(Math.toDegrees(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&exp")) {
            return SleepUtils.getScalar(Math.exp(BridgeUtilities.getDouble(stack, 0.0)));
        }
        if (string.equals("&sum")) {
            Iterator iterator = BridgeUtilities.getIterator(stack, scriptInstance);
            LinkedList<Iterator> linkedList = null;
            if (stack.size() >= 1) {
                linkedList = new LinkedList<Iterator>();
                while (!stack.isEmpty()) {
                    linkedList.add(BridgeUtilities.getIterator(stack, scriptInstance));
                }
            }
            double d = 0.0;
            if (linkedList == null) {
                while (iterator.hasNext()) {
                    d += ((Scalar)iterator.next()).doubleValue();
                }
            } else {
                while (iterator.hasNext()) {
                    double d3 = ((Scalar)iterator.next()).doubleValue();
                    Iterator iterator2 = linkedList.iterator();
                    while (iterator2.hasNext()) {
                        Iterator iterator3 = (Iterator)iterator2.next();
                        if (iterator3.hasNext()) {
                            d3 *= ((Scalar)iterator3.next()).doubleValue();
                            continue;
                        }
                        d3 = 0.0;
                        break;
                    }
                    d += d3;
                }
            }
            return SleepUtils.getScalar(d);
        }
        if (string.equals("&not")) {
            ScalarType scalarType = ((Scalar)stack.pop()).getActualValue();
            if (scalarType.getType() == IntValue.class) {
                return SleepUtils.getScalar(~scalarType.intValue());
            }
            return SleepUtils.getScalar(scalarType.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (string.equals("&long")) {
            Scalar scalar = BridgeUtilities.getScalar(stack);
            return SleepUtils.getScalar(scalar.longValue());
        }
        if (string.equals("&double")) {
            Scalar scalar = BridgeUtilities.getScalar(stack);
            return SleepUtils.getScalar(scalar.doubleValue());
        }
        if (string.equals("&int")) {
            Scalar scalar = BridgeUtilities.getScalar(stack);
            return SleepUtils.getScalar(scalar.intValue());
        }
        if (string.equals("&uint")) {
            int n = BridgeUtilities.getInt(stack, 0);
            long l = 0xFFFFFFFFL & (long)n;
            return SleepUtils.getScalar(l);
        }
        if (string.equals("&parseNumber")) {
            String string2 = BridgeUtilities.getString(stack, "0");
            int n = BridgeUtilities.getInt(stack, 10);
            BigInteger bigInteger = new BigInteger(string2, n);
            return SleepUtils.getScalar(bigInteger.longValue());
        }
        if (string.equals("&formatNumber")) {
            String string3 = BridgeUtilities.getString(stack, "0");
            int n = 10;
            int n2 = 10;
            if (stack.size() == 2) {
                n = BridgeUtilities.getInt(stack, 10);
            }
            n2 = BridgeUtilities.getInt(stack, 10);
            BigInteger bigInteger = new BigInteger(string3, n);
            return SleepUtils.getScalar(bigInteger.toString(n2));
        }
        if (string.equals("&srand")) {
            long l = BridgeUtilities.getLong(stack);
            scriptInstance.getMetadata().put("__RANDOM__", new Random(l));
        } else if (string.equals("&rand")) {
            if (scriptInstance.getMetadata().get("__RANDOM__") == null) {
                scriptInstance.getMetadata().put("__RANDOM__", new Random());
            }
            Random random = (Random)scriptInstance.getMetadata().get("__RANDOM__");
            if (!stack.isEmpty()) {
                Scalar scalar = (Scalar)stack.pop();
                if (scalar.getArray() != null) {
                    int n = random.nextInt(scalar.getArray().size());
                    return scalar.getArray().getAt(n);
                }
                return SleepUtils.getScalar(random.nextInt(scalar.intValue()));
            }
            return SleepUtils.getScalar(random.nextDouble());
        }
        return SleepUtils.getEmptyScalar();
    }

    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        Stack stack2 = scriptInstance.getScriptEnvironment().getEnvironmentStack();
        Scalar scalar = (Scalar)stack.pop();
        Scalar scalar2 = (Scalar)stack.pop();
        if (string.equals("is")) {
            return scalar2.objectValue() == scalar.objectValue();
        }
        ScalarType scalarType = scalar.getActualValue();
        ScalarType scalarType2 = scalar2.getActualValue();
        if (scalarType2.getType() == DoubleValue.class || scalarType.getType() == DoubleValue.class) {
            double d = scalarType2.doubleValue();
            double d2 = scalarType.doubleValue();
            if (string.equals("==")) {
                return d == d2;
            }
            if (string.equals("!=")) {
                return d != d2;
            }
            if (string.equals("<=")) {
                return d <= d2;
            }
            if (string.equals(">=")) {
                return d >= d2;
            }
            if (string.equals("<")) {
                return d < d2;
            }
            if (string.equals(">")) {
                return d > d2;
            }
        } else if (scalarType2.getType() == LongValue.class || scalarType.getType() == LongValue.class) {
            long l = scalarType2.longValue();
            long l2 = scalarType.longValue();
            if (string.equals("==")) {
                return l == l2;
            }
            if (string.equals("!=")) {
                return l != l2;
            }
            if (string.equals("<=")) {
                return l <= l2;
            }
            if (string.equals(">=")) {
                return l >= l2;
            }
            if (string.equals("<")) {
                return l < l2;
            }
            if (string.equals(">")) {
                return l > l2;
            }
        } else {
            int n = scalarType2.intValue();
            int n2 = scalarType.intValue();
            if (string.equals("==")) {
                return n == n2;
            }
            if (string.equals("!=")) {
                return n != n2;
            }
            if (string.equals("<=")) {
                return n <= n2;
            }
            if (string.equals(">=")) {
                return n >= n2;
            }
            if (string.equals("<")) {
                return n < n2;
            }
            if (string.equals(">")) {
                return n > n2;
            }
        }
        return false;
    }

    public Scalar operate(String string, ScriptInstance scriptInstance, Stack stack) {
        ScalarType scalarType = ((Scalar)stack.pop()).getActualValue();
        ScalarType scalarType2 = ((Scalar)stack.pop()).getActualValue();
        if (!(scalarType2.getType() != DoubleValue.class && scalarType.getType() != DoubleValue.class || string.equals(">>") || string.equals("<<") || string.equals("&") || string.equals("|") || string.equals("^"))) {
            double d = scalarType.doubleValue();
            double d2 = scalarType2.doubleValue();
            if (string.equals("+")) {
                return SleepUtils.getScalar(d + d2);
            }
            if (string.equals("-")) {
                return SleepUtils.getScalar(d - d2);
            }
            if (string.equals("*")) {
                return SleepUtils.getScalar(d * d2);
            }
            if (string.equals("/")) {
                return SleepUtils.getScalar(d / d2);
            }
            if (string.equals("% ")) {
                return SleepUtils.getScalar(d % d2);
            }
            if (string.equals("**")) {
                return SleepUtils.getScalar(Math.pow(d, d2));
            }
        } else if (scalarType2.getType() == LongValue.class || scalarType.getType() == LongValue.class) {
            long l = scalarType.longValue();
            long l2 = scalarType2.longValue();
            if (string.equals("+")) {
                return SleepUtils.getScalar(l + l2);
            }
            if (string.equals("-")) {
                return SleepUtils.getScalar(l - l2);
            }
            if (string.equals("*")) {
                return SleepUtils.getScalar(l * l2);
            }
            if (string.equals("/")) {
                return SleepUtils.getScalar(l / l2);
            }
            if (string.equals("% ")) {
                return SleepUtils.getScalar(l % l2);
            }
            if (string.equals("**")) {
                return SleepUtils.getScalar(Math.pow(l, l2));
            }
            if (string.equals(">>")) {
                return SleepUtils.getScalar(l >> (int)l2);
            }
            if (string.equals("<<")) {
                return SleepUtils.getScalar(l << (int)l2);
            }
            if (string.equals("&")) {
                return SleepUtils.getScalar(l & l2);
            }
            if (string.equals("|")) {
                return SleepUtils.getScalar(l | l2);
            }
            if (string.equals("^")) {
                return SleepUtils.getScalar(l ^ l2);
            }
        } else {
            int n = scalarType.intValue();
            int n2 = scalarType2.intValue();
            if (string.equals("+")) {
                return SleepUtils.getScalar(n + n2);
            }
            if (string.equals("-")) {
                return SleepUtils.getScalar(n - n2);
            }
            if (string.equals("*")) {
                return SleepUtils.getScalar(n * n2);
            }
            if (string.equals("/")) {
                return SleepUtils.getScalar(n / n2);
            }
            if (string.equals("% ")) {
                return SleepUtils.getScalar(n % n2);
            }
            if (string.equals("**")) {
                return SleepUtils.getScalar(Math.pow(n, n2));
            }
            if (string.equals(">>")) {
                return SleepUtils.getScalar(n >> n2);
            }
            if (string.equals("<<")) {
                return SleepUtils.getScalar(n << n2);
            }
            if (string.equals("&")) {
                return SleepUtils.getScalar(n & n2);
            }
            if (string.equals("|")) {
                return SleepUtils.getScalar(n | n2);
            }
            if (string.equals("^")) {
                return SleepUtils.getScalar(n ^ n2);
            }
        }
        return SleepUtils.getEmptyScalar();
    }
}

