/*
 * Decompiled with CFR 0.152.
 */
package graph;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxFastOrganicLayout;
import com.mxgraph.layout.mxStackLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.view.mxInteractiveCanvas;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import graph.CircleLayout;
import graph.GraphPopup;
import graph.Refreshable;
import graph.Route;
import graph.TouchMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class NetworkGraph
extends JComponent
implements ActionListener,
Refreshable {
    protected mxGraph graph;
    protected mxGraphComponent component;
    protected Object parent;
    protected Properties display;
    protected boolean isAlive = true;
    protected String layout = null;
    protected Map nodeImages = new HashMap();
    protected GraphPopup popup = null;
    protected double zoom = 1.0;
    protected TouchMap nodes = new TouchMap();
    protected LinkedList edges = new LinkedList();
    protected Map tooltips = new HashMap();

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.isAlive = false;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public GraphPopup getGraphPopup() {
        return this.popup;
    }

    public void setGraphPopup(GraphPopup popup) {
        this.popup = popup;
    }

    public NetworkGraph() {
        this(new Properties());
    }

    public Image getScreenshot() {
        LinkedList<Object> cells = new LinkedList<Object>();
        for (Object node : this.nodes.values()) {
            cells.addAll(Arrays.asList(this.graph.getEdges(node)));
        }
        cells.addAll(this.nodes.values());
        return mxCellRenderer.createBufferedImage(this.graph, cells.toArray(), this.zoom, null, true, null, new NetworkGraphCanvas());
    }

    @Override
    public void setTransferHandler(TransferHandler h) {
        this.component.setTransferHandler(h);
    }

    public void clearSelection() {
        this.graph.clearSelection();
    }

    public void selectAll() {
        this.graph.selectAll();
    }

    public NetworkGraph(Properties display) {
        mxConstants.VERTEX_SELECTION_COLOR = Color.decode(display.getProperty("graph.selection.color", "#00ff00"));
        mxConstants.EDGE_SELECTION_COLOR = Color.decode(display.getProperty("graph.edge.color", "#3c6318"));
        this.display = display;
        this.graph = new mxGraph(){

            @Override
            public String getToolTipForCell(Object cell) {
                if (NetworkGraph.this.tooltips.get(cell) == null) {
                    return "";
                }
                return NetworkGraph.this.tooltips.get(cell) + "";
            }
        };
        this.graph.setAutoOrigin(true);
        this.graph.setCellsEditable(false);
        this.graph.setCellsResizable(false);
        this.graph.setCellsBendable(false);
        this.graph.setAllowDanglingEdges(false);
        this.graph.setSplitEnabled(false);
        this.graph.setKeepEdgesInForeground(false);
        this.graph.setKeepEdgesInBackground(true);
        this.parent = this.graph.getDefaultParent();
        this.component = new NetworkGraphComponent(this.graph);
        this.component.setFoldingEnabled(true);
        this.component.setConnectable(false);
        this.component.setCenterPage(true);
        this.component.setToolTips(true);
        this.graph.setDropEnabled(true);
        new mxRubberband(this.component);
        this.addPopupListener();
        this.component.getViewport().setOpaque(false);
        this.component.setOpaque(true);
        this.component.setBackground(Color.decode(display.getProperty("graph.background.color", "#111111")));
        this.setLayout(new BorderLayout());
        this.add((Component)this.component, "Center");
        this.setupShortcuts();
    }

    public void addActionForKeyStroke(KeyStroke key, Action action) {
        this.component.getActionMap().put(key.toString(), action);
        this.component.getInputMap().put(key, key.toString());
    }

    public void addActionForKey(String key, Action action) {
        this.addActionForKeyStroke(KeyStroke.getKeyStroke(key), action);
    }

    public void addActionForKeySetting(String key, String dvalue, Action action) {
        KeyStroke temp = KeyStroke.getKeyStroke(this.display.getProperty(key, dvalue));
        if (temp != null) {
            this.addActionForKeyStroke(temp, action);
        }
    }

    public void doStackLayout() {
        if (this.layout != null) {
            this.layout = "stack";
        }
        mxStackLayout layout = new mxStackLayout(this.graph, true, 25);
        layout.execute(this.parent);
    }

    public void doHierarchicalLayout() {
        if (this.layout != null) {
            this.layout = "hierarchical";
        }
        mxHierarchicalLayout layout = new mxHierarchicalLayout(this.graph);
        layout.execute(this.parent);
    }

    public void doCircleLayout() {
        if (this.layout != null) {
            this.layout = "circle";
        }
        CircleLayout layout = new CircleLayout(this.graph, 100.0);
        layout.execute(this.parent, this.getWidth(), this.getHeight(), this.zoom);
    }

    public void doTreeLayout() {
        mxFastOrganicLayout layout = new mxFastOrganicLayout(this.graph);
        layout.execute(this.parent);
    }

    private void setupShortcuts() {
        this.addActionForKeySetting("graph.clear_selection.shortcut", "pressed ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkGraph.this.clearSelection();
            }
        });
        this.addActionForKeySetting("graph.select_all.shortcut", "ctrl pressed A", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkGraph.this.selectAll();
            }
        });
        this.addActionForKeySetting("graph.zoom_in.shortcut", "ctrl pressed EQUALS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkGraph.this.zoom(0.1);
            }
        });
        this.addActionForKeySetting("graph.zoom_out.shortcut", "ctrl pressed MINUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkGraph.this.zoom(-0.1);
            }
        });
        this.addActionForKeySetting("graph.zoom_reset.shortcut", "ctrl pressed 0", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkGraph.this.resetZoom();
            }
        });
        this.addActionForKeySetting("graph.arrange_icons_stack.shortcut", "ctrl pressed S", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkGraph.this.doStackLayout();
            }
        });
        this.addActionForKeySetting("graph.arrange_icons_circle.shortcut", "ctrl pressed C", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkGraph.this.doCircleLayout();
            }
        });
        this.addActionForKeySetting("graph.arrange_icons_hierarchical.shortcut", "ctrl pressed H", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkGraph.this.doHierarchicalLayout();
            }
        });
    }

    public String getCellAt(Point p) {
        Point q = this.component.getViewport().getViewPosition();
        Point z = new Point((int)(p.getX() + q.getX()), (int)(p.getY() + q.getY()));
        mxCell cell = (mxCell)this.component.getCellAt((int)z.getX(), (int)z.getY());
        if (cell != null) {
            return cell.getId();
        }
        return null;
    }

    public String[] getSelectedHosts() {
        LinkedList<String> sel = new LinkedList<String>();
        Object[] cells = this.graph.getSelectionCells();
        for (int y = 0; y < cells.length; ++y) {
            mxCell cell = (mxCell)cells[y];
            if (!this.nodes.containsKey(cell.getId())) continue;
            sel.add(cell.getId());
        }
        String[] selected = new String[sel.size()];
        Iterator i = sel.iterator();
        int x = 0;
        while (i.hasNext()) {
            selected[x] = i.next() + "";
            ++x;
        }
        return selected;
    }

    private void addPopupListener() {
        this.component.getGraphControl().addMouseListener(new MouseAdapter(){

            public void handleEvent(MouseEvent ev) {
                if (ev.isPopupTrigger() && NetworkGraph.this.getGraphPopup() != null) {
                    NetworkGraph.this.getGraphPopup().showGraphPopup(NetworkGraph.this.getSelectedHosts(), ev);
                    ev.consume();
                }
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                this.handleEvent(ev);
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                this.handleEvent(ev);
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
                this.handleEvent(ev);
            }
        });
    }

    public void resetZoom() {
        this.zoom = 1.0;
        this.zoom(0.0);
    }

    public void zoom(double factor) {
        this.zoom += factor;
        this.component.zoomTo(this.zoom, true);
    }

    @Override
    public void start() {
        this.graph.getModel().beginUpdate();
        this.nodes.startUpdates();
    }

    public void setAutoLayout(String layout) {
        this.layout = layout;
        this.autoLayout();
    }

    public void autoLayout() {
        if (this.layout == null) {
            return;
        }
        if (this.layout.equals("circle")) {
            this.doCircleLayout();
        }
        if (this.layout.equals("stack")) {
            this.doStackLayout();
        }
        if (this.layout.equals("hierarchical")) {
            this.doHierarchicalLayout();
        }
    }

    @Override
    public void end() {
        this.graph.getModel().endUpdate();
        if (SwingUtilities.isEventDispatchThread()) {
            this.autoLayout();
            this.graph.refresh();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetworkGraph.this.autoLayout();
                    NetworkGraph.this.graph.refresh();
                }
            });
        }
    }

    public void deleteNodes(String[] ids) {
        Object[] cells = new Object[ids.length];
        for (int x = 0; x < ids.length; ++x) {
            cells[x] = this.nodes.remove(ids[x]);
        }
        this.graph.removeCells(cells, true);
    }

    @Override
    public void deleteNodes() {
        List untouched = this.nodes.clearUntouched();
        Object[] cells = new Object[untouched.size()];
        Iterator i = untouched.iterator();
        int x = 0;
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            cells[x] = entry.getValue();
            ++x;
        }
        this.graph.removeCells(cells, true);
    }

    @Override
    public void highlightRoute(String src, String dst) {
        Object[] cells = this.graph.getEdgesBetween(this.nodes.get(src), this.nodes.get(dst), true);
        if (cells.length == 0) {
            return;
        }
        ((mxCell)cells[0]).setStyle("strokeColor=" + this.display.getProperty("graph.edge_highlight.color", "#00ff00") + ";strokeWidth=4");
    }

    @Override
    public void setRoutes(Route[] routes) {
        for (mxCell cell : this.edges) {
            this.graph.getModel().remove(cell);
        }
        this.edges = new LinkedList();
        for (Map.Entry temp : this.nodes.entrySet()) {
            for (int x = 0; x < routes.length; ++x) {
                mxCell start = (mxCell)this.nodes.get(routes[x].getGateway());
                if (start == null || temp.getKey().equals(routes[x].getGateway()) || !routes[x].shouldRoute((String)temp.getKey())) continue;
                mxCell node = (mxCell)temp.getValue();
                mxCell edge = (mxCell)this.graph.insertEdge(this.parent, null, "", start, node);
                edge.setStyle("strokeColor=" + this.display.getProperty("graph.edge.color", "#3c6318") + ";strokeWidth=4");
                this.edges.add(edge);
            }
        }
    }

    @Override
    public Object addNode(String id, String label, String description, Image image, String tooltip) {
        mxCell cell;
        this.nodeImages.put(id, image);
        if (label.length() > 0) {
            description = description.length() > 0 ? description + "\n" + label : label;
        }
        if (!this.nodes.containsKey(id)) {
            cell = (mxCell)this.graph.insertVertex(this.parent, id, description, 0.0, 0.0, 125.0, 97.0);
            this.nodes.put(id, cell);
        } else {
            cell = (mxCell)this.nodes.get(id);
            cell.setValue(description);
        }
        this.nodes.touch(id);
        this.tooltips.put(cell, tooltip);
        StringBuffer style = new StringBuffer();
        style.append("shape=image;image=" + id + ";");
        style.append("fontColor=" + this.display.getProperty("graph.foreground.color", "#cccccc") + ";");
        Font font = Font.decode(this.display.getProperty("graph.font.font", "Monospaced BOLD 14"));
        style.append("fontSize=" + font.getSize() + ";");
        style.append("fontFamily=" + font.getFamily() + ";");
        style.append("fontStyle=" + font.getStyle() + ";");
        style.append("verticalLabelPosition=bottom;verticalAlign=top");
        cell.setStyle(style.toString());
        return cell;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.component.requestFocusInWindow();
    }

    private class NetworkGraphComponent
    extends mxGraphComponent {
        public NetworkGraphComponent(mxGraph graph) {
            super(graph);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.getHorizontalScrollBar().setUnitIncrement(15);
            this.getHorizontalScrollBar().setBlockIncrement(60);
            this.getVerticalScrollBar().setUnitIncrement(15);
            this.getVerticalScrollBar().setBlockIncrement(60);
        }

        @Override
        public mxInteractiveCanvas createCanvas() {
            return new NetworkGraphCanvas();
        }
    }

    private class NetworkGraphCanvas
    extends mxInteractiveCanvas {
        private NetworkGraphCanvas() {
        }

        @Override
        public Image loadImage(String image) {
            if (NetworkGraph.this.nodeImages.containsKey(image)) {
                return (Image)NetworkGraph.this.nodeImages.get(image);
            }
            return super.loadImage(image);
        }
    }
}

