/*
 * Decompiled with CFR 0.152.
 */
package cortana.data;

import cortana.core.EventManager;
import cortana.core.FilterManager;
import cortana.data.DataUtils;
import cortana.data.ManagedData;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import msf.RpcConnection;
import sleep.runtime.Scalar;

public class Loots
extends ManagedData {
    protected RpcConnection client;
    protected EventManager manager;
    protected Map loots = new HashMap();

    public Collection getLoots() {
        return this.loots.values();
    }

    @Override
    public Scalar getScalar() {
        if (this.cache == null) {
            this.cache = FilterManager.convertAll(this.getLoots());
        }
        return this.cache;
    }

    public Loots(RpcConnection client, EventManager manager) {
        this.client = client;
        this.manager = manager;
    }

    protected void fireLootEvents(String name, Iterator changes) {
        if (this.initial) {
            return;
        }
        while (changes.hasNext()) {
            String temp = (String)changes.next();
            Stack<Scalar> arg = new Stack<Scalar>();
            arg.push(FilterManager.convertAll(this.loots.get(temp)));
            this.manager.fireEventAsync(name, arg);
        }
    }

    public void processLoots(Map results) {
        if (!results.containsKey("loots")) {
            return;
        }
        this.cache = null;
        HashSet oldLoots = new HashSet();
        oldLoots.addAll(this.loots.keySet());
        this.loots.clear();
        for (Map temp : (Collection)results.get("loots")) {
            this.loots.put(temp.get("path") + "", temp);
        }
        HashSet currentLoots = new HashSet();
        currentLoots.addAll(this.loots.keySet());
        Set newLoots = DataUtils.difference(currentLoots, oldLoots);
        this.fireLootEvents("loot_add", newLoots.iterator());
        Stack<Scalar> arg = new Stack<Scalar>();
        arg.push(FilterManager.convertAll(this.loots.values()));
        this.manager.fireEventAsync("loots", arg);
        this.initial = false;
    }
}

