/*
 * Decompiled with CFR 0.152.
 */
package armitage;

import armitage.ConsoleClient;
import console.Console;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import msf.MeterpreterSession;

public class MeterpreterClient
implements ActionListener,
MeterpreterSession.MeterpreterCallback {
    protected Console window;
    protected MeterpreterSession session;
    protected ActionListener shellCommand;

    public Console getWindow() {
        return this.window;
    }

    @Override
    public void commandComplete(String sid, Object token, Map response) {
        if (token == this || token == null) {
            this.processRead(response);
        }
    }

    @Override
    public void commandTimeout(String sid, Object token, Map response) {
        this.window.append("[*] Timed out waiting for command to complete.\n");
    }

    private void processRead(Map read2) {
        try {
            if (!"".equals(read2.get("data"))) {
                String text = read2.get("data") + "";
                this.window.append(text);
            }
            if (!"".equals(read2.get("prompt"))) {
                this.window.updatePrompt(ConsoleClient.cleanText(read2.get("prompt") + ""));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public MeterpreterClient(Console window, MeterpreterSession session, ActionListener shellCommand) {
        this.window = window;
        this.session = session;
        this.shellCommand = shellCommand;
        this.session.addListener(this);
        this.setupListener();
        window.updatePrompt("meterpreter > ");
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
    }

    protected void finalize() {
        this.actionPerformed(null);
    }

    public void sendString(String text) {
        this.window.append(this.window.getPromptText() + text);
        this.session.addCommand(this, text);
    }

    protected void setupListener() {
        this.window.getInput().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String text = MeterpreterClient.this.window.getInput().getText() + "\n";
                MeterpreterClient.this.window.getInput().setText("");
                if (MeterpreterClient.this.shellCommand != null && text.trim().startsWith("shell")) {
                    MeterpreterClient.this.shellCommand.actionPerformed(new ActionEvent(MeterpreterClient.this.window, 0, "shell"));
                } else if (MeterpreterClient.this.shellCommand != null && text.trim().equals("screenshot")) {
                    MeterpreterClient.this.shellCommand.actionPerformed(new ActionEvent(MeterpreterClient.this.window, 0, "screenshot"));
                } else if (MeterpreterClient.this.shellCommand != null && text.trim().equals("webcam_snap")) {
                    MeterpreterClient.this.shellCommand.actionPerformed(new ActionEvent(MeterpreterClient.this.window, 0, "webcam_snap"));
                } else if (MeterpreterClient.this.shellCommand != null && text.trim().equals("upload")) {
                    MeterpreterClient.this.shellCommand.actionPerformed(new ActionEvent(MeterpreterClient.this.window, 0, "upload"));
                } else {
                    MeterpreterClient.this.sendString(text);
                }
            }
        });
    }
}

