/*
 * Decompiled with CFR 0.152.
 */
package table;

import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class GenericTableModel
extends AbstractTableModel {
    protected String[] columnNames;
    protected List rows;
    protected String leadColumn;
    protected boolean[] editable;
    protected boolean hidden = false;
    protected List all;
    protected Map imageCache = new HashMap();
    protected float zoom = 1.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showHidden(boolean f) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            if (f != this.hidden) {
                if (f) {
                    this.rows = new ArrayList(this.all.size());
                    this.rows.addAll(this.all);
                } else {
                    Iterator i = this.rows.iterator();
                    while (i.hasNext()) {
                        Map temp = (Map)i.next();
                        if (!"1".equals(temp.get("Hide"))) continue;
                        i.remove();
                    }
                }
            }
            this.hidden = f;
        }
    }

    public List getRows() {
        return this.rows;
    }

    public GenericTableModel(String[] columnNames, String leadColumn, int anticipatedSize) {
        this.columnNames = columnNames;
        this.leadColumn = leadColumn;
        this.rows = new ArrayList(anticipatedSize);
        this.all = new ArrayList(anticipatedSize);
        this.editable = new boolean[columnNames.length];
        for (int x = 0; x < this.editable.length; ++x) {
            this.editable[x] = false;
        }
    }

    public void setCellEditable(int column) {
        this.editable[column] = true;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.editable[column];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getSelectedValues(JTable t) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            int[] row = t.getSelectedRows();
            Object[] rv = new Object[row.length];
            for (int x = 0; x < row.length; ++x) {
                int r = t.convertRowIndexToModel(row[x]);
                rv[x] = r < this.rows.size() && r >= 0 ? ((Map)this.rows.get(r)).get(this.leadColumn) : null;
            }
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] getSelectedValuesFromColumns(JTable t, String[] cols) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            int[] row = t.getSelectedRows();
            Object[][] rv = new Object[row.length][cols.length];
            for (int x = 0; x < row.length; ++x) {
                int r = t.convertRowIndexToModel(row[x]);
                for (int y = 0; y < cols.length; ++y) {
                    rv[x][y] = ((Map)this.rows.get(r)).get(cols[y]);
                }
            }
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSelectedValue(JTable t) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            Object[] values = this.getSelectedValues(t);
            if (values.length == 0) {
                return null;
            }
            return values[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getImageAt(JTable t, int row, String column, float zoomnow) {
        Image i = (Image)this.getValueAt(t, row, column);
        if (this.zoom != zoomnow) {
            this.zoom = zoomnow;
            this.imageCache = new HashMap();
        }
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            if (this.imageCache.containsKey(i)) {
                return (Image)this.imageCache.get(i);
            }
        }
        Image rs = i.getScaledInstance((int)Math.floor((double)i.getWidth(null) / 11.0 * (double)this.zoom), (int)Math.floor((double)i.getHeight(null) / 11.0 * (double)this.zoom), 4);
        GenericTableModel genericTableModel2 = this;
        synchronized (genericTableModel2) {
            this.imageCache.put(i, rs);
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(JTable t, int row, String column) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            row = t.convertRowIndexToModel(row);
            if (row == -1) {
                return null;
            }
            return ((Map)this.rows.get(row)).get(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedRow(JTable t) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            return t.convertRowIndexToModel(t.getSelectedRow());
        }
    }

    public void _setValueAtRow(int row, String column, String value) {
        ((Map)this.rows.get(row)).put(column, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueForKey(String key, String column, String value) {
        int row = -1;
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            Iterator i = this.rows.iterator();
            int x = 0;
            while (i.hasNext()) {
                Map temp = (Map)i.next();
                if (key.equals(temp.get(this.leadColumn))) {
                    row = x;
                    break;
                }
                ++x;
            }
        }
        if (row != -1) {
            this.setValueAtRow(row, column, value);
        }
    }

    public void setValueAtRow(final int row, final String column, final String value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._setValueAtRow(row, column, value);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenericTableModel.this._setValueAtRow(row, column, value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSelectedValueFromColumn(JTable t, String column) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            int row = t.getSelectedRow();
            if (row == -1) {
                return null;
            }
            return this.getValueAt(t, row, column);
        }
    }

    @Override
    public String getColumnName(int x) {
        return this.columnNames[x];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public void addEntry(final Map row) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._addEntry(row);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenericTableModel.this._addEntry(row);
                }
            });
        }
    }

    public void clear(final int newSize) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._clear(newSize);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenericTableModel.this._clear(newSize);
                }
            });
        }
    }

    public void fireListeners() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fireTableDataChanged();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenericTableModel.this.fireTableDataChanged();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _addEntry(Map row) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            if (this.hidden || !"1".equals(row.get("Hide"))) {
                this.rows.add(row);
            }
            this.all.add(row);
            int size = this.rows.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _clear(int anticipatedSize) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            this.rows = new ArrayList(anticipatedSize);
            this.all = new ArrayList(anticipatedSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            return this.rows.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAtColumn(JTable t, int row, String col) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            row = t.convertRowIndexToModel(row);
            Map temp = (Map)this.rows.get(row);
            return temp.get(col);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int col) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            if (row < this.rows.size()) {
                Map temp = (Map)this.rows.get(row);
                return temp.get(this.getColumnName(col));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object value, int row, int col) {
        GenericTableModel genericTableModel = this;
        synchronized (genericTableModel) {
            Map temp = (Map)this.rows.get(row);
            temp.put(this.getColumnName(col), value);
        }
    }
}

