/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import java.io.Serializable;
import sleep.engine.Block;
import sleep.interfaces.Predicate;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Check
implements Serializable {
    private Check iftrue;
    private Check iffalse;
    private Block setup;
    private boolean negate;
    public String name;
    private int hint = -1;

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("[Predicate]: ");
        stringBuffer.append("name->");
        stringBuffer.append(this.name);
        stringBuffer.append("  negated->");
        stringBuffer.append(this.negate);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("   ");
        stringBuffer.append("[Setup]: \n");
        stringBuffer.append(this.setup.toString(string + "      "));
        if (this.iftrue != null) {
            stringBuffer.append(string);
            stringBuffer.append("   [AND]: \n");
            stringBuffer.append(this.iftrue.toString(string + "      "));
        }
        if (this.iffalse != null) {
            stringBuffer.append(string);
            stringBuffer.append("   [OR]: \n");
            stringBuffer.append(this.iffalse.toString(string + "      "));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public Check(String string, Block block) {
        if (string.charAt(0) == '!' && string.length() > 2) {
            this.name = string.substring(1, string.length());
            this.negate = true;
        } else {
            this.name = string;
            this.negate = false;
        }
        this.setup = block;
        this.iftrue = null;
        this.iffalse = null;
    }

    public void setChoices(Check check, Check check2) {
        if (check != null) {
            this.iftrue = check;
        }
        if (check2 != null) {
            this.iffalse = check2;
        }
    }

    public void setInfo(int n) {
        this.hint = n;
    }

    public boolean check(ScriptEnvironment scriptEnvironment) {
        boolean bl;
        scriptEnvironment.CreateFrame();
        this.setup.evaluate(scriptEnvironment);
        Predicate predicate = scriptEnvironment.getPredicate(this.name);
        if (predicate == null) {
            scriptEnvironment.getScriptInstance().fireWarning("Attempted to use non-existent predicate: " + this.name, this.hint);
            bl = false;
        } else if ((scriptEnvironment.getScriptInstance().getDebugFlags() & 0x40) == 64) {
            StringBuffer stringBuffer = new StringBuffer(64);
            if (scriptEnvironment.getCurrentFrame().size() >= 2) {
                stringBuffer.append(SleepUtils.describe((Scalar)scriptEnvironment.getCurrentFrame().get(0)));
                stringBuffer.append(" ");
                if (this.negate) {
                    stringBuffer.append("!");
                }
                stringBuffer.append(this.name);
                stringBuffer.append(" ");
                stringBuffer.append(SleepUtils.describe((Scalar)scriptEnvironment.getCurrentFrame().get(1)));
            } else if (scriptEnvironment.getCurrentFrame().size() == 1) {
                if (this.negate) {
                    stringBuffer.append("!");
                }
                stringBuffer.append(this.name);
                stringBuffer.append(" ");
                stringBuffer.append(SleepUtils.describe((Scalar)scriptEnvironment.getCurrentFrame().get(0)));
            } else {
                stringBuffer.append("corrupted stack frame: " + this.name);
            }
            bl = predicate.decide(this.name, scriptEnvironment.getScriptInstance(), scriptEnvironment.getCurrentFrame());
            stringBuffer.append(" ? ");
            if (this.negate) {
                stringBuffer.append((!bl + "").toUpperCase());
            } else {
                stringBuffer.append((bl + "").toUpperCase());
            }
            scriptEnvironment.getScriptInstance().fireWarning(stringBuffer.toString(), this.hint, true);
        } else {
            bl = predicate.decide(this.name, scriptEnvironment.getScriptInstance(), scriptEnvironment.getCurrentFrame());
        }
        scriptEnvironment.KillFrame();
        if (this.negate) {
            boolean bl2 = bl = !bl;
        }
        if (bl) {
            if (this.iftrue != null) {
                return this.iftrue.check(scriptEnvironment);
            }
            return true;
        }
        if (this.iffalse != null) {
            return this.iffalse.check(scriptEnvironment);
        }
        return false;
    }
}

