/*
 * Decompiled with CFR 0.152.
 */
package msf;

import armitage.ArmitageBuffer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import msf.Async;
import msf.RpcCallback;
import msf.RpcConnection;
import msf.RpcQueue;

public abstract class RpcConnectionImpl
implements RpcConnection,
Async {
    protected String rpcToken;
    private Map callCache = new HashMap();
    protected RpcConnection database = null;
    protected Map hooks = new HashMap();
    protected RpcQueue queue = null;
    protected boolean connected = true;
    protected HashMap locks = new HashMap();
    protected String address = "";
    protected HashMap buffers = new HashMap();

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isResponsive() {
        return true;
    }

    @Override
    public void disconnect() {
        this.connected = false;
    }

    public void addHook(String name, RpcConnection hook) {
        this.hooks.put(name, hook);
    }

    public void setDatabase(RpcConnection connection) {
        this.database = connection;
    }

    public RpcConnectionImpl() {
    }

    public RpcConnectionImpl(String username, String password, String host, int port, boolean secure, boolean debugf) {
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map exec(String methname, Object[] params) {
        try {
            RpcConnectionImpl rpcConnectionImpl = this;
            synchronized (rpcConnectionImpl) {
                this.writeCall(methname, params);
                Object response = this.readResp();
                if (response instanceof Map) {
                    return (Map)response;
                }
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("response", response);
                return temp;
            }
        }
        catch (RuntimeException rex) {
            if ("module.execute".equals(methname)) {
                HashMap<String, String> temp = new HashMap<String, String>();
                temp.put("error", rex.getMessage());
                return temp;
            }
            throw rex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void execute_async(String methodName) {
        this.execute_async(methodName, new Object[0], null);
    }

    @Override
    public void execute_async(String methodName, Object[] args) {
        this.execute_async(methodName, args, null);
    }

    @Override
    public void execute_async(String methodName, Object[] args, RpcCallback callback) {
        if (this.queue == null) {
            this.queue = new RpcQueue(this);
        }
        this.queue.execute(methodName, args, callback);
    }

    @Override
    public Object execute(String methodName) throws IOException {
        return this.execute(methodName, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArmitageBuffer getABuffer(String key) {
        HashMap hashMap = this.buffers;
        synchronized (hashMap) {
            ArmitageBuffer buffer;
            if (this.buffers.containsKey(key)) {
                buffer = (ArmitageBuffer)this.buffers.get(key);
            } else {
                buffer = new ArmitageBuffer(16384L);
                this.buffers.put(key, buffer);
            }
            return buffer;
        }
    }

    public String getLocalAddress() {
        return this.address;
    }

    @Override
    public Object execute(String methodName, Object[] params) throws IOException {
        if (this.database != null && "db.".equals(methodName.substring(0, 3))) {
            return this.database.execute(methodName, params);
        }
        if (methodName.equals("armitage.ping")) {
            try {
                long time = System.currentTimeMillis() - Long.parseLong(params[0] + "");
                HashMap<String, String> res = new HashMap<String, String>();
                res.put("result", time + "");
                return res;
            }
            catch (Exception ex) {
                HashMap<String, String> res = new HashMap<String, String>();
                res.put("result", "0");
                return res;
            }
        }
        if (methodName.equals("armitage.my_ip")) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("result", this.address);
            return res;
        }
        if (methodName.equals("armitage.set_ip")) {
            this.address = params[0] + "";
            return new HashMap();
        }
        if (methodName.equals("armitage.lock")) {
            if (this.locks.containsKey(params[0] + "")) {
                HashMap<String, String> res = new HashMap<String, String>();
                res.put("error", "session already locked\n" + this.locks.get(params[0] + ""));
                return res;
            }
            this.locks.put(params[0] + "", params[1]);
            return new HashMap();
        }
        if (methodName.equals("armitage.unlock")) {
            this.locks.remove(params[0] + "");
            return new HashMap();
        }
        if (methodName.equals("armitage.publish")) {
            ArmitageBuffer buffer = this.getABuffer(params[0] + "");
            buffer.put(params[1] + "");
            return new HashMap();
        }
        if (methodName.equals("armitage.query")) {
            ArmitageBuffer buffer = this.getABuffer(params[0] + "");
            String data = buffer.get(params[1] + "");
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put("data", data);
            return temp;
        }
        if (methodName.equals("armitage.reset")) {
            ArmitageBuffer buffer = this.getABuffer(params[0] + "");
            buffer.reset();
            return new HashMap();
        }
        if (methodName.equals("armitage.sleep")) {
            try {
                Thread.sleep(Integer.parseInt(params[0] + ""));
            }
            catch (Exception ex) {
                // empty catch block
            }
            return new HashMap();
        }
        if (this.hooks.containsKey(methodName)) {
            RpcConnection con = (RpcConnection)this.hooks.get(methodName);
            return con.execute(methodName, params);
        }
        Object[] paramsNew = new Object[params.length + 1];
        paramsNew[0] = this.rpcToken;
        System.arraycopy(params, 0, paramsNew, 1, params.length);
        Object result = this.cacheExecute(methodName, paramsNew);
        return result;
    }

    private Object cacheExecute(String methodName, Object[] params) throws IOException {
        if (methodName.equals("module.info") || methodName.equals("module.options") || methodName.equals("module.compatible_payloads") || methodName.equals("core.version")) {
            StringBuilder keysb = new StringBuilder(methodName);
            for (int i = 1; i < params.length; ++i) {
                keysb.append(params[i].toString());
            }
            String key = keysb.toString();
            Object result = this.callCache.get(key);
            if (result != null) {
                return result;
            }
            result = this.exec(methodName, params);
            this.callCache.put(key, result);
            return result;
        }
        return this.exec(methodName, params);
    }

    protected abstract void writeCall(String var1, Object[] var2) throws Exception;

    protected abstract Object readResp() throws Exception;
}

